/* This is a replacement of Matt Chapman's original makeperm.c
   which was used to generate "permutation files". It's much faster
   (probably 1000 times faster...) than the original. There was no
   reason to stick with the old way of reading an external permutation 
   file...   
   Has been integrated and hardcoded in cmove.c (change by J.-P. Demailly)
*/

#include <stdio.h>

#define NUM 7
int main(int argc, char **argv)
{
FILE *fd;
int i,j,k,l,p,q,s, perm[NUM], isfree[NUM];

   fd=fopen("permutations", "w");

   s = 1;
   for (i=0; i<NUM; i++)
     {
     s *= NUM-i;
     fprintf(fd, "%d\n", s);
     }

   s = 1;
   for (i=0; i<NUM; i++)
     {
     s *= (NUM-i);
     for (j=0; j<s; j++)
       {
       q=j;
       for (k=i; k>=0; k--)
	 {
         perm[k]=q%(NUM-k);
         q=q/(NUM-k);
	 }
       for (k=0; k<NUM; k++) isfree[k]=1;
       for (k=0; k<=i; k++)
	 {
         p=-1;
         for (l=0; l<NUM; l++) 
	   {
           p += isfree[l];
           if (p==perm[k]) 
	     {
             perm[k]=l;
             isfree[l]=0;
             break;
	     }
	   }
	 }
         for (k=0; k<=i; k++) fprintf(fd, "%c", perm[k]);
         fprintf(fd,"\n");
       }
     }   
   fclose(fd);
}

