/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.optimizers.impl.refl;

import java.lang.reflect.Method;
import org.mvel.AccessorNode;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.ExecutableStatement;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.impl.refl.GetterAccessor;

public class MethodAccessor
implements AccessorNode {
    private AccessorNode nextNode;
    private Method method;
    private Class[] parameterTypes;
    private ExecutableStatement[] parms;
    private int length;
    private boolean coercionNeeded = false;

    @Override
    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory vars) {
        if (!this.coercionNeeded) {
            try {
                if (this.nextNode != null) {
                    return this.nextNode.getValue(this.method.invoke(ctx, this.executeAll(elCtx, vars)), elCtx, vars);
                }
                return this.method.invoke(ctx, this.executeAll(elCtx, vars));
            }
            catch (IllegalArgumentException e) {
                this.coercionNeeded = true;
                return this.getValue(ctx, elCtx, vars);
            }
            catch (Exception e) {
                throw new CompileException("cannot invoke method", e);
            }
        }
        try {
            if (this.nextNode != null) {
                return this.nextNode.getValue(this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars)), elCtx, vars);
            }
            return this.method.invoke(ctx, this.executeAndCoerce(this.parameterTypes, elCtx, vars));
        }
        catch (Exception e) {
            throw new CompileException("cannot invoke method", e);
        }
    }

    private Object[] executeAll(Object ctx, VariableResolverFactory vars) {
        if (this.length == 0) {
            return GetterAccessor.EMPTY;
        }
        Object[] vals = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            vals[i] = this.parms[i].getValue(ctx, vars);
        }
        return vals;
    }

    private Object[] executeAndCoerce(Class[] target, Object elCtx, VariableResolverFactory vars) {
        Object[] values = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            values[i] = DataConversion.convert(this.parms[i].getValue(elCtx, vars), target[i]);
        }
        return values;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
        this.parameterTypes = this.method.getParameterTypes();
        this.length = this.parameterTypes.length;
    }

    public ExecutableStatement[] getParms() {
        return this.parms;
    }

    public void setParms(ExecutableStatement[] parms) {
        this.parms = parms;
    }

    @Override
    public AccessorNode getNextNode() {
        return this.nextNode;
    }

    @Override
    public AccessorNode setNextNode(AccessorNode nextNode) {
        this.nextNode = nextNode;
        return this.nextNode;
    }
}

