/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.typography.hershey;

import java.io.IOException;
import java.io.InputStream;

final class HersheyFontData {
    private static final int MAX_CHARACTERS = 256;
    private static final int MAX_POINTS = 150;
    protected static final int X = 0;
    protected static final int Y = 1;
    protected String name;
    protected char[][][] characterVectors = new char[256][2][150];
    protected int[] numberOfPoints = new int[256];
    protected int[] characterMinX;
    protected int[] characterMaxX;
    protected int characterSetMinY;
    protected int characterSetMaxY;
    protected int charactersInSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HersheyFontData(String name) throws IOException {
        InputStream fontStream = null;
        this.name = name;
        try {
            fontStream = this.getClass().getResourceAsStream("/org/openimaj/image/typography/font/hershey/" + name);
            this.loadHersheyFont(name, fontStream);
        }
        finally {
            if (fontStream != null) {
                try {
                    fontStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void loadHersheyFont(String fontname, InputStream fontStream) throws IOException {
        int xadjust = this.fontAdjustment(fontname);
        int character = 0;
        while (true) {
            int n;
            if (this.getInt(fontStream, 5) < 1) break;
            this.numberOfPoints[character] = n = this.getInt(fontStream, 3);
            for (int i = 0; i < n; ++i) {
                int c;
                if (i == 32 || i == 68 || i == 104 || i == 140) {
                    fontStream.read();
                }
                if ((c = fontStream.read()) == 10) {
                    c = fontStream.read();
                }
                this.characterVectors[character][0][i] = (char)c;
                this.characterVectors[character][1][i] = (char)fontStream.read();
            }
            fontStream.read();
            ++character;
        }
        this.charactersInSet = character;
        this.characterMinX = new int[this.charactersInSet];
        this.characterMaxX = new int[this.charactersInSet];
        this.characterSetMinY = 1000;
        this.characterSetMaxY = -1000;
        for (int j = 1; j < this.charactersInSet; ++j) {
            this.calculateCharacterSize(j, xadjust);
        }
        if (65 <= this.charactersInSet) {
            this.characterMinX[0] = this.characterMinX[65];
            this.characterMaxX[0] = this.characterMaxX[65];
        } else {
            this.characterMinX[0] = this.characterMinX[this.charactersInSet - 1];
            this.characterMaxX[0] = this.characterMaxX[this.charactersInSet - 1];
        }
    }

    private void calculateCharacterSize(int j, int xadj) {
        this.characterMinX[j] = 1000;
        this.characterMaxX[j] = -1000;
        for (int i = 1; i < this.numberOfPoints[j]; ++i) {
            int cx = this.characterVectors[j][0][i];
            int cy = this.characterVectors[j][1][i];
            if (cx == 32) continue;
            if (cx < this.characterMinX[j]) {
                this.characterMinX[j] = cx;
            }
            if (cx > this.characterMaxX[j]) {
                this.characterMaxX[j] = cx;
            }
            if (cy < this.characterSetMinY) {
                this.characterSetMinY = cy;
            }
            if (cy <= this.characterSetMaxY) continue;
            this.characterSetMaxY = cy;
        }
        int n = j;
        this.characterMinX[n] = this.characterMinX[n] - xadj;
        int n2 = j;
        this.characterMaxX[n2] = this.characterMaxX[n2] + xadj;
    }

    private int fontAdjustment(String fontname) {
        int xadjust = 0;
        if (fontname.indexOf("scri") < 0) {
            xadjust = fontname.indexOf("goth") >= 0 ? 2 : 3;
        }
        return xadjust;
    }

    public String toString() {
        return this.name;
    }

    private int getInt(InputStream file, int n) throws IOException {
        int j = 0;
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            int c = file.read();
            while (c == 10 || c == 13) {
                c = file.read();
            }
            if (c == -1) {
                return c;
            }
            if ((char)c == ' ') continue;
            buf[j++] = (char)c;
        }
        return Integer.parseInt(String.copyValueOf(buf, 0, j));
    }
}

