/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.renderer;

import org.openimaj.image.MultiBandImage;
import org.openimaj.image.SingleBandImage;
import org.openimaj.image.renderer.ImageRenderer;
import org.openimaj.image.renderer.RenderHints;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.shape.Polygon;

public abstract class MultiBandRenderer<T extends Comparable<T>, I extends MultiBandImage<T, I, S>, S extends SingleBandImage<T, S>>
extends ImageRenderer<T[], I> {
    public MultiBandRenderer(I targetImage) {
        super(targetImage);
    }

    public MultiBandRenderer(I targetImage, RenderHints hints) {
        super(targetImage, hints);
    }

    @Override
    public void drawImage(S image, int x, int y) {
        for (SingleBandImage band : ((MultiBandImage)this.targetImage).bands) {
            band.createRenderer(this.hints).drawImage(image, x, y);
        }
    }

    public void drawImage(S image, int band, int x, int y) {
        ((SingleBandImage)((MultiBandImage)this.targetImage).bands.get(band)).createRenderer(this.hints).drawImage(image, x, y);
    }

    @Override
    public void drawLine(int x1, int y1, double theta, int length, int thickness, T[] grey) {
        grey = (Comparable[])this.sanitise(grey);
        for (int i = 0; i < ((MultiBandImage)this.targetImage).bands.size(); ++i) {
            ((SingleBandImage)((MultiBandImage)this.targetImage).bands.get(i)).createRenderer(this.hints).drawLine(x1, y1, theta, length, thickness, grey[i]);
        }
    }

    @Override
    public void drawLine(int x0, int y0, int x1, int y1, int thickness, T[] grey) {
        grey = (Comparable[])this.sanitise(grey);
        for (int i = 0; i < ((MultiBandImage)this.targetImage).bands.size(); ++i) {
            ((SingleBandImage)((MultiBandImage)this.targetImage).bands.get(i)).createRenderer(this.hints).drawLine(x0, y0, x1, y1, thickness, grey[i]);
        }
    }

    @Override
    public void drawLine(float x0, float y0, float x1, float y1, int thickness, T[] grey) {
        grey = (Comparable[])this.sanitise(grey);
        for (int i = 0; i < ((MultiBandImage)this.targetImage).bands.size(); ++i) {
            ((SingleBandImage)((MultiBandImage)this.targetImage).bands.get(i)).createRenderer(this.hints).drawLine(x0, y0, x1, y1, thickness, grey[i]);
        }
    }

    @Override
    public void drawPoint(Point2d p, T[] col, int size) {
        col = (Comparable[])this.sanitise(col);
        for (int i = 0; i < ((MultiBandImage)this.targetImage).bands.size(); ++i) {
            ((SingleBandImage)((MultiBandImage)this.targetImage).bands.get(i)).createRenderer(this.hints).drawPoint(p, col[i], size);
        }
    }

    @Override
    public void drawPolygon(Polygon p, int thickness, T[] grey) {
        grey = (Comparable[])this.sanitise(grey);
        for (int i = 0; i < ((MultiBandImage)this.targetImage).bands.size(); ++i) {
            ((SingleBandImage)((MultiBandImage)this.targetImage).bands.get(i)).createRenderer(this.hints).drawPolygon(p, thickness, grey[i]);
        }
    }
}

