/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processor.connectedcomponent.render;

import org.openimaj.image.Image;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processor.connectedcomponent.render.AbstractRenderer;
import org.openimaj.image.renderer.ImageRenderer;

public class AxisRenderer<T>
extends AbstractRenderer<T> {
    int majorSize = 100;
    int minorSize = 50;

    public AxisRenderer(Image<T, ?> image, T colour) {
        super(image, colour);
    }

    public AxisRenderer(int width, int height, T colour) {
        super(width, height, colour);
    }

    @Override
    public void process(ConnectedComponent cc) {
        Pixel cp = cc.calculateCentroidPixel();
        double theta = cc.calculateDirection();
        ImageRenderer r = this.image.createRenderer();
        r.drawLine(cp.x, cp.y, theta, this.majorSize, this.colour);
        r.drawLine(cp.x, cp.y, theta, -this.majorSize, this.colour);
        r.drawLine(cp.x, cp.y, 1.5707963267948966 + theta, this.minorSize, this.colour);
        r.drawLine(cp.x, cp.y, 1.5707963267948966 + theta, -this.minorSize, this.colour);
    }
}

