/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.sampling;

import org.openimaj.image.FImage;
import org.openimaj.image.pixel.sampling.LineSampler;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;

public enum FLineSampler implements LineSampler<FImage, float[]>
{
    PIXELSTEP_NEAREST_NEIGHBOUR{

        @Override
        public float[] extractSamples(Line2d line, FImage image, int numSamples) {
            Line2d scaled = this.getSampleLine(line, image, numSamples);
            return NEAREST_NEIGHBOUR.extractSamples(scaled, image, numSamples);
        }

        @Override
        public Line2d getSampleLine(Line2d line, FImage image, int numSamples) {
            Line2d scaled = line.clone();
            scaled.scaleCentroid((float)((double)numSamples / line.calculateLength()));
            return scaled;
        }
    }
    ,
    NEAREST_NEIGHBOUR{

        @Override
        public float[] extractSamples(Line2d line, FImage image, int numSamples) {
            float[] samples = new float[numSamples];
            Point2d p1 = line.getBeginPoint();
            Point2d p2 = line.getEndPoint();
            float x = p1.getX();
            float y = p1.getY();
            float dxStep = (p2.getX() - x) / (float)(numSamples - 1);
            float dyStep = (p2.getY() - y) / (float)(numSamples - 1);
            int width = image.width;
            int height = image.height;
            for (int i = 0; i < numSamples; ++i) {
                int ix = Math.round(x);
                int iy = Math.round(y);
                samples[i] = ix < 0 || ix >= width || iy < 0 || iy >= height ? 0.0f : image.getPixelNative(ix, iy);
                x += dxStep;
                y += dyStep;
            }
            return samples;
        }
    }
    ,
    PIXELSTEP_INTERPOLATED{

        @Override
        public float[] extractSamples(Line2d line, FImage image, int numSamples) {
            Line2d scaled = this.getSampleLine(line, image, numSamples);
            return INTERPOLATED.extractSamples(scaled, image, numSamples);
        }

        @Override
        public Line2d getSampleLine(Line2d line, FImage image, int numSamples) {
            Line2d scaled = line.clone();
            scaled.scaleCentroid((float)((double)numSamples / line.calculateLength()));
            return scaled;
        }
    }
    ,
    INTERPOLATED{

        @Override
        public float[] extractSamples(Line2d line, FImage image, int numSamples) {
            float[] samples = new float[numSamples];
            Point2d p1 = line.getBeginPoint();
            Point2d p2 = line.getEndPoint();
            float x = p1.getX();
            float y = p1.getY();
            float dxStep = (p2.getX() - x) / (float)(numSamples - 1);
            float dyStep = (p2.getY() - y) / (float)(numSamples - 1);
            for (int i = 0; i < numSamples; ++i) {
                samples[i] = image.getPixelInterpNative(x, y, 0.0f);
                x += dxStep;
                y += dyStep;
            }
            return samples;
        }
    }
    ,
    PIXELSTEP_NEAREST_NEIGHBOUR_DERIVATIVE{

        @Override
        public float[] extractSamples(Line2d line, FImage image, int numSamples) {
            Line2d scaled = this.getSampleLine(line, image, numSamples + 2);
            return NEAREST_NEIGHBOUR_DERIVATIVE.extractSamples(scaled, image, numSamples);
        }

        @Override
        public Line2d getSampleLine(Line2d line, FImage image, int numSamples) {
            Line2d scaled = line.clone();
            scaled.scaleCentroid((float)((double)numSamples / line.calculateLength()));
            return scaled;
        }
    }
    ,
    NEAREST_NEIGHBOUR_DERIVATIVE{

        @Override
        public float[] extractSamples(Line2d line, FImage image, int numSamples) {
            float[] samples = NEAREST_NEIGHBOUR.extractSamples(line, image, numSamples + 2);
            return FLineSampler.computeDerivative(samples);
        }
    }
    ,
    PIXELSTEP_INTERPOLATED_DERIVATIVE{

        @Override
        public float[] extractSamples(Line2d line, FImage image, int numSamples) {
            Line2d scaled = this.getSampleLine(line, image, numSamples + 2);
            return NEAREST_NEIGHBOUR_DERIVATIVE.extractSamples(scaled, image, numSamples);
        }

        @Override
        public Line2d getSampleLine(Line2d line, FImage image, int numSamples) {
            Line2d scaled = line.clone();
            scaled.scaleCentroid((float)((double)numSamples / line.calculateLength()));
            return scaled;
        }
    }
    ,
    INTERPOLATED_DERIVATIVE{

        @Override
        public float[] extractSamples(Line2d line, FImage image, int numSamples) {
            float[] samples = INTERPOLATED.extractSamples(line, image, numSamples + 2);
            return FLineSampler.computeDerivative(samples);
        }
    };


    private static float[] computeDerivative(float[] samples) {
        int numSamples = samples.length - 2;
        float[] dsamples = new float[numSamples];
        for (int i = 0; i < numSamples; ++i) {
            dsamples[i] = samples[i] - samples[i + 2];
        }
        return dsamples;
    }

    @Override
    public Line2d getSampleLine(Line2d line, FImage image, int numSamples) {
        return line;
    }

    @Override
    public abstract float[] extractSamples(Line2d var1, FImage var2, int var3);
}

