/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extension.r;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public final class SystemCall {
    public static void main(String[] args) {
        String anOutput = "";
        if (args.length == 0) {
            anOutput = Exec.execute("R --version", new String[0]);
        } else {
            String[] someParameters = null;
            anOutput = Exec.execute(args[0], someParameters);
        }
        System.out.println("Final output: " + anOutput);
    }

    private SystemCall() {
    }

    public static class UnixShell
    implements IShell {
        @Override
        public final String getShellCommand() {
            return "/bin/sh -c";
        }
    }

    public static class WindowsShell
    implements IShell {
        @Override
        public final String getShellCommand() {
            String osName = System.getProperty("os.name");
            if (osName.equals("Windows 95")) {
                return "command.com /C";
            }
            return "cmd.exe /C";
        }
    }

    public static interface IShell {
        public String getShellCommand();
    }

    public static final class UnixExecEnvFactory
    extends ExecEnvironmentFactory {
        public UnixExecEnvFactory(String aCommand, String ... someParameters) {
            super(aCommand, someParameters);
        }

        @Override
        public IShell createShell() {
            return new UnixShell();
        }

        @Override
        public String createCommandLine() {
            String aCommand = this.getCommand();
            if (aCommand.toLowerCase().trim().equals("dir")) {
                aCommand = "ls";
            }
            return this.buildCommandLine(aCommand, this.getParameters());
        }
    }

    public static final class WindowsExecEnvFactory
    extends ExecEnvironmentFactory {
        public WindowsExecEnvFactory(String aCommand, String ... someParameters) {
            super(aCommand, someParameters);
        }

        @Override
        public IShell createShell() {
            return new WindowsShell();
        }

        @Override
        public String createCommandLine() {
            String aCommand = this.getCommand();
            if (aCommand.toLowerCase().trim().equals("ls")) {
                aCommand = "dir";
            }
            return this.buildCommandLine(aCommand, this.getParameters());
        }
    }

    public static abstract class ExecEnvironmentFactory {
        private String command = null;
        private ArrayList<String> parameters = new ArrayList();

        final String getCommand() {
            return this.command;
        }

        final ArrayList<String> getParameters() {
            return this.parameters;
        }

        public ExecEnvironmentFactory(String aCommand, String ... someParameters) {
            if (aCommand == null || aCommand.length() == 0) {
                throw new IllegalArgumentException("Command must not be empty");
            }
            this.command = aCommand;
            for (int i = 0; i < someParameters.length; ++i) {
                String aParameter = someParameters[i];
                if (aParameter == null || aParameter.length() == 0) {
                    throw new IllegalArgumentException("Parameter # '" + i + "' must not be empty");
                }
                this.parameters.add(aParameter);
            }
        }

        public abstract IShell createShell();

        public abstract String createCommandLine();

        protected final String buildCommandLine(String aCommand, ArrayList<String> someParameters) {
            StringBuilder aCommandLine = new StringBuilder();
            aCommandLine.append(aCommand);
            for (String aParameter : someParameters) {
                aCommandLine.append(" ");
                aCommandLine.append(aParameter);
            }
            return aCommandLine.toString();
        }
    }

    public static final class Exec {
        public static String execute(String aCommand, String ... someParameters) {
            String output = "";
            try {
                ExecEnvironmentFactory anExecEnvFactory = Exec.getExecEnvironmentFactory(aCommand, someParameters);
                IShell aShell = anExecEnvFactory.createShell();
                String aCommandLine = anExecEnvFactory.createCommandLine();
                Runtime rt = Runtime.getRuntime();
                System.out.println("Executing " + aShell.getShellCommand() + " " + aCommandLine);
                Process proc = rt.exec(aShell.getShellCommand() + " " + aCommandLine);
                StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
                StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
                errorGobbler.start();
                outputGobbler.start();
                int exitVal = proc.waitFor();
                System.out.println("ExitValue: " + exitVal);
                output = outputGobbler.getOutput();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return output;
        }

        private static ExecEnvironmentFactory getExecEnvironmentFactory(String aCommand, String ... someParameters) {
            String anOSName = System.getProperty("os.name");
            if (anOSName.toLowerCase().startsWith("windows")) {
                return new WindowsExecEnvFactory(aCommand, someParameters);
            }
            return new UnixExecEnvFactory(aCommand, someParameters);
        }

        private Exec() {
        }
    }

    public static class StreamGobbler
    extends Thread {
        private InputStream is;
        private String type;
        private StringBuffer output = new StringBuffer();

        StreamGobbler(InputStream anIs, String aType) {
            this.is = anIs;
            this.type = aType;
        }

        @Override
        public final void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + ">" + line);
                    this.output.append(line + System.getProperty("line.separator"));
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public final String getOutput() {
            return this.output.toString();
        }
    }
}

