/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ColorGradient
extends BufferedImage {
    int[][] GradientRGBArray;

    public ColorGradient(Color startColor, Color endColor, int width) {
        super(width, 1, 1);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, startColor, width, 0.0f, endColor, false);
        Graphics2D g = this.createGraphics();
        g.setPaint(gradientPaint);
        g.fillRect(0, 0, width, 1);
    }

    public int[] getPixelRGBArray(int x, int y) {
        int rgb = this.getRGB(x, y);
        Color c = new Color(rgb);
        int[] pixelRGBArray = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
        return pixelRGBArray;
    }

    public int[][] getGradientRGBArray() {
        int w = this.getWidth();
        int h = this.getHeight();
        int[] gradientRGB = new int[w * h];
        this.getRGB(0, 0, w, h, gradientRGB, 0, w);
        this.GradientRGBArray = new int[gradientRGB.length][3];
        for (int i = 0; i < gradientRGB.length; ++i) {
            Color c = new Color(gradientRGB[i]);
            this.GradientRGBArray[i][0] = c.getRed();
            this.GradientRGBArray[i][1] = c.getGreen();
            this.GradientRGBArray[i][2] = c.getBlue();
        }
        return this.GradientRGBArray;
    }
}

