/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.bezier.flatnessalgos;

import com.caffeineowl.graphics.bezier.CubicSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.QuadSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.LineDefectFlatnessAlgo;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.QuadCurve2D;

public class LineDefectSubdivCriterion
extends LineDefectFlatnessAlgo
implements CubicSubdivisionCriterion,
QuadSubdivisionCriterion {
    protected static final double defaultTol = 1.0E-5;
    protected double tol;
    protected double sqTol;

    public LineDefectSubdivCriterion() {
        this(0, true, 1.0E-5);
    }

    public LineDefectSubdivCriterion(int distType) {
        this(distType, true, 1.0E-5);
    }

    public LineDefectSubdivCriterion(boolean useSum) {
        this(0, useSum, 1.0E-5);
    }

    public LineDefectSubdivCriterion(double tolerance) {
        this(0, true, tolerance);
    }

    public LineDefectSubdivCriterion(int distType, boolean useSum) {
        this(distType, useSum, 1.0E-5);
    }

    public LineDefectSubdivCriterion(int distType, double tolerance) {
        this(distType, true, tolerance);
    }

    public LineDefectSubdivCriterion(boolean useSum, double tolerance) {
        this(0, useSum, tolerance);
    }

    public LineDefectSubdivCriterion(int distType, boolean useSum, double tolerance) {
        super(distType, useSum);
        if (tolerance < 0.0) {
            tolerance = -tolerance;
        }
        if (0.0 == tolerance) {
            tolerance = 2.0 * Math.sqrt(Double.MIN_VALUE);
        }
        this.tol = tolerance;
        this.sqTol = tolerance * tolerance;
    }

    public final boolean shouldSplit(CubicCurve2D curve) {
        double defect;
        boolean toRet = false;
        toRet = this.isSquaredFlatenessPreferred() ? (defect = this.getSquaredFlatness(curve)) > this.sqTol : (defect = this.getFlatness(curve)) > this.tol;
        return toRet;
    }

    public final boolean shouldSplit(QuadCurve2D curve) {
        double defect;
        boolean toRet = false;
        toRet = this.isSquaredFlatenessPreferred() ? (defect = this.getSquaredFlatness(curve)) > this.sqTol : (defect = this.getFlatness(curve)) > this.tol;
        return toRet;
    }
}

