/*
 * Decompiled with CFR 0.152.
 */
package com.caffeineowl.graphics.bezier.flatnessalgos;

import com.caffeineowl.graphics.bezier.QuadFlatnessAlgorithm;
import com.caffeineowl.graphics.bezier.QuadSubdivisionCriterion;
import com.caffeineowl.graphics.bezier.flatnessalgos.ConvexHullFlatnessAlgo;
import java.awt.geom.QuadCurve2D;

public class GenericQuadSubdivCriterion
implements QuadSubdivisionCriterion {
    private static final double defaultTol = 1.0E-5;
    private static final QuadFlatnessAlgorithm defaultFlatness = new ConvexHullFlatnessAlgo();
    protected QuadFlatnessAlgorithm flatnessAlgo = null;
    protected double tol;
    protected double sqTol;

    public GenericQuadSubdivCriterion() {
        this(defaultFlatness, 1.0E-5);
    }

    public GenericQuadSubdivCriterion(double tolerance) {
        this(defaultFlatness, tolerance);
    }

    public GenericQuadSubdivCriterion(QuadFlatnessAlgorithm algo) {
        this(algo, 1.0E-5);
    }

    public GenericQuadSubdivCriterion(QuadFlatnessAlgorithm algo, double tolerance) {
        if (null == algo) {
            throw new NullPointerException();
        }
        this.flatnessAlgo = algo;
        if (0.0 == tolerance) {
            tolerance = 2.0 * Math.sqrt(Double.MIN_VALUE);
        }
        this.tol = tolerance;
        this.sqTol = tolerance * tolerance;
    }

    public boolean shouldSplit(QuadCurve2D curve) {
        if (this.flatnessAlgo.isSquaredFlatenessPreferred()) {
            return this.flatnessAlgo.getSquaredFlatness(curve) > this.sqTol;
        }
        return this.flatnessAlgo.getFlatness(curve) > this.tol;
    }
}

