/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Stack;
import org.openimaj.util.pair.ObjectDoublePair;
import org.openimaj.util.queue.BoundedPriorityQueue;

public class IncrementalLongKDTree {
    KDNode _root = null;

    public IncrementalLongKDTree() {
    }

    public IncrementalLongKDTree(Collection<long[]> coords) {
        this.insertAll(coords);
    }

    public IncrementalLongKDTree(long[][] coords) {
        this.insertAll(coords);
    }

    public void insertAll(Collection<long[]> coords) {
        for (long[] c : coords) {
            this.insert(c);
        }
    }

    public void insertAll(long[][] coords) {
        for (long[] c : coords) {
            this.insert(c);
        }
    }

    public void insert(long[] point) {
        if (this._root == null) {
            this._root = new KDNode(point, 0);
        } else {
            double ordinate2;
            KDNode tmpNode;
            int discriminate;
            double ordinate1;
            KDNode curNode = this._root;
            do {
                tmpNode = curNode;
            } while ((curNode = (ordinate1 = (double)point[discriminate = tmpNode.discriminateDim]) > (ordinate2 = (double)tmpNode.point[discriminate]) ? tmpNode.right : tmpNode.left) != null);
            if (++discriminate >= point.length) {
                discriminate = 0;
            }
            if (ordinate1 > ordinate2) {
                tmpNode.right = new KDNode(point, discriminate);
            } else {
                tmpNode.left = new KDNode(point, discriminate);
            }
        }
    }

    static final boolean isContained(long[] point, long[] lower, long[] upper) {
        for (int i = 0; i < point.length; ++i) {
            double ordinate1 = point[i];
            double ordinate2 = lower[i];
            double ordinate3 = upper[i];
            if (!(ordinate1 < ordinate2) && !(ordinate1 > ordinate3)) continue;
            return false;
        }
        return true;
    }

    public List<long[]> rangeSearch(long[] lowerExtreme, long[] upperExtreme) {
        ArrayList<long[]> results = new ArrayList<long[]>(1000);
        Stack<KDNode> stack = new Stack<KDNode>();
        if (this._root == null) {
            return results;
        }
        stack.push(this._root);
        while (!stack.empty()) {
            KDNode tmpNode = (KDNode)stack.pop();
            int discriminate = tmpNode.discriminateDim;
            double ordinate1 = tmpNode.point[discriminate];
            double ordinate2 = lowerExtreme[discriminate];
            if (ordinate1 >= ordinate2 && tmpNode.left != null) {
                stack.push(tmpNode.left);
            }
            if (ordinate1 <= (ordinate2 = (double)upperExtreme[discriminate]) && tmpNode.right != null) {
                stack.push(tmpNode.right);
            }
            if (!IncrementalLongKDTree.isContained(tmpNode.point, lowerExtreme, upperExtreme)) continue;
            results.add(tmpNode.point);
        }
        return results;
    }

    protected static final double distance(long[] a, long[] b) {
        double s = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double fa = a[i];
            double fb = b[i];
            s += (fa - fb) * (fa - fb);
        }
        return s;
    }

    public ObjectDoublePair<long[]> findNearestNeighbour(long[] query) {
        Stack<KDNode> stack = this.walkdown(query);
        ObjectDoublePair<long[]> state = new ObjectDoublePair<long[]>();
        state.first = stack.peek().point;
        state.second = IncrementalLongKDTree.distance(query, (long[])state.first);
        if (state.second == 0.0) {
            return state;
        }
        while (!stack.isEmpty()) {
            KDNode current = stack.pop();
            this.checkSubtree(current, query, state);
        }
        return state;
    }

    public List<ObjectDoublePair<long[]>> findNearestNeighbours(long[] query, int k) {
        Stack<KDNode> stack = this.walkdown(query);
        BoundedPriorityQueue<ObjectDoublePair<long[]>> state = new BoundedPriorityQueue<ObjectDoublePair<long[]>>(k, (Comparator<ObjectDoublePair<long[]>>)ObjectDoublePair.SECOND_ITEM_ASCENDING_COMPARATOR);
        ObjectDoublePair initialState = new ObjectDoublePair();
        initialState.first = stack.peek().point;
        initialState.second = IncrementalLongKDTree.distance(query, (long[])initialState.first);
        state.add(initialState);
        while (!stack.isEmpty()) {
            KDNode current = stack.pop();
            this.checkSubtreeK(current, query, state, k);
        }
        return state.toOrderedListDestructive();
    }

    private void checkSubtree(KDNode node, long[] query, ObjectDoublePair<long[]> state) {
        if (node == null) {
            return;
        }
        double dist = IncrementalLongKDTree.distance(query, node.point);
        if (dist < state.second) {
            state.first = node.point;
            state.second = dist;
        }
        if (state.second == 0.0) {
            return;
        }
        double d = node.point[node.discriminateDim] - query[node.discriminateDim];
        if (d * d > state.second) {
            double ordinate1 = query[node.discriminateDim];
            double ordinate2 = node.point[node.discriminateDim];
            if (ordinate1 > ordinate2) {
                this.checkSubtree(node.right, query, state);
            } else {
                this.checkSubtree(node.left, query, state);
            }
        } else {
            this.checkSubtree(node.left, query, state);
            this.checkSubtree(node.right, query, state);
        }
    }

    private void checkSubtreeK(KDNode node, long[] query, PriorityQueue<ObjectDoublePair<long[]>> state, int k) {
        double d;
        if (node == null) {
            return;
        }
        double dist = IncrementalLongKDTree.distance(query, node.point);
        boolean cont = false;
        for (ObjectDoublePair<long[]> s : state) {
            if (!((long[])s.first).equals(node.point)) continue;
            cont = true;
            break;
        }
        if (!cont) {
            ObjectDoublePair<Object> s;
            if (state.size() < k) {
                s = new ObjectDoublePair();
                s.first = node.point;
                s.second = dist;
                state.add(s);
            } else if (dist < state.peek().second) {
                s = state.poll();
                s.first = node.point;
                s.second = dist;
                state.add(s);
            }
        }
        if ((d = (double)(node.point[node.discriminateDim] - query[node.discriminateDim])) * d > state.peek().second) {
            double ordinate1 = query[node.discriminateDim];
            double ordinate2 = node.point[node.discriminateDim];
            if (ordinate1 > ordinate2) {
                this.checkSubtreeK(node.right, query, state, k);
            } else {
                this.checkSubtreeK(node.left, query, state, k);
            }
        } else {
            this.checkSubtreeK(node.left, query, state, k);
            this.checkSubtreeK(node.right, query, state, k);
        }
    }

    private Stack<KDNode> walkdown(long[] point) {
        double ordinate2;
        KDNode tmpNode;
        int discriminate;
        double ordinate1;
        if (this._root == null) {
            return null;
        }
        Stack<KDNode> stack = new Stack<KDNode>();
        KDNode curNode = this._root;
        do {
            tmpNode = curNode;
            stack.push(tmpNode);
            if (tmpNode.point != point) continue;
            return stack;
        } while ((curNode = (ordinate1 = (double)point[discriminate = tmpNode.discriminateDim]) > (ordinate2 = (double)tmpNode.point[discriminate]) ? tmpNode.right : tmpNode.left) != null);
        if (++discriminate >= point.length) {
            discriminate = 0;
        }
        return stack;
    }

    public List<long[]> radiusSearch(long[] centre, long radius) {
        long[] lower = (long[])centre.clone();
        long[] upper = (long[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        List<long[]> rangeList = this.rangeSearch(lower, upper);
        ArrayList<long[]> radiusList = new ArrayList<long[]>(rangeList.size());
        double radSq = radius * radius;
        for (long[] r : rangeList) {
            if (!(IncrementalLongKDTree.distance(centre, r) < radSq)) continue;
            radiusList.add(r);
        }
        return radiusList;
    }

    public List<ObjectDoublePair<long[]>> radiusDistanceSearch(long[] centre, long radius) {
        long[] lower = (long[])centre.clone();
        long[] upper = (long[])centre.clone();
        int i = 0;
        while (i < centre.length) {
            int n = i;
            lower[n] = lower[n] - radius;
            int n2 = i++;
            upper[n2] = upper[n2] + radius;
        }
        List<long[]> rangeList = this.rangeSearch(lower, upper);
        ArrayList<ObjectDoublePair<long[]>> radiusList = new ArrayList<ObjectDoublePair<long[]>>(rangeList.size());
        double radSq = radius * radius;
        for (long[] r : rangeList) {
            double dist = IncrementalLongKDTree.distance(centre, r);
            if (!(dist < radSq)) continue;
            radiusList.add(new ObjectDoublePair<long[]>(r, dist));
        }
        return radiusList;
    }

    private static class KDNode {
        int discriminateDim;
        long[] point;
        KDNode left;
        KDNode right;

        KDNode(long[] point, int discriminate) {
            this.point = point;
            this.right = null;
            this.left = null;
            this.discriminateDim = discriminate;
        }
    }
}

