/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.pair;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TFloatArrayList;
import java.util.Comparator;

public class FloatDoublePair {
    public static final Comparator<FloatDoublePair> FIRST_ITEM_ASCENDING_COMPARATOR = new Comparator<FloatDoublePair>(){

        @Override
        public int compare(FloatDoublePair o1, FloatDoublePair o2) {
            if (o1.first < o2.first) {
                return -1;
            }
            if (o1.first > o2.first) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<FloatDoublePair> FIRST_ITEM_DESCENDING_COMPARATOR = new Comparator<FloatDoublePair>(){

        @Override
        public int compare(FloatDoublePair o1, FloatDoublePair o2) {
            if (o1.first < o2.first) {
                return 1;
            }
            if (o1.first > o2.first) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<FloatDoublePair> SECOND_ITEM_ASCENDING_COMPARATOR = new Comparator<FloatDoublePair>(){

        @Override
        public int compare(FloatDoublePair o1, FloatDoublePair o2) {
            if (o1.second < o2.second) {
                return -1;
            }
            if (o1.second > o2.second) {
                return 1;
            }
            return 0;
        }
    };
    public static final Comparator<FloatDoublePair> SECOND_ITEM_DESCENDING_COMPARATOR = new Comparator<FloatDoublePair>(){

        @Override
        public int compare(FloatDoublePair o1, FloatDoublePair o2) {
            if (o1.second < o2.second) {
                return 1;
            }
            if (o1.second > o2.second) {
                return -1;
            }
            return 0;
        }
    };
    public float first;
    public double second;

    public FloatDoublePair(float f, double s) {
        this.first = f;
        this.second = s;
    }

    public FloatDoublePair() {
    }

    public float getFirst() {
        return this.first;
    }

    public void setFirst(float first) {
        this.first = first;
    }

    public double getSecond() {
        return this.second;
    }

    public void setSecond(double second) {
        this.second = second;
    }

    public static FloatDoublePair pair(float a, double b) {
        return new FloatDoublePair(a, b);
    }

    public static TDoubleArrayList getSecond(Iterable<FloatDoublePair> data) {
        TDoubleArrayList extracted = new TDoubleArrayList();
        for (FloatDoublePair item : data) {
            extracted.add(item.second);
        }
        return extracted;
    }

    public static TFloatArrayList getFirst(Iterable<FloatDoublePair> data) {
        TFloatArrayList extracted = new TFloatArrayList();
        for (FloatDoublePair item : data) {
            extracted.add(item.first);
        }
        return extracted;
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ")";
    }
}

