/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data.dataset;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.openimaj.data.dataset.ReadableListDataset;
import org.openimaj.data.identity.Identifiable;
import org.openimaj.io.IOUtils;
import org.openimaj.io.InputStreamObjectReader;
import org.openimaj.io.ObjectReader;
import org.openimaj.util.array.ArrayIterator;

public class VFSListDataset<INSTANCE>
extends ReadableListDataset<INSTANCE, FileObject>
implements Identifiable {
    private FileObject[] files;
    private FileObject base;

    public VFSListDataset(String path, InputStreamObjectReader<INSTANCE> reader) throws FileSystemException {
        this(path, new FileObjectISReader<INSTANCE>(reader));
    }

    public VFSListDataset(String path, final ObjectReader<INSTANCE, FileObject> reader) throws FileSystemException {
        super(reader);
        FileSystemManager fsManager = VFS.getManager();
        this.base = fsManager.resolveFile(path);
        this.files = this.base.findFiles(new FileSelector(){

            public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                return true;
            }

            public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                if (fileInfo.getFile().getType() == FileType.FILE) {
                    return IOUtils.canRead(reader, fileInfo.getFile(), fileInfo.getFile().getName().getBaseName());
                }
                return false;
            }
        });
    }

    public FileObject[] getFileObjects() {
        return this.files;
    }

    public FileObject getFileObject(int index) {
        return this.files[index];
    }

    @Override
    public INSTANCE getInstance(int index) {
        try {
            return this.read(this.files[index]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int numInstances() {
        if (this.files == null) {
            return 0;
        }
        return this.files.length;
    }

    private INSTANCE read(FileObject file) throws IOException {
        return (INSTANCE)this.reader.read(file);
    }

    @Override
    public Iterator<INSTANCE> iterator() {
        return new Iterator<INSTANCE>(){
            ArrayIterator<FileObject> filesIterator;
            {
                this.filesIterator = new ArrayIterator<FileObject>(VFSListDataset.this.files);
            }

            @Override
            public boolean hasNext() {
                return this.filesIterator.hasNext();
            }

            @Override
            public INSTANCE next() {
                try {
                    return VFSListDataset.this.read(this.filesIterator.next());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                this.filesIterator.remove();
            }
        };
    }

    @Override
    public String getID(int index) {
        try {
            return this.base.getName().getRelativeName(this.files[index].getName());
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return String.format("%s(%d instances)", this.getClass().getName(), this.files.length);
    }

    @Override
    public String getID() {
        return this.base.getName().getBaseName();
    }

    public static class FileObjectISReader<INSTANCE>
    implements ObjectReader<INSTANCE, FileObject> {
        private InputStreamObjectReader<INSTANCE> streamReader;

        public FileObjectISReader(InputStreamObjectReader<INSTANCE> reader) {
            this.streamReader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public INSTANCE read(FileObject source) throws IOException {
            try (FileContent content = null;){
                content = source.getContent();
                Object t = this.streamReader.read(content.getInputStream());
                return (INSTANCE)t;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean canRead(FileObject source, String name) {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(source.getContent().getInputStream());
                boolean bl = IOUtils.canRead(this.streamReader, stream, source.getName().getBaseName());
                return bl;
            }
            catch (IOException iOException) {
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return false;
        }
    }
}

