/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.util;

import java.util.Arrays;

public class WesternScaleNote {
    public int noteNumber;
    public String noteName;
    public int octaveNumber;
    public float frequency;
    public static float tuningOfA = 440.0f;
    public static final double twelfthRootOfTwo = 1.059463094359;
    public static final String[] noteNames = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};

    public String toString() {
        return this.noteName + this.octaveNumber + " (" + this.frequency + "Hz, " + this.noteNumber + ")";
    }

    public static final int nStepsBetween(WesternScaleNote note1, WesternScaleNote note2) {
        return note1.noteNumber - note2.noteNumber;
    }

    public static final float noteToFrequency(int noteNumber) {
        return (float)((double)tuningOfA * Math.pow(2.0, (double)(noteNumber - 69) / 12.0));
    }

    public static final int frequencyToNote(float frequency) {
        return (int)Math.round(12.0 * Math.log(frequency / tuningOfA) / Math.log(2.0)) + 69;
    }

    public static final WesternScaleNote createNote(String noteString) {
        String startNoteName = null;
        int length = 0;
        for (String noteName : noteNames) {
            if (!noteString.startsWith(noteName) || noteName.length() <= length) continue;
            startNoteName = noteName;
            length = noteName.length();
        }
        if (startNoteName == null) {
            return null;
        }
        int octave = Integer.parseInt(noteString.substring(startNoteName.length()));
        return WesternScaleNote.createNote(startNoteName, octave);
    }

    public static final WesternScaleNote createNote(String noteName, int octaveNumber) {
        WesternScaleNote n = new WesternScaleNote();
        n.noteName = noteName;
        n.octaveNumber = octaveNumber;
        n.noteNumber = Arrays.asList(noteNames).indexOf(noteName) + (octaveNumber + 1) * 12;
        n.frequency = WesternScaleNote.noteToFrequency(n.noteNumber);
        return n;
    }

    public static final WesternScaleNote createNote(float frequency) {
        int noteNum = WesternScaleNote.frequencyToNote(frequency);
        return WesternScaleNote.createNote(noteNum);
    }

    public static final WesternScaleNote createNote(int noteNumber) {
        WesternScaleNote n = new WesternScaleNote();
        n.noteNumber = noteNumber;
        n.octaveNumber = noteNumber / 12 - 1;
        n.noteName = noteNames[noteNumber % 12];
        n.frequency = WesternScaleNote.noteToFrequency(noteNumber);
        return n;
    }
}

