/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils.rendering;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.tinfour.utils.rendering.RenderingTransformAid;

public class RenderingSurfaceAid {
    private final int width;
    private final int height;
    private final RenderingTransformAid rta;
    private final BufferedImage bImage;
    private final Graphics2D g2d;

    public RenderingSurfaceAid(int width, int height, int pad, double x0, double y0, double x1, double y1) {
        this.width = width;
        this.height = height;
        this.rta = new RenderingTransformAid(width, height, pad, x0, y0, x1, y1);
        this.bImage = new BufferedImage(width, height, 2);
        this.g2d = this.bImage.createGraphics();
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public AffineTransform getCartesianToPixelTransform() {
        return this.rta.getCartesianToPixelTransform();
    }

    public AffineTransform getPixelToCartesianTransform() {
        return this.rta.getPixelToCartesianTransform();
    }

    public Rectangle2D getDomainRectangle() {
        return this.rta.getDomainRectangle();
    }

    public BufferedImage getBufferdImage() {
        return this.bImage;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public double getUnitsPerPixel() {
        return this.rta.getUnitsPerPixel();
    }

    public double getPixelsPerUnit() {
        return this.rta.getPixelsPerUnit();
    }

    public void fillBackground(Color c) {
        this.g2d.setColor(c);
        this.g2d.fillRect(0, 0, this.width, this.height);
    }

    public void drawFrame(Color c) {
        this.g2d.setStroke(new BasicStroke(1.0f));
        this.g2d.setColor(c);
        this.g2d.drawRect(0, 0, this.width - 1, this.height - 1);
    }
}

