/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils;

import java.awt.geom.Point2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class GridSpecification {
    private final CellPosition cellPosition;
    private final double cellSize;
    private final double xLowerLeft;
    private final double yLowerLeft;
    private final double xUpperRight;
    private final double yUpperRight;
    private final int nRows;
    private final int nCols;
    private final int nCells;

    public GridSpecification(CellPosition cellPosition, double cellSize, double xmin, double xmax, double ymin, double ymax) {
        int nC;
        int nR;
        this.cellPosition = cellPosition;
        this.cellSize = cellSize;
        if (cellSize <= 0.0) {
            throw new IllegalArgumentException("Zero or negative cell size not allowed");
        }
        if (xmin >= xmax || ymin >= ymax) {
            throw new IllegalArgumentException("Min/max bounds incorrect");
        }
        int j0 = (int)Math.ceil(xmin / cellSize);
        int j1 = (int)Math.floor(xmax / cellSize);
        int i0 = (int)Math.ceil(ymin / cellSize);
        int i1 = (int)Math.floor(ymax / cellSize);
        if (cellPosition == CellPosition.CornerOfCell) {
            nR = i1 - i0 + 1;
            nC = j1 - j0 + 1;
        } else {
            nR = i1 - i0;
            nC = j1 - j0;
        }
        if (nR == 0) {
            nR = 1;
        }
        if (nC == 0) {
            nC = 1;
        }
        this.nRows = nR;
        this.nCols = nC;
        this.nCells = this.nRows * this.nCols;
        if (cellPosition == CellPosition.CornerOfCell) {
            this.xLowerLeft = (double)j0 * cellSize;
            this.yLowerLeft = (double)i0 * cellSize;
        } else {
            this.xLowerLeft = (double)j0 * cellSize + cellSize / 2.0;
            this.yLowerLeft = (double)i0 * cellSize + cellSize / 2.0;
        }
        this.xUpperRight = this.xLowerLeft + (double)(this.nCols - 1) * cellSize;
        this.yUpperRight = this.yLowerLeft + (double)(this.nRows - 1) * cellSize;
    }

    public void mapRowColumnToXy(double row, double col, Point2D p2d) {
        p2d.setLocation(this.xLowerLeft + col * this.cellSize, this.yUpperRight - row * this.cellSize);
    }

    public void mapXyToRowColumn(double x, double y, double[] c, int offset) {
        c[offset] = (this.yUpperRight - y) / this.cellSize;
        c[offset + 1] = (x - this.xLowerLeft) / this.cellSize;
    }

    public void writeAsciiFile(File file, float[][] values, String dataFormat, String noDataString) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        PrintStream output = new PrintStream((OutputStream)bos, false, "US-ASCII");
        output.format("NCOLS %d%n", this.nCols);
        output.format("NROWS %d%n", this.nRows);
        switch (this.getCellPosition()) {
            case CornerOfCell: {
                output.format("XLLCORNER %f%n", this.xLowerLeft);
                output.format("YLLCORNER %f%n", this.yLowerLeft);
                break;
            }
            default: {
                output.format("XLLCENTER %f%n", this.xLowerLeft);
                output.format("YLLCENTER %f%n", this.yLowerLeft);
            }
        }
        output.format("CELLSIZE %f%n", this.getCellSize());
        output.format("NODATA_VALUE %s%n", noDataString);
        output.flush();
        output.flush();
        for (int iRow = 0; iRow < this.nRows; ++iRow) {
            for (int iCol = 0; iCol < this.nCols; ++iCol) {
                float z;
                if (iCol > 0) {
                    output.append(" ");
                }
                if (Float.isNaN(z = values[iRow][iCol])) {
                    output.append(noDataString);
                    continue;
                }
                output.format(dataFormat, Float.valueOf(z));
            }
            output.format("%n", new Object[0]);
        }
        output.flush();
        output.close();
    }

    public CellPosition getCellPosition() {
        return this.cellPosition;
    }

    public double getCellSize() {
        return this.cellSize;
    }

    public double getLowerLeftX() {
        return this.xLowerLeft;
    }

    public double getLowerLeftY() {
        return this.yLowerLeft;
    }

    public double getUpperRightX() {
        return this.xUpperRight;
    }

    public double getUpperRightY() {
        return this.yUpperRight;
    }

    public int getRowCount() {
        return this.nRows;
    }

    public int getColumnCount() {
        return this.nCols;
    }

    public int getCellCount() {
        return this.nCells;
    }

    public static enum CellPosition {
        CenterOfCell,
        CornerOfCell;

    }
}

