/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.semivirtual;

import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.tinfour.common.BootstrapUtility;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IConstraint;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IIncrementalTinNavigator;
import org.tinfour.common.IIntegrityCheck;
import org.tinfour.common.IMonitorWithCancellation;
import org.tinfour.common.INeighborEdgeLocator;
import org.tinfour.common.INeighborhoodPointsCollector;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Thresholds;
import org.tinfour.common.TriangleCount;
import org.tinfour.common.Vertex;
import org.tinfour.common.VertexMergerGroup;
import org.tinfour.semivirtual.IntCollector;
import org.tinfour.semivirtual.SemiVirtualDevillersEar;
import org.tinfour.semivirtual.SemiVirtualEdge;
import org.tinfour.semivirtual.SemiVirtualEdgePool;
import org.tinfour.semivirtual.SemiVirtualIncrementalTinNavigator;
import org.tinfour.semivirtual.SemiVirtualIntegrityCheck;
import org.tinfour.semivirtual.SemiVirtualNeighborEdgeLocator;
import org.tinfour.semivirtual.SemiVirtualNeighborhoodPointsCollector;
import org.tinfour.semivirtual.SemiVirtualStochasticLawsonsWalk;

public class SemiVirtualIncrementalTin
implements IIncrementalTin {
    private static final int N_SIDES = 2;
    private List<Vertex> vertexList;
    private final List<VertexMergerGroup> coincidenceList = new ArrayList<VertexMergerGroup>();
    private final List<IConstraint> constraintList = new ArrayList<IConstraint>();
    private final SemiVirtualEdgePool edgePool;
    private SemiVirtualEdge searchEdge;
    private boolean isLocked;
    private boolean isDisposed;
    private double boundsMinX = Double.POSITIVE_INFINITY;
    private double boundsMinY = Double.POSITIVE_INFINITY;
    private double boundsMaxX = Double.NEGATIVE_INFINITY;
    private double boundsMaxY = Double.NEGATIVE_INFINITY;
    private final double nominalPointSpacing;
    private final double halfPlaneThreshold;
    private final double halfPlaneThresholdNeg;
    private final double inCircleThreshold;
    private final double inCircleThresholdNeg;
    private final double vertexTolerance;
    private final double vertexTolerance2;
    private final Thresholds thresholds;
    private final GeometricOperations geoOp;
    private boolean isBootstrapped;
    private int nVerticesInserted;
    private int nInCircle;
    private int nInCircleExtendedPrecision;
    private int nInCircleExtendedPrecisionConflicts;
    private int nEdgesReplacedDuringBuild;
    private int maxEdgesReplacedDuringBuild;
    private int nSyntheticVertices;
    private int maxDepthOfRecursionInRestore;
    private int maxLengthOfQueueInFloodFill;
    private VertexMergerGroup.ResolutionRule vertexMergeRule = VertexMergerGroup.ResolutionRule.MeanValue;
    private final SemiVirtualStochasticLawsonsWalk walker;

    public SemiVirtualIncrementalTin() {
        this.thresholds = new Thresholds(1.0);
        this.geoOp = new GeometricOperations(this.thresholds);
        this.nominalPointSpacing = this.thresholds.getNominalPointSpacing();
        this.halfPlaneThreshold = this.thresholds.getHalfPlaneThreshold();
        this.halfPlaneThresholdNeg = -this.thresholds.getHalfPlaneThreshold();
        this.inCircleThreshold = this.thresholds.getInCircleThreshold();
        this.inCircleThresholdNeg = -this.thresholds.getInCircleThreshold();
        this.vertexTolerance = this.thresholds.getVertexTolerance();
        this.vertexTolerance2 = this.thresholds.getVertexTolerance2();
        this.walker = new SemiVirtualStochasticLawsonsWalk(this.thresholds);
        this.edgePool = new SemiVirtualEdgePool();
    }

    public SemiVirtualIncrementalTin(double nominalPointSpacing) {
        this.nominalPointSpacing = nominalPointSpacing;
        this.thresholds = new Thresholds(this.nominalPointSpacing);
        this.geoOp = new GeometricOperations(this.thresholds);
        this.halfPlaneThreshold = this.thresholds.getHalfPlaneThreshold();
        this.halfPlaneThresholdNeg = -this.thresholds.getHalfPlaneThreshold();
        this.inCircleThreshold = this.thresholds.getInCircleThreshold();
        this.inCircleThresholdNeg = -this.thresholds.getInCircleThreshold();
        this.vertexTolerance = this.thresholds.getVertexTolerance();
        this.vertexTolerance2 = this.thresholds.getVertexTolerance2();
        this.walker = new SemiVirtualStochasticLawsonsWalk(this.thresholds);
        this.edgePool = new SemiVirtualEdgePool();
    }

    @Override
    public boolean add(Vertex v) {
        if (this.isLocked) {
            if (this.isDisposed) {
                throw new IllegalStateException("Unable to add vertex after a call to dispose()");
            }
            throw new IllegalStateException("Unable to add vertex, TIN is locked");
        }
        ++this.nVerticesInserted;
        if (this.isBootstrapped) {
            return this.addWithInsertOrAppend(v);
        }
        if (this.vertexList == null) {
            this.vertexList = new ArrayList<Vertex>();
            this.vertexList.add(v);
            return false;
        }
        this.vertexList.add(v);
        boolean status = this.bootstrap(this.vertexList);
        if (status) {
            if (this.vertexList.size() > 3) {
                for (Vertex vertex : this.vertexList) {
                    this.addWithInsertOrAppend(vertex);
                }
            }
            this.vertexList.clear();
            this.vertexList = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(List<Vertex> list, IMonitorWithCancellation monitor) {
        if (this.isLocked) {
            if (this.isDisposed) {
                throw new IllegalStateException("Unable to add vertex after a call to dispose()");
            }
            throw new IllegalStateException("Unable to add vertex, TIN is locked");
        }
        if (list.isEmpty()) {
            return false;
        }
        int nVertices = list.size();
        int iProgressThreshold = Integer.MAX_VALUE;
        int pProgressThreshold = 0;
        if (monitor != null) {
            monitor.reportProgress(0);
            int iPercent = monitor.getReportingIntervalInPercent();
            int iTemp = (int)((double)nVertices * ((double)iPercent / 100.0) + 0.5);
            if (iTemp > 1) {
                if (iTemp < 10000) {
                    iTemp = 10000;
                }
                iProgressThreshold = iTemp;
            }
        }
        this.nVerticesInserted += list.size();
        List<Vertex> aList = list;
        if (!this.isBootstrapped) {
            boolean status;
            if (this.vertexList != null) {
                this.vertexList.addAll(list);
                aList = this.vertexList;
            }
            if (!(status = this.bootstrap(aList))) {
                if (this.vertexList == null) {
                    this.vertexList = new ArrayList<Vertex>();
                }
                this.vertexList.addAll(list);
                return false;
            }
        }
        this.preAllocateEdges(aList.size());
        int nVertexAdded = 0;
        for (Vertex v : aList) {
            this.addWithInsertOrAppend(v);
            ++nVertexAdded;
            if (++pProgressThreshold != iProgressThreshold) continue;
            pProgressThreshold = 0;
            monitor.reportProgress((int)(0.1 + 100.0 * (double)(nVertexAdded + 1) / (double)nVertices));
        }
        if (this.vertexList != null) {
            this.vertexList.clear();
            this.vertexList = null;
        }
        return true;
    }

    private boolean bootstrap(List<Vertex> list) {
        Vertex[] v = new BootstrapUtility(this.thresholds).bootstrap(list);
        if (v == null) {
            return false;
        }
        SemiVirtualEdge e1 = this.edgePool.allocateEdge(v[0], v[1]);
        SemiVirtualEdge e2 = this.edgePool.allocateEdge(v[1], v[2]);
        SemiVirtualEdge e3 = this.edgePool.allocateEdge(v[2], v[0]);
        SemiVirtualEdge e4 = this.edgePool.allocateEdge(v[0], null);
        SemiVirtualEdge e5 = this.edgePool.allocateEdge(v[1], null);
        SemiVirtualEdge e6 = this.edgePool.allocateEdge(v[2], null);
        SemiVirtualEdge ie1 = e1.getDual();
        SemiVirtualEdge ie2 = e2.getDual();
        SemiVirtualEdge ie3 = e3.getDual();
        SemiVirtualEdge ie4 = e4.getDual();
        SemiVirtualEdge ie5 = e5.getDual();
        SemiVirtualEdge ie6 = e6.getDual();
        e1.setForward(e2);
        e2.setForward(e3);
        e3.setForward(e1);
        e4.setForward(ie5);
        e5.setForward(ie6);
        e6.setForward(ie4);
        ie1.setForward(e4);
        ie2.setForward(e5);
        ie3.setForward(e6);
        ie4.setForward(ie3);
        ie5.setForward(ie1);
        ie6.setForward(ie2);
        this.isBootstrapped = true;
        this.boundsMaxX = this.boundsMinX = v[0].x;
        this.boundsMaxY = this.boundsMinY = v[0].y;
        for (int i = 1; i < 3; ++i) {
            if (v[i].x < this.boundsMinX) {
                this.boundsMinX = v[i].x;
            } else if (v[i].x > this.boundsMaxX) {
                this.boundsMaxX = v[i].x;
            }
            if (v[i].y < this.boundsMinY) {
                this.boundsMinY = v[i].y;
                continue;
            }
            if (!(v[i].y > this.boundsMaxY)) continue;
            this.boundsMaxY = v[i].y;
        }
        return true;
    }

    private double inCircleWithGhosts(Vertex a, Vertex b, Vertex v) {
        double h = (v.x - a.x) * (a.y - b.y) + (v.y - a.y) * (b.x - a.x);
        if (this.halfPlaneThresholdNeg < h && h < this.halfPlaneThreshold && (h = this.geoOp.halfPlane(a.x, a.y, b.x, b.y, v.x, v.y)) == 0.0) {
            double ny;
            double ax = v.getX() - a.getX();
            double ay = v.getY() - a.getY();
            double nx = b.getX() - a.getX();
            double can = ax * nx + ay * (ny = b.getY() - a.getY());
            h = can < 0.0 ? -1.0 : (ax * ax + ay * ay > nx * nx + ny * ny ? -1.0 : 1.0);
        }
        return h;
    }

    private boolean addWithInsertOrAppend(Vertex v) {
        double x = v.x;
        double y = v.y;
        int buffer = -1;
        int nReplacements = 0;
        if (x < this.boundsMinX) {
            this.boundsMinX = x;
        } else if (x > this.boundsMaxX) {
            this.boundsMaxX = x;
        }
        if (y < this.boundsMinY) {
            this.boundsMinY = y;
        } else if (y > this.boundsMaxY) {
            this.boundsMaxY = y;
        }
        if (this.searchEdge == null) {
            this.searchEdge = this.edgePool.getStartingEdge();
        }
        this.walker.findAnEdgeFromEnclosingTriangleInternal(this.searchEdge, x, y);
        if (this.checkTriangleVerticesForMatchInternal(this.searchEdge, x, y, this.vertexTolerance2)) {
            this.mergeVertexOrIgnore(this.searchEdge, v);
            return false;
        }
        Vertex anchor = this.searchEdge.getA();
        SemiVirtualEdge e = this.edgePool.allocateUnassignedEdge();
        SemiVirtualEdge pStart = this.edgePool.allocateEdge(v, anchor);
        SemiVirtualEdge p = pStart.copy();
        p.setForward(this.searchEdge);
        SemiVirtualEdge n0 = p.getDual();
        SemiVirtualEdge n1 = this.searchEdge.getForward();
        SemiVirtualEdge n2 = n1.getForward();
        n2.setForward(n0);
        SemiVirtualEdge c = this.searchEdge.copy();
        while (true) {
            double h;
            n0.loadDualFromEdge(c);
            n1.loadForwardFromEdge(n0);
            Vertex vA = n0.getA();
            Vertex vB = n1.getA();
            Vertex vC = n1.getB();
            if (vC == null) {
                h = this.inCircleWithGhosts(vA, vB, v);
            } else if (vA == null) {
                h = this.inCircleWithGhosts(vB, vC, v);
            } else if (vB == null) {
                h = this.inCircleWithGhosts(vC, vA, v);
            } else {
                ++this.nInCircle;
                double a11 = vA.x - x;
                double a12 = vA.y - y;
                double a21 = vB.x - x;
                double a32 = vC.y - y;
                double a31 = vC.x - x;
                double a22 = vB.y - y;
                h = (a11 * a11 + a12 * a12) * (a21 * a32 - a31 * a22) + (a21 * a21 + a22 * a22) * (a31 * a12 - a11 * a32) + (a31 * a31 + a32 * a32) * (a11 * a22 - a21 * a12);
                if (this.inCircleThresholdNeg < h && h < this.inCircleThreshold) {
                    ++this.nInCircleExtendedPrecision;
                    double h2 = h;
                    h = this.geoOp.inCircleQuadPrecision(vA.x, vA.y, vB.x, vB.y, vC.x, vC.y, x, y);
                    if (h == 0.0) {
                        if (h2 != 0.0) {
                            ++this.nInCircleExtendedPrecisionConflicts;
                        }
                    } else if (h * h2 <= 0.0) {
                        ++this.nInCircleExtendedPrecisionConflicts;
                    }
                }
            }
            if (h >= 0.0) {
                n2.loadForwardFromEdge(n1);
                n0.loadForwardFromEdge(c);
                n2.setForward(n0);
                p.setForward(n1);
                ++nReplacements;
                if (buffer == -1) {
                    buffer = c.getBaseIndex();
                } else {
                    this.edgePool.deallocateEdge(c);
                }
                c.loadFromEdge(n1);
                continue;
            }
            if (c.getB() == anchor) {
                n0.loadDualFromEdge(pStart);
                n0.setForward(p);
                this.searchEdge.loadFromEdge(pStart);
                if (buffer != -1) {
                    this.edgePool.deallocateEdge(buffer);
                }
                this.nEdgesReplacedDuringBuild += nReplacements;
                if (nReplacements <= this.maxEdgesReplacedDuringBuild) break;
                this.maxEdgesReplacedDuringBuild = nReplacements;
                break;
            }
            n1.loadForwardFromEdge(c);
            if (buffer == -1) {
                this.edgePool.allocateEdgeWithReceiver(e, v, c.getB());
            } else {
                this.edgePool.getEdgeForIndexWithReceiver(e, buffer, v, c.getB());
                buffer = -1;
            }
            e.setForward(n1);
            n0.loadDualFromEdge(e);
            n0.setForward(p);
            c.setForward(n0);
            p.loadFromEdge(e);
            c.loadFromEdge(n1);
        }
        return true;
    }

    private boolean checkTriangleVerticesForMatchingReference(SemiVirtualEdge sEdge, Vertex v) {
        Vertex a = sEdge.getA();
        Vertex b = sEdge.getB();
        Vertex c = sEdge.getTriangleApex();
        if (a == v) {
            return true;
        }
        if (b == v) {
            sEdge.loadDualFromEdge(sEdge);
            return true;
        }
        if (c == v) {
            sEdge.loadReverseFromEdge(sEdge);
            return true;
        }
        if (a instanceof VertexMergerGroup && ((VertexMergerGroup)a).contains(v)) {
            return true;
        }
        if (b instanceof VertexMergerGroup && ((VertexMergerGroup)b).contains(v)) {
            sEdge.loadDualFromEdge(sEdge);
            return true;
        }
        if (c instanceof VertexMergerGroup && ((VertexMergerGroup)c).contains(v)) {
            sEdge.loadReverseFromEdge(sEdge);
            return true;
        }
        return false;
    }

    private boolean checkTriangleVerticesForMatchInternal(SemiVirtualEdge sEdge, double x, double y, double distanceTolerance2) {
        if (sEdge.getA().getDistanceSq(x, y) < distanceTolerance2) {
            return true;
        }
        if (sEdge.getB().getDistanceSq(x, y) < distanceTolerance2) {
            sEdge.loadDualFromEdge(sEdge);
            return true;
        }
        Vertex v2 = sEdge.getTriangleApex();
        if (v2 != null && v2.getDistanceSq(x, y) < distanceTolerance2) {
            sEdge.loadReverseFromEdge(sEdge);
            return true;
        }
        return false;
    }

    @Override
    public void preAllocateEdges(int nVertices) {
        this.edgePool.preAllocateEdges(nVertices * 3);
    }

    @Override
    public Rectangle2D getBounds() {
        if (Double.isInfinite(this.boundsMinX)) {
            return null;
        }
        return new Rectangle2D.Double(this.boundsMinX, this.boundsMinY, this.boundsMaxX - this.boundsMinX, this.boundsMaxY - this.boundsMinY);
    }

    private void mergeVertexOrIgnore(SemiVirtualEdge edge, Vertex v) {
        VertexMergerGroup group;
        Vertex a = edge.getA();
        if (a == v) {
            return;
        }
        if (a instanceof VertexMergerGroup) {
            group = (VertexMergerGroup)a;
        } else {
            group = new VertexMergerGroup(edge.getA());
            group.setResolutionRule(this.vertexMergeRule);
            this.coincidenceList.add(group);
            SemiVirtualEdge start = edge;
            SemiVirtualEdge e = edge;
            ArrayList<SemiVirtualEdge> eList = new ArrayList<SemiVirtualEdge>();
            int startIndex = start.getIndex();
            do {
                eList.add(e);
                e = e.getReverse();
            } while ((e = e.getDual()).getIndex() != startIndex);
            for (SemiVirtualEdge qe : eList) {
                qe.setA(group);
            }
        }
        group.addVertex(v);
    }

    @Override
    public void printEdges(PrintStream ps) {
        List<IQuadEdge> list = this.edgePool.getEdges();
        for (IQuadEdge e : list) {
            ps.println(e.toString());
            ps.println(e.getDual().toString());
        }
        ps.flush();
    }

    private void setMarkBit(BitSet bitset, IQuadEdge edge) {
        int index = edge.getIndex() * 2 | edge.getSide();
        bitset.set(index);
    }

    private boolean getMarkBit(BitSet bitset, IQuadEdge edge) {
        int index = edge.getIndex() * 2 | edge.getSide();
        return bitset.get(index);
    }

    @Override
    public TriangleCount countTriangles() {
        return new TriangleCount(this);
    }

    @Override
    public List<IQuadEdge> getPerimeter() {
        ArrayList<IQuadEdge> pList = new ArrayList<IQuadEdge>();
        SemiVirtualEdge g = this.edgePool.getStartingGhostEdge();
        if (this.isBootstrapped && g != null) {
            IQuadEdge s0;
            IQuadEdge s = s0 = g.getReverse();
            do {
                pList.add(s.getDual());
                s = s.getForward();
                s = s.getForward();
                s = s.getDual();
            } while (!(s = s.getReverse()).equals(s0));
        }
        return pList;
    }

    @Override
    public void printDiagnostics(PrintStream ps) {
        if (!this.isBootstrapped) {
            ps.println("Insufficient information to create a TIN");
            return;
        }
        List<IQuadEdge> perimeter = this.getPerimeter();
        TriangleCount trigCount = this.countTriangles();
        int nCoincident = 0;
        for (VertexMergerGroup c : this.coincidenceList) {
            nCoincident += c.getSize();
        }
        int nOrdinary = 0;
        int nGhost = 0;
        int nConstrained = 0;
        double sumLength = 0.0;
        for (IQuadEdge e : this.edgePool) {
            if (e.getB() == null) {
                ++nGhost;
                continue;
            }
            ++nOrdinary;
            sumLength += e.getLength();
            if (!e.isConstrained()) continue;
            ++nConstrained;
        }
        double avgPointSpacing = 0.0;
        if (nOrdinary > 0) {
            avgPointSpacing = sumLength / (double)nOrdinary;
        }
        ps.format("Descriptive data%n", new Object[0]);
        ps.format("Number Vertices Inserted:     %8d%n", this.nVerticesInserted);
        ps.format("Coincident Vertex Spacing:    %8f%n", this.vertexTolerance);
        ps.format("   Sets:                      %8d%n", this.coincidenceList.size());
        ps.format("   Total Count:               %8d%n", nCoincident);
        ps.format("Number Ordinary Edges:        %8d%n", nOrdinary);
        ps.format("Number Edges On Perimeter:    %8d%n", perimeter.size());
        ps.format("Number Ghost Edges:           %8d%n", nGhost);
        ps.format("Number Constrained Edges:     %8d%n", nConstrained);
        ps.format("Number Edge Replacements:     %8d    (avg: %3.1f)%n", this.nEdgesReplacedDuringBuild, (double)this.nEdgesReplacedDuringBuild / (double)(this.nVerticesInserted - nCoincident));
        ps.format("Max Edge Replaced by add op:  %8d%n", this.maxEdgesReplacedDuringBuild);
        ps.format("Average Point Spacing:        %11.2f%n", avgPointSpacing);
        ps.format("Application's Nominal Spacing:%11.2f%n", this.nominalPointSpacing);
        ps.format("Number Triangles:             %8d%n", trigCount.getCount());
        ps.format("Average area of triangles:    %12.3f%n", trigCount.getAreaMean());
        ps.format("Samp. std dev for area:       %12.3f%n", trigCount.getAreaStandardDeviation());
        if (trigCount.getAreaMin() < 1.0) {
            ps.format("Minimum area:                        %f%n", trigCount.getAreaMin());
        } else {
            ps.format("Minimum area:                 %12.3f%n", trigCount.getAreaMin());
        }
        ps.format("Maximum area:                 %12.3f%n", trigCount.getAreaMax());
        ps.format("Total area:                   %10.1f%n", trigCount.getAreaSum());
        ps.format("%nConstruction statistics%n", new Object[0]);
        this.walker.printDiagnostics(ps);
        ps.format("InCircle calculations:        %8d%n", this.nInCircle);
        ps.format("   extended:                  %8d%n", this.nInCircleExtendedPrecision);
        ps.format("   conflicts:                 %8d%n", this.nInCircleExtendedPrecisionConflicts);
        ps.format("%n", new Object[0]);
        this.edgePool.printDiagnostics(ps);
        ps.format("%n", new Object[0]);
        ps.format("Number of constraints:        %8d%n", this.constraintList.size());
        ps.format("Max recursion during restore: %8d%n", this.maxDepthOfRecursionInRestore);
        ps.format("Number of synthetic vertices: %8d%n", this.nSyntheticVertices);
        ps.format("Max queue size in flood fill: %8d%n", this.maxLengthOfQueueInFloodFill);
    }

    @Override
    public List<IQuadEdge> getEdges() {
        if (!this.isBootstrapped) {
            return new ArrayList<IQuadEdge>();
        }
        return this.edgePool.getEdges();
    }

    @Override
    public Iterator<IQuadEdge> getEdgeIterator() {
        return this.edgePool.getIterator(true);
    }

    @Override
    public Iterable<IQuadEdge> edges() {
        return new Iterable<IQuadEdge>(){

            @Override
            public Iterator<IQuadEdge> iterator() {
                return SemiVirtualIncrementalTin.this.edgePool.getIterator(false);
            }
        };
    }

    @Override
    public int getMaximumEdgeAllocationIndex() {
        return this.edgePool.getMaximumAllocationIndex();
    }

    List<SemiVirtualEdge> getVirtualEdges() {
        if (!this.isBootstrapped) {
            return new ArrayList<SemiVirtualEdge>();
        }
        return this.edgePool.getVirtualEdges();
    }

    @Override
    public double getNominalPointSpacing() {
        return this.nominalPointSpacing;
    }

    @Override
    public Thresholds getThresholds() {
        return this.thresholds;
    }

    @Override
    public void dispose() {
        if (!this.isDisposed) {
            this.isLocked = true;
            this.isDisposed = true;
            this.edgePool.dispose();
            this.searchEdge = null;
            if (this.vertexList != null) {
                this.vertexList.clear();
                this.vertexList = null;
            }
            if (this.coincidenceList != null) {
                this.coincidenceList.clear();
            }
        }
    }

    @Override
    public void clear() {
        if (this.isDisposed) {
            return;
        }
        this.isLocked = false;
        this.isBootstrapped = false;
        this.edgePool.clear();
        this.searchEdge = null;
        if (this.vertexList != null) {
            this.vertexList.clear();
        }
        if (this.coincidenceList != null) {
            this.coincidenceList.clear();
        }
        this.constraintList.clear();
        this.walker.reset();
        this.nSyntheticVertices = 0;
    }

    @Override
    public boolean isBootstrapped() {
        return this.isBootstrapped;
    }

    private void setSearchEdgeAfterRemoval(SemiVirtualEdge e) {
        SemiVirtualEdge b = e.getBaseReference();
        if (b.getB() == null) {
            b = b.getReverse();
        }
        this.searchEdge = b;
    }

    @Override
    public boolean remove(Vertex vRemove) {
        SemiVirtualDevillersEar firstEar;
        SemiVirtualEdge n2;
        if (this.isLocked) {
            if (this.isDisposed) {
                throw new IllegalStateException("Unable to add vertex after a call to dispose()");
            }
            throw new IllegalStateException("Unable to add vertex, TIN is locked");
        }
        if (vRemove == null) {
            return false;
        }
        if (!this.isBootstrapped) {
            if (this.vertexList != null) {
                return this.vertexList.remove(vRemove);
            }
            return false;
        }
        double x = vRemove.x;
        double y = vRemove.y;
        if (this.searchEdge == null) {
            this.searchEdge = this.edgePool.getStartingEdge();
        }
        SemiVirtualEdge matchEdge = this.walker.findAnEdgeFromEnclosingTriangle(this.searchEdge, x, y);
        this.checkTriangleVerticesForMatchingReference(matchEdge, vRemove);
        if (matchEdge == null) {
            return false;
        }
        Vertex matchA = matchEdge.getA();
        if (matchA instanceof VertexMergerGroup && vRemove != matchA) {
            VertexMergerGroup group = (VertexMergerGroup)matchA;
            if (!group.removeVertex(vRemove)) {
                return false;
            }
            if (group.getSize() > 0) {
                return true;
            }
        }
        SemiVirtualEdge n0 = matchEdge;
        this.searchEdge = null;
        int initialSize = this.edgePool.size();
        SemiVirtualEdge n1 = n0.getForward();
        while (true) {
            n2 = n1.getForward();
            SemiVirtualEdge n3 = n2.getForwardFromDual();
            n1.setForward(n3);
            n1 = n3;
            if (n2.equals(n0.getDual())) break;
            this.edgePool.deallocateEdge(n2);
        }
        this.edgePool.deallocateEdge(n2);
        n0 = n1;
        if (initialSize - this.edgePool.size() == 3) {
            this.setSearchEdgeAfterRemoval(n0);
            return true;
        }
        int nEar = 0;
        n1 = n0.getForward();
        SemiVirtualEdge pStart = n0;
        SemiVirtualDevillersEar priorEar = firstEar = new SemiVirtualDevillersEar(nEar, null, n1, n0);
        firstEar.computeScore(this.geoOp, vRemove);
        nEar = 1;
        do {
            n0 = n1;
            n1 = n1.getForward();
            SemiVirtualDevillersEar ear = new SemiVirtualDevillersEar(nEar, priorEar, n1, n0);
            ear.computeScore(this.geoOp, vRemove);
            priorEar = ear;
            ++nEar;
        } while (!n1.equals(pStart));
        priorEar.next = firstEar;
        firstEar.prior = priorEar;
        while (true) {
            SemiVirtualDevillersEar earMin = null;
            double minScore = Double.POSITIVE_INFINITY;
            SemiVirtualDevillersEar ear = firstEar;
            do {
                if (ear.score < minScore) {
                    minScore = ear.score;
                    earMin = ear;
                    continue;
                }
                if (!Double.isInfinite(minScore) || ear.v0 != null) continue;
                earMin = ear;
            } while ((ear = ear.next) != firstEar);
            if (earMin == null) {
                throw new UnsupportedOperationException("Implementation failure: Unable to identify correct geometry for vertex removal");
            }
            priorEar = earMin.prior;
            SemiVirtualDevillersEar nextEar = earMin.next;
            SemiVirtualEdge e = this.edgePool.allocateEdge(earMin.v2, earMin.v0);
            e.setForward(earMin.c);
            earMin.n.setForward(e);
            e.setDualForward(nextEar.n);
            priorEar.c.setForward(e.getDual());
            if (nEar == 4) break;
            priorEar.v2 = earMin.v2;
            priorEar.n = e.getDual();
            nextEar.setReferences(priorEar, priorEar.n, priorEar.c);
            priorEar.computeScore(this.geoOp, vRemove);
            nextEar.computeScore(this.geoOp, vRemove);
            firstEar = priorEar;
            --nEar;
        }
        this.setSearchEdgeAfterRemoval(firstEar.c);
        return true;
    }

    SemiVirtualStochasticLawsonsWalk getCompatibleWalker() {
        SemiVirtualStochasticLawsonsWalk cw = new SemiVirtualStochasticLawsonsWalk(this.nominalPointSpacing);
        return cw;
    }

    public SemiVirtualEdge getStartingEdge() {
        if (this.searchEdge == null) {
            return this.edgePool.getStartingEdge();
        }
        return this.searchEdge;
    }

    @Override
    public void setResolutionRuleForMergedVertices(VertexMergerGroup.ResolutionRule resolutionRule) {
        this.vertexMergeRule = resolutionRule;
        for (VertexMergerGroup c : this.coincidenceList) {
            c.setResolutionRule(resolutionRule);
        }
    }

    @Override
    public List<Vertex> getVertices() {
        int maxIndex = this.edgePool.getMaximumAllocationIndex();
        int maxMapIndex = maxIndex * 2 + 1;
        BitSet bitset = new BitSet(maxMapIndex);
        ArrayList<Vertex> vList = new ArrayList<Vertex>(this.nVerticesInserted);
        for (IQuadEdge e : this.edgePool) {
            IQuadEdge d;
            Vertex v = e.getA();
            if (v != null && !this.getMarkBit(bitset, e)) {
                this.setMarkBit(bitset, e);
                vList.add(v);
                IQuadEdge c = e;
                do {
                    c = c.getForward().getForward().getDual();
                    this.setMarkBit(bitset, c);
                } while (!c.equals(e));
            }
            if ((v = (d = e.getDual()).getA()) == null || this.getMarkBit(bitset, d)) continue;
            this.setMarkBit(bitset, d);
            vList.add(v);
            IQuadEdge c = d;
            do {
                c = c.getForward().getForward().getDual();
                this.setMarkBit(bitset, c);
            } while (!c.equals(d));
        }
        return vList;
    }

    @Override
    public INeighborEdgeLocator getNeighborEdgeLocator() {
        return new SemiVirtualNeighborEdgeLocator(this);
    }

    @Override
    public IIncrementalTinNavigator getNavigator() {
        return new SemiVirtualIncrementalTinNavigator(this);
    }

    @Override
    public INeighborhoodPointsCollector getNeighborhoodPointsCollector() {
        return new SemiVirtualNeighborhoodPointsCollector(this, this.thresholds);
    }

    @Override
    public IIntegrityCheck getIntegrityCheck() {
        return new SemiVirtualIntegrityCheck(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConstraints(List<IConstraint> constraints, boolean restoreConformity) {
        if (this.isLocked) {
            if (this.isDisposed) {
                throw new IllegalStateException("Unable to add constraints after a call to dispose()");
            }
            if (!this.constraintList.isEmpty()) {
                throw new IllegalStateException("Constraints have already been added to TIN and no further additions are supported");
            }
            throw new IllegalStateException("Unable to add vertex, TIN is locked");
        }
        if (constraints == null || constraints.isEmpty()) {
            return;
        }
        if (constraints.size() > 0xFFFFFC) {
            throw new IllegalArgumentException("The maximum number of constraints is 16777212");
        }
        boolean redundantVertex = false;
        for (IConstraint c : constraints) {
            c.complete();
            Object reference = c;
            for (Vertex v : c) {
                boolean status = this.add(v);
                if (status) continue;
                redundantVertex = true;
            }
            if (redundantVertex) {
                Object var7_11 = null;
                ArrayList<Vertex> replacementList = new ArrayList<Vertex>();
                for (Vertex v : c) {
                    void var7_12;
                    Vertex m = this.getMatchingVertex(v);
                    if (m == v) {
                        replacementList.add(v);
                        Vertex vertex = v;
                        continue;
                    }
                    if (m == var7_12) continue;
                    replacementList.add(m);
                    Vertex vertex = m;
                }
                reference = c.getConstraintWithNewGeometry(replacementList);
            }
            this.constraintList.add((IConstraint)reference);
        }
        this.isLocked = true;
        IntCollector[] icArray = new IntCollector[this.constraintList.size()];
        int k = 0;
        for (IConstraint iConstraint : this.constraintList) {
            iConstraint.setConstraintIndex(this, k);
            icArray[k] = new IntCollector();
            this.processConstraint(iConstraint, icArray[k]);
            icArray[k].trimToSize();
            ++k;
        }
        if (restoreConformity) {
            List<IQuadEdge> eList = this.edgePool.getEdges();
            for (IQuadEdge e : eList) {
                if (!e.isConstrained()) continue;
                SemiVirtualEdge sEdge = (SemiVirtualEdge)e;
                this.restoreConformity(sEdge, 1);
            }
        }
        int maxIndex = this.getMaximumEdgeAllocationIndex();
        BitSet bitSet = new BitSet(maxIndex + 1);
        for (int i = 0; i < this.constraintList.size(); ++i) {
            IConstraint c = this.constraintList.get(i);
            if (!c.definesConstrainedRegion()) continue;
            this.floodFillConstrainedRegions(c, icArray[i], bitSet);
            SemiVirtualEdge e = this.edgePool.getEdgeForIndex(icArray[i].buffer[0]);
            c.setConstraintLinkingEdge(e);
        }
    }

    private boolean isMatchingVertex(Vertex v, Vertex vertexFromTin) {
        if (v.equals(vertexFromTin)) {
            return true;
        }
        if (vertexFromTin instanceof VertexMergerGroup) {
            VertexMergerGroup g = (VertexMergerGroup)vertexFromTin;
            return g.contains(v);
        }
        return false;
    }

    private void setConstrained(SemiVirtualEdge edge, IConstraint constraint, IntCollector edgesForConstraint) {
        edge.setConstrained(constraint.getConstraintIndex());
        if (constraint.definesConstrainedRegion()) {
            edgesForConstraint.add(edge.getIndex());
            edge.setConstrainedRegionBorderFlag();
            this.edgePool.addBorderConstraintToMap(edge, constraint);
        } else {
            this.edgePool.addLinearConstraintToMap(edge, constraint);
            edge.setConstraintLineMemberFlag();
        }
    }

    private void processConstraint(IConstraint constraint, IntCollector intCollector) {
        VertexMergerGroup g;
        ArrayList<Vertex> cvList = new ArrayList<Vertex>();
        cvList.addAll(constraint.getVertices());
        if (constraint.isPolygon()) {
            cvList.add((Vertex)cvList.get(0));
        }
        int nSegments = cvList.size() - 1;
        double vTolerence = this.thresholds.getVertexTolerance();
        Vertex v0 = (Vertex)cvList.get(0);
        double x0 = v0.getX();
        double y0 = v0.getY();
        if (this.searchEdge == null) {
            this.searchEdge = this.edgePool.getStartingEdge();
        }
        this.searchEdge = this.walker.findAnEdgeFromEnclosingTriangle(this.searchEdge, x0, y0);
        SemiVirtualEdge e0 = null;
        e0 = this.isMatchingVertex(v0, this.searchEdge.getA()) ? this.searchEdge : (this.isMatchingVertex(v0, this.searchEdge.getB()) ? this.searchEdge.getDual() : this.searchEdge.getReverse());
        Vertex a = e0.getA();
        if (a instanceof VertexMergerGroup && a != v0 && (g = (VertexMergerGroup)a).contains(v0)) {
            cvList.set(0, a);
        }
        this.searchEdge = null;
        block0: for (int iSegment = 0; iSegment < nSegments; ++iSegment) {
            double ah;
            double ay;
            double ax;
            double by;
            Vertex b;
            v0 = (Vertex)cvList.get(iSegment);
            Vertex v1 = (Vertex)cvList.get(iSegment + 1);
            SemiVirtualEdge e = e0;
            boolean priorNull = false;
            SemiVirtualEdge reEntry = null;
            do {
                VertexMergerGroup g2;
                if ((b = e.getB()) == null) {
                    priorNull = true;
                    continue;
                }
                if (b == v1) {
                    this.setConstrained(e, constraint, intCollector);
                    e0 = e.getDual();
                    continue block0;
                }
                if (b instanceof VertexMergerGroup && (g2 = (VertexMergerGroup)b).contains(v1)) {
                    cvList.set(iSegment + 1, g2);
                    this.setConstrained(e, constraint, intCollector);
                    e0 = e.getDual();
                    continue block0;
                }
                if (priorNull) {
                    reEntry = e;
                }
                priorNull = false;
            } while (!(e = e.getDualFromReverse()).equals(e0));
            if (reEntry != null) {
                e0 = reEntry;
            }
            x0 = v0.getX();
            y0 = v0.getY();
            double x1 = v1.getX();
            double y1 = v1.getY();
            double ux = x1 - x0;
            double uy = y1 - y0;
            double u = Math.sqrt(ux * ux + uy * uy);
            double px = -(uy /= u);
            double py = ux /= u;
            SemiVirtualEdge h = null;
            SemiVirtualEdge right0 = null;
            SemiVirtualEdge left0 = null;
            SemiVirtualEdge right1 = null;
            SemiVirtualEdge left1 = null;
            b = e0.getB();
            double bx = b.getX() - x0;
            double bh = bx * px + (by = b.getY() - y0) * py;
            if (Math.abs(bh) <= vTolerence && bx * ux + by * uy > 0.0) {
                cvList.add(iSegment + 1, b);
                ++nSegments;
                this.setConstrained(e0, constraint, intCollector);
                e0 = e0.getDual();
                continue;
            }
            e = e0;
            do {
                double dx;
                double dy;
                double t;
                double dx2;
                double dy2;
                double t2;
                ax = bx;
                ay = by;
                ah = bh;
                SemiVirtualEdge n = e.getForward();
                b = n.getB();
                bx = b.getX() - x0;
                bh = bx * px + (by = b.getY() - y0) * py;
                if (Math.abs(bh) <= vTolerence && (t2 = (ax * (dy2 = by - ay) - ay * (dx2 = bx - ax)) / (ux * dy2 - uy * dx2)) > 0.0) {
                    cvList.add(iSegment + 1, b);
                    ++nSegments;
                    e0 = e.getReverse();
                    this.setConstrained(e0.getDual(), constraint, intCollector);
                    continue block0;
                }
                double hab = ah * bh;
                if (!(hab <= 0.0) || !((t = (ax * (dy = by - ay) - ay * (dx = bx - ax)) / (ux * dy - uy * dx)) > 0.0)) continue;
                right0 = e;
                left0 = e.getReverse();
                h = n.getDual();
                break;
            } while (!(e = e.getDualFromReverse()).equals(e0));
            if (h == null) {
                throw new IllegalStateException("Internal failure, constraint not added");
            }
            Vertex c = null;
            while (true) {
                right1 = h.getForward();
                left1 = h.getReverse();
                c = right1.getB();
                if (c == null) {
                    throw new IllegalStateException("Internal failure, constraint not added");
                }
                this.removeEdge(h);
                double cx = c.getX() - x0;
                double cy = c.getY() - y0;
                double ch = cx * px + cy * py;
                if (Math.abs(ch) < vTolerence && cx * ux + cy * uy > 0.0) {
                    if (c.equals(v1)) break;
                    if (c instanceof VertexMergerGroup && ((VertexMergerGroup)c).contains(v1)) {
                        cvList.set(iSegment + 1, c);
                        break;
                    }
                    cvList.add(iSegment + 1, c);
                    ++nSegments;
                    break;
                }
                double hac = ah * ch;
                double hbc = bh * ch;
                if (hac == 0.0 || hbc == 0.0) {
                    throw new IllegalStateException("Internal failure, constraint not added");
                }
                if (hac < 0.0) {
                    h = right1.getDual();
                    bx = cx;
                    by = cy;
                    bh = bx * px + by * py;
                    continue;
                }
                h = left1.getDual();
                ax = cx;
                ay = cy;
                ah = ax * px + ay * py;
            }
            SemiVirtualEdge n = this.edgePool.allocateEdge(v0, c);
            this.setConstrained(n, constraint, intCollector);
            SemiVirtualEdge d = n.getDual();
            n.setForward(left1);
            n.setReverse(left0);
            d.setForward(right0);
            d.setReverse(right1);
            e0 = d;
            this.fillCavity(n);
            this.fillCavity(d);
        }
        this.searchEdge = e0;
    }

    private void restoreConformity(SemiVirtualEdge ab, int depthOfRecursion) {
        if (depthOfRecursion > this.maxDepthOfRecursionInRestore) {
            this.maxDepthOfRecursionInRestore = depthOfRecursion;
        }
        SemiVirtualEdge ba = ab.getDual();
        SemiVirtualEdge bc = ab.getForward();
        SemiVirtualEdge ad = ba.getForward();
        Vertex a = ab.getA();
        Vertex b = ab.getB();
        Vertex c = bc.getB();
        Vertex d = ad.getB();
        if (a == null || b == null || c == null || d == null) {
            return;
        }
        double h = this.geoOp.inCircle(a, b, c, d);
        if (h <= this.thresholds.getDelaunayThreshold()) {
            return;
        }
        SemiVirtualEdge ca = ab.getReverse();
        SemiVirtualEdge db = ba.getReverse();
        if (ab.isConstrained()) {
            double mx = (a.getX() + b.getX()) / 2.0;
            double my = (a.getY() + b.getY()) / 2.0;
            double mz = (a.getZ() + b.getZ()) / 2.0;
            Vertex m = new Vertex(mx, my, mz, this.nSyntheticVertices++);
            m.setStatus(3);
            SemiVirtualEdge am = this.edgePool.splitEdge(ab, m);
            SemiVirtualEdge mb = ab;
            SemiVirtualEdge bm = ba;
            SemiVirtualEdge cm = this.edgePool.allocateEdge(c, m);
            SemiVirtualEdge dm = this.edgePool.allocateEdge(d, m);
            SemiVirtualEdge ma = am.getDual();
            SemiVirtualEdge mc = cm.getDual();
            SemiVirtualEdge md = dm.getDual();
            ma.setForward(ad);
            ad.setForward(dm);
            dm.setForward(ma);
            mb.setForward(bc);
            bc.setForward(cm);
            cm.setForward(mb);
            mc.setForward(ca);
            ca.setForward(am);
            am.setForward(mc);
            md.setForward(db);
            db.setForward(bm);
            bm.setForward(md);
            this.restoreConformity(am, depthOfRecursion + 1);
            this.restoreConformity(mb, depthOfRecursion + 1);
        } else {
            ab.setVertices(d, c);
            ab.setReverse(ad);
            ab.setForward(ca);
            ba.setReverse(bc);
            ba.setForward(db);
            ca.setForward(ad);
            db.setForward(bc);
        }
        this.restoreConformity(bc.getDual(), depthOfRecursion + 1);
        this.restoreConformity(ca.getDual(), depthOfRecursion + 1);
        this.restoreConformity(ad.getDual(), depthOfRecursion + 1);
        this.restoreConformity(db.getDual(), depthOfRecursion + 1);
    }

    private void removeEdge(SemiVirtualEdge e) {
        SemiVirtualEdge d = e.getDual();
        SemiVirtualEdge dr = d.getReverse();
        SemiVirtualEdge df = d.getForward();
        SemiVirtualEdge ef = e.getForward();
        SemiVirtualEdge er = e.getReverse();
        dr.setForward(ef);
        df.setReverse(er);
        this.edgePool.deallocateEdge(e);
    }

    private void fillScore(SemiVirtualDevillersEar ear) {
        ear.score = this.geoOp.area(ear.v0, ear.v1, ear.v2);
        if (ear.score > 0.0) {
            double x0 = ear.v0.getX();
            double y0 = ear.v0.getY();
            double x1 = ear.v1.getX();
            double y1 = ear.v1.getY();
            double x2 = ear.v2.getX();
            double y2 = ear.v2.getY();
            SemiVirtualDevillersEar e = ear.next;
            while (e != ear.prior) {
                double y;
                double x;
                if (e.v2 != ear.v0 && e.v2 != ear.v1 && e.v2 != ear.v2 && this.geoOp.halfPlane(x0, y0, x1, y1, x = e.v2.getX(), y = e.v2.getY()) >= 0.0 && this.geoOp.halfPlane(x1, y1, x2, y2, x, y) >= 0.0 && this.geoOp.halfPlane(x2, y2, x0, y0, x, y) >= 0.0) {
                    ear.score = Double.POSITIVE_INFINITY;
                    break;
                }
                e = e.next;
            }
        }
    }

    private void fillCavity(SemiVirtualEdge cavityEdge) {
        SemiVirtualDevillersEar firstEar;
        int nEar = 0;
        SemiVirtualEdge n0 = cavityEdge;
        SemiVirtualEdge n1 = n0.getForward();
        SemiVirtualEdge pStart = n0;
        SemiVirtualDevillersEar priorEar = firstEar = new SemiVirtualDevillersEar(nEar, null, n1, n0);
        nEar = 1;
        do {
            SemiVirtualDevillersEar ear;
            n0 = n1;
            n1 = n1.getForward();
            priorEar = ear = new SemiVirtualDevillersEar(nEar, priorEar, n1, n0);
            ++nEar;
        } while (!n1.equals(pStart));
        priorEar.next = firstEar;
        firstEar.prior = priorEar;
        if (nEar == 3) {
            return;
        }
        SemiVirtualDevillersEar eC = firstEar.next;
        this.fillScore(firstEar);
        while (eC != firstEar) {
            this.fillScore(eC);
            eC = eC.next;
        }
        ArrayList<SemiVirtualEdge> list = new ArrayList<SemiVirtualEdge>();
        while (true) {
            SemiVirtualDevillersEar earMin = null;
            double minScore = Double.POSITIVE_INFINITY;
            SemiVirtualDevillersEar ear = firstEar;
            do {
                if (!(ear.score < minScore) || !(ear.score > 0.0)) continue;
                minScore = ear.score;
                earMin = ear;
            } while ((ear = ear.next) != firstEar);
            if (earMin == null) {
                throw new IllegalStateException("Implementation failure: Unable to identify correct geometry for cavity fill");
            }
            priorEar = earMin.prior;
            SemiVirtualDevillersEar nextEar = earMin.next;
            SemiVirtualEdge e = this.edgePool.allocateEdge(earMin.v2, earMin.v0);
            SemiVirtualEdge d = e.getDual();
            e.setForward(earMin.c);
            e.setReverse(earMin.n);
            d.setForward(nextEar.n);
            d.setReverse(priorEar.c);
            list.add(e);
            if (nEar == 4) break;
            priorEar.next = nextEar;
            nextEar.prior = priorEar;
            priorEar.v2 = earMin.v2;
            priorEar.n = d;
            nextEar.c = d;
            nextEar.p = priorEar.c;
            nextEar.v0 = earMin.v0;
            this.fillScore(priorEar);
            this.fillScore(nextEar);
            firstEar = priorEar;
            --nEar;
        }
        int k = list.size();
        int k2 = k * k;
        for (int i = 0; i < k2; ++i) {
            int flipped = 0;
            for (SemiVirtualEdge n : list) {
                Vertex t;
                Vertex c;
                Vertex b;
                SemiVirtualEdge d = n.getDual();
                SemiVirtualEdge nf = n.getForward();
                SemiVirtualEdge df = d.getForward();
                Vertex a = n.getA();
                double h = this.geoOp.inCircle(a, b = n.getB(), c = nf.getB(), t = df.getB());
                if (!(h > 0.0)) continue;
                ++flipped;
                SemiVirtualEdge nr = n.getReverse();
                SemiVirtualEdge dr = d.getReverse();
                n.setVertices(t, c);
                n.setForward(nr);
                n.setReverse(df);
                d.setForward(dr);
                d.setReverse(nf);
                dr.setForward(nf);
                nr.setForward(df);
            }
            if (flipped == 0) break;
        }
    }

    private void floodFillConstrainedRegions(IConstraint c, IntCollector intCollector, BitSet visited) {
        int constraintIndex = c.getConstraintIndex();
        for (int i = 0; i < intCollector.n; ++i) {
            SemiVirtualEdge e = this.edgePool.getEdgeForIndex(intCollector.buffer[i]);
            if (!e.isConstrainedRegionBorder()) continue;
            this.floodFillConstrainedRegionsQueue(constraintIndex, visited, e);
        }
    }

    private void floodFillConstrainedRegionsQueue(int constraintIndex, BitSet visited, IQuadEdge firstEdge) {
        ArrayDeque<IQuadEdge> deque = new ArrayDeque<IQuadEdge>();
        deque.push(firstEdge);
        while (!deque.isEmpty()) {
            if (deque.size() > this.maxLengthOfQueueInFloodFill) {
                this.maxLengthOfQueueInFloodFill = deque.size();
            }
            IQuadEdge e = (IQuadEdge)deque.peek();
            IQuadEdge f = e.getForward();
            int fIndex = f.getIndex();
            if (!f.isConstrainedRegionBorder() && !visited.get(fIndex)) {
                visited.set(fIndex);
                f.setConstrainedRegionInteriorFlag();
                f.setConstraintIndex(constraintIndex);
                deque.push(f.getDual());
                continue;
            }
            IQuadEdge r = e.getReverse();
            int rIndex = r.getIndex();
            if (!r.isConstrainedRegionBorder() && !visited.get(rIndex)) {
                visited.set(rIndex);
                r.setConstrainedRegionInteriorFlag();
                r.setConstraintIndex(constraintIndex);
                deque.push(r.getDual());
                continue;
            }
            deque.pop();
        }
    }

    @Override
    public List<IConstraint> getConstraints() {
        ArrayList<IConstraint> result = new ArrayList<IConstraint>();
        result.addAll(this.constraintList);
        return result;
    }

    @Override
    public IConstraint getConstraint(int index) {
        if (index < 0 || index >= this.constraintList.size()) {
            return null;
        }
        return this.constraintList.get(index);
    }

    @Override
    public IConstraint getRegionConstraint(IQuadEdge edge) {
        if (edge.isConstrainedRegionInterior()) {
            int index = edge.getConstraintIndex();
            if (index < this.constraintList.size()) {
                return this.constraintList.get(index);
            }
        } else if (edge.isConstrainedRegionBorder()) {
            return this.edgePool.getBorderConstraint(edge);
        }
        return null;
    }

    @Override
    public IConstraint getLinearConstraint(IQuadEdge edge) {
        return this.edgePool.getLinearConstraint(edge);
    }

    @Override
    public int getSyntheticVertexCount() {
        return this.nSyntheticVertices;
    }

    private Vertex getMatchingVertex(Vertex v) {
        if (v == null) {
            return null;
        }
        double x = v.x;
        double y = v.y;
        if (this.searchEdge == null) {
            this.searchEdge = this.edgePool.getStartingEdge();
        }
        this.walker.findAnEdgeFromEnclosingTriangleInternal(this.searchEdge, x, y);
        if (this.checkTriangleVerticesForMatchInternal(this.searchEdge, x, y, this.vertexTolerance2)) {
            VertexMergerGroup group;
            Vertex a = this.searchEdge.getA();
            if (a == v) {
                return v;
            }
            if (a instanceof VertexMergerGroup && (group = (VertexMergerGroup)a).contains(v)) {
                return group;
            }
        }
        return null;
    }

    @Override
    public Vertex splitEdge(IQuadEdge eInput, double zSplit, boolean restoreConformity) {
        if (restoreConformity) {
            throw new UnsupportedOperationException("The restoreConformity option is not yet implemented");
        }
        int index = eInput.getIndex();
        SemiVirtualEdge eTest = this.edgePool.getEdgeForIndex(index);
        if (eTest == null || eTest.getA() != eInput.getA() || eTest.getB() != eInput.getB()) {
            throw new IllegalArgumentException("Specified edge does not belong to this instance for edge index " + index);
        }
        SemiVirtualEdge ab = (SemiVirtualEdge)eInput;
        SemiVirtualEdge ba = ab.getDual();
        SemiVirtualEdge bc = ab.getForward();
        SemiVirtualEdge ad = ba.getForward();
        Vertex a = ab.getA();
        Vertex b = ab.getB();
        Vertex c = bc.getB();
        Vertex d = ad.getB();
        if (a == null || b == null) {
            return null;
        }
        SemiVirtualEdge ca = ab.getReverse();
        SemiVirtualEdge db = ba.getReverse();
        double mx = (a.getX() + b.getX()) / 2.0;
        double my = (a.getY() + b.getY()) / 2.0;
        double mz = zSplit;
        Vertex m = new Vertex(mx, my, mz, this.nSyntheticVertices++);
        if (ab.isConstrained()) {
            m.setStatus(3);
        } else {
            m.setStatus(1);
        }
        SemiVirtualEdge am = this.edgePool.splitEdge(ab, m);
        SemiVirtualEdge mb = ab;
        SemiVirtualEdge bm = ba;
        SemiVirtualEdge cm = this.edgePool.allocateEdge(c, m);
        SemiVirtualEdge dm = this.edgePool.allocateEdge(d, m);
        SemiVirtualEdge ma = am.getDual();
        SemiVirtualEdge mc = cm.getDual();
        SemiVirtualEdge md = dm.getDual();
        ma.setForward(ad);
        ad.setForward(dm);
        dm.setForward(ma);
        mb.setForward(bc);
        bc.setForward(cm);
        cm.setForward(mb);
        mc.setForward(ca);
        ca.setForward(am);
        am.setForward(mc);
        md.setForward(db);
        db.setForward(bm);
        bm.setForward(md);
        return m;
    }
}

