/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.common;

import java.util.BitSet;
import java.util.Iterator;
import org.tinfour.common.GeometricOperations;
import org.tinfour.common.IIncrementalTin;
import org.tinfour.common.IQuadEdge;
import org.tinfour.common.Vertex;

public class TriangleCount {
    private int count;
    private double sumArea;
    private double sumArea2;
    private double minArea = Double.POSITIVE_INFINITY;
    private double maxArea = Double.NEGATIVE_INFINITY;
    private double c;
    private double c2;
    private final GeometricOperations geoOp;

    public TriangleCount() {
        this.geoOp = new GeometricOperations();
    }

    public TriangleCount(IIncrementalTin tin) {
        this.geoOp = new GeometricOperations(tin.getThresholds());
        if (tin.isBootstrapped()) {
            int maxIndex = tin.getMaximumEdgeAllocationIndex();
            int maxMapIndex = maxIndex + 2;
            BitSet bitset = new BitSet(maxMapIndex);
            Iterator<IQuadEdge> iEdge = tin.getEdgeIterator();
            while (iEdge.hasNext()) {
                IQuadEdge e = iEdge.next();
                if (e.getA() == null || e.getB() == null) {
                    this.setMarkBit(bitset, e);
                    this.setMarkBit(bitset, e.getDual());
                    continue;
                }
                this.countTriangleEdge(bitset, e);
                this.countTriangleEdge(bitset, e.getDual());
            }
        }
    }

    private void setMarkBit(BitSet bitset, IQuadEdge edge) {
        int index = edge.getIndex();
        bitset.set(index);
    }

    private boolean getMarkBit(BitSet bitset, IQuadEdge edge) {
        int index = edge.getIndex();
        return bitset.get(index);
    }

    private void countTriangleEdge(BitSet bitset, IQuadEdge e) {
        if (!this.getMarkBit(bitset, e)) {
            this.setMarkBit(bitset, e);
            IQuadEdge f = e.getForward();
            if (f.getB() != null) {
                IQuadEdge r = e.getReverse();
                if (!this.getMarkBit(bitset, f) && !this.getMarkBit(bitset, r)) {
                    this.setMarkBit(bitset, f);
                    this.setMarkBit(bitset, r);
                    this.tabulateTriangle(e.getA(), f.getA(), r.getA());
                }
            }
        }
    }

    public final void tabulateTriangle(Vertex vA, Vertex vB, Vertex vC) {
        ++this.count;
        double a = this.geoOp.area(vA, vB, vC);
        double y = a - this.c;
        double t = this.sumArea + y;
        this.c = t - this.sumArea - y;
        this.sumArea = t;
        y = a * a - this.c2;
        t = this.sumArea2 + y;
        this.c2 = t - this.sumArea2 - y;
        this.sumArea2 = t;
        if (a < this.minArea) {
            this.minArea = a;
        }
        if (a > this.maxArea) {
            this.maxArea = a;
        }
    }

    public int getCount() {
        return this.count;
    }

    public double getAreaSum() {
        return this.sumArea;
    }

    public double getAreaMean() {
        if (this.count == 0) {
            return 0.0;
        }
        return this.sumArea / (double)this.count;
    }

    public double getAreaStandardDeviation() {
        if (this.count < 2) {
            return 0.0;
        }
        double n = this.count;
        double s = n * this.sumArea2 - this.sumArea * this.sumArea;
        double t = n * (n - 1.0);
        return Math.sqrt(s / t);
    }

    public double getAreaMin() {
        return this.minArea;
    }

    public double getAreaMax() {
        return this.maxArea;
    }
}

