/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Azimuthal;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.ProjectionParameters;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public strictfp final class Gnomonic
extends Azimuthal {
    public static final String WKT_NAME = "Gnomonic";
    public static final String CENTER_LON_PROPERTY = "central_meridian";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_origin";

    public Gnomonic(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this.computeParameters();
    }

    public Gnomonic(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this.computeParameters();
    }

    @Override
    protected double getMaxC() {
        return 1.396;
    }

    @Override
    protected Coordinate forwardPointRaw(double lon, double lat, Coordinate storage) {
        double sinPhi = StrictMath.sin(lat);
        double cosPhi = StrictMath.cos(lat);
        double kPrime = 1.0 / (this._sinPhi0 * sinPhi + this._cosPhi0 * cosPhi * StrictMath.cos(lon - this._lambda0));
        storage.x = this._a * kPrime * cosPhi * StrictMath.sin(lon - this._lambda0);
        storage.y = this._a * kPrime * (this._cosPhi0 * sinPhi - this._sinPhi0 * cosPhi * StrictMath.cos(lon - this._lambda0));
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double rho = StrictMath.sqrt(x * x + y * y);
        if (rho == 0.0) {
            storage.y = this._phi0;
            storage.x = this._lambda0;
        } else {
            double c = StrictMath.atan(rho / this._a);
            double sinC = StrictMath.sin(c);
            double cosC = StrictMath.cos(c);
            storage.x = this._phi0 == 1.5707963267948966 ? this._lambda0 + StrictMath.atan(x / -y) : (this._phi0 == -1.5707963267948966 ? this._lambda0 + StrictMath.atan(x / y) : this._lambda0 + StrictMath.atan(x * sinC / (rho * this._cosPhi0 * cosC - y * this._sinPhi0 * sinC)));
            storage.y = StrictMath.asin(cosC * this._sinPhi0 + y * sinC * this._cosPhi0 / rho);
        }
        return storage;
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        return result;
    }
}

