/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.json.simple.parser.ParseException;
import org.myworldgis.io.PointZWrapper;
import org.myworldgis.io.asciigrid.AsciiGridFileReader;
import org.myworldgis.io.geojson.GeoJsonReader;
import org.myworldgis.io.shapefile.DBaseFileReader;
import org.myworldgis.io.shapefile.ESRIShapefileReader;
import org.myworldgis.netlogo.CoordinateTransformation;
import org.myworldgis.netlogo.Dataset;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.netlogo.GridDimensions;
import org.myworldgis.netlogo.RasterDataset;
import org.myworldgis.netlogo.VectorDataset;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.Geographic;
import org.myworldgis.projection.Projection;
import org.myworldgis.projection.ProjectionFormat;
import org.myworldgis.util.StringUtils;
import org.ngs.ngunits.NonSI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.converter.AbstractUnitConverter;
import org.ngs.ngunits.quantity.Angle;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.World;
import org.nlogo.core.File;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public strictfp final class LoadDataset
extends GISExtension.Reporter {
    private static final String ADDED_Z_FIELD = "_Z";
    private static Context _context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dataset loadShapefile(String shpFilePath, Projection srcProj, Projection dstProj) throws ExtensionException, IOException {
        GeometryTransformer inverse = null;
        GeometryTransformer forward = null;
        boolean reproject = false;
        if (srcProj != null && dstProj != null && !srcProj.equals(dstProj)) {
            inverse = srcProj.getInverseTransformer();
            forward = dstProj.getForwardTransformer();
            reproject = true;
        }
        ESRIShapefileReader shp = null;
        DBaseFileReader dbf = null;
        try {
            Geometry shape;
            File shpFile = GISExtension.getState().getFile(shpFilePath);
            if (shpFile == null) {
                throw new ExtensionException("shapefile " + shpFilePath + " not found");
            }
            shp = new ESRIShapefileReader(shpFile.getInputStream(), AbstractUnitConverter.IDENTITY, GISExtension.getState().factory());
            String dbfFilePath = StringUtils.changeFileExtension(shpFilePath, "dbf");
            File dbfFile = GISExtension.getState().getFile(dbfFilePath);
            if (dbfFile == null) {
                throw new ExtensionException("dbf file " + dbfFilePath + " not found");
            }
            dbf = new DBaseFileReader(dbfFile.getInputStream());
            VectorDataset.ShapeType shapeType = null;
            boolean shouldAddZField = false;
            boolean shouldWarnPartiallySupportedZ = false;
            switch (shp.getShapeType()) {
                case 1: 
                case 8: {
                    shapeType = VectorDataset.ShapeType.POINT;
                    break;
                }
                case 11: {
                    shapeType = VectorDataset.ShapeType.POINT;
                    shouldAddZField = true;
                    break;
                }
                case 18: {
                    shouldWarnPartiallySupportedZ = true;
                    shapeType = VectorDataset.ShapeType.POINT;
                    break;
                }
                case 3: {
                    shapeType = VectorDataset.ShapeType.LINE;
                    break;
                }
                case 13: {
                    shouldWarnPartiallySupportedZ = true;
                    shapeType = VectorDataset.ShapeType.LINE;
                    break;
                }
                case 5: {
                    shapeType = VectorDataset.ShapeType.POLYGON;
                    break;
                }
                case 15: {
                    shouldWarnPartiallySupportedZ = true;
                    shapeType = VectorDataset.ShapeType.POLYGON;
                    break;
                }
                default: {
                    throw new IOException("unsupported shape type " + shp.getShapeType());
                }
            }
            if (shouldWarnPartiallySupportedZ) {
                GISExtension.getState().displayWarning("The shapefile " + shpFilePath + " contains MultiPointZ, PolyLineZ, or PolygonZ features. Upon import, the Z information from these features will be stripped out and they will be treated as 2D Point, Line, and Polygon features.");
            }
            String[] propertyNames = new String[dbf.getFieldCount() + (shouldAddZField ? 1 : 0)];
            VectorDataset.PropertyType[] propertyTypes = new VectorDataset.PropertyType[propertyNames.length];
            for (int i = 0; i < dbf.getFieldCount(); ++i) {
                propertyNames[i] = dbf.getFieldName(i);
                propertyTypes[i] = dbf.getFieldDataType(i) == Syntax.NumberType() ? VectorDataset.PropertyType.NUMBER : VectorDataset.PropertyType.STRING;
            }
            if (shouldAddZField) {
                propertyNames[propertyNames.length - 1] = ADDED_Z_FIELD;
                propertyTypes[propertyTypes.length - 1] = VectorDataset.PropertyType.NUMBER;
            }
            VectorDataset result = new VectorDataset(shapeType, propertyNames, propertyTypes);
            while ((shape = shp.getNextShape()) != null) {
                double z = 0.0;
                if (shape instanceof PointZWrapper) {
                    z = ((PointZWrapper)shape).getZ();
                    shape = ((PointZWrapper)shape).getPoint();
                }
                if (reproject) {
                    shape = forward.transform(inverse.transform(shape));
                }
                if (shouldAddZField) {
                    Object[] propertyValues = new Object[propertyNames.length];
                    System.arraycopy(dbf.getNextRecord(), 0, propertyValues, 0, propertyValues.length - 1);
                    propertyValues[propertyValues.length - 1] = z;
                    result.add(shape, propertyValues);
                    continue;
                }
                result.add(shape, dbf.getNextRecord());
            }
            VectorDataset vectorDataset = result;
            return vectorDataset;
        }
        finally {
            if (shp != null) {
                try {
                    shp.close();
                }
                catch (IOException iOException) {}
            }
            if (dbf != null) {
                try {
                    dbf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VectorDataset loadGeoJson(String geojsonFilePath, Projection dstProj) throws ExtensionException, IOException {
        Geographic srcProj = new Geographic(Ellipsoid.WGS_84, Projection.DEFAULT_CENTER, (Unit<Angle>)NonSI.DEGREE_ANGLE);
        GeometryTransformer inverse = srcProj.getInverseTransformer();
        GeometryTransformer forward = null;
        boolean reproject = false;
        if (dstProj != null && !((Object)srcProj).equals(dstProj)) {
            forward = dstProj.getForwardTransformer();
            reproject = true;
        }
        File geojsonFile = null;
        try {
            VectorDataset.PropertyType[] propertyTypes;
            String[] propertyNames;
            GeoJsonReader reader;
            geojsonFile = GISExtension.getState().getFile(geojsonFilePath);
            if (geojsonFile == null) {
                throw new ExtensionException("Geojson file " + geojsonFilePath + " not found");
            }
            try {
                reader = new GeoJsonReader(geojsonFile, GISExtension.getState().factory());
            }
            catch (ParseException e) {
                throw new ExtensionException("Error parsing " + geojsonFilePath);
            }
            if (reader.getShouldAddZField()) {
                propertyNames = new String[reader.getPropertyNames().length + 1];
                propertyTypes = new VectorDataset.PropertyType[propertyNames.length];
                System.arraycopy(reader.getPropertyNames(), 0, propertyNames, 0, reader.getPropertyNames().length);
                System.arraycopy(reader.getPropertyTypes(), 0, propertyTypes, 0, reader.getPropertyTypes().length);
                propertyNames[propertyNames.length - 1] = ADDED_Z_FIELD;
                propertyTypes[propertyTypes.length - 1] = VectorDataset.PropertyType.NUMBER;
            } else {
                propertyNames = reader.getPropertyNames();
                propertyTypes = reader.getPropertyTypes();
            }
            if (reader.getContainsDefaultValues()) {
                GISExtension.getState().displayWarning("Warning: Not all the features in " + geojsonFilePath + " have the same set of properties. Default values (0 for numbers and \"\" for strings) will be supplied where there are missing entries.");
            }
            if (reader.getShouldWarnUnusedZ() && !reader.getShouldAddZField()) {
                GISExtension.getState().displayWarning("The file " + geojsonFilePath + " contains non-single-point Z values in some features. Upon import, the Z information from these features will be stripped out and they will be treated as 2D features.");
            }
            VectorDataset result = new VectorDataset(reader.getShapeType(), propertyNames, propertyTypes);
            Geometry[] geometries = reader.getGeometries();
            Object[][] propertyValues = reader.getPropertyValues();
            for (int i = 0; i < reader.size(); ++i) {
                double z = 0.0;
                boolean shouldAddZ = false;
                if (geometries[i] instanceof PointZWrapper) {
                    shouldAddZ = true;
                    z = ((PointZWrapper)geometries[i]).getZ();
                    geometries[i] = ((PointZWrapper)geometries[i]).getPoint();
                }
                if (reproject) {
                    geometries[i] = forward.transform(inverse.transform(geometries[i]));
                }
                if (shouldAddZ) {
                    Object[] newValues = new Object[propertyTypes.length];
                    System.arraycopy(propertyValues[i], 0, newValues, 0, propertyValues[i].length);
                    newValues[newValues.length - 1] = z;
                    propertyValues[i] = newValues;
                }
                result.add(geometries[i], propertyValues[i]);
            }
            VectorDataset vectorDataset = result;
            return vectorDataset;
        }
        finally {
            if (geojsonFile != null) {
                try {
                    geojsonFile.close(true);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RasterDataset loadAsciiGrid(String ascFilePath, Projection srcProj, Projection dstProj) throws ExtensionException, IOException {
        AsciiGridFileReader asc = null;
        try {
            File ascFile = GISExtension.getState().getFile(ascFilePath);
            if (ascFile == null) {
                throw new ExtensionException("ascii file " + ascFilePath + " not found");
            }
            asc = new AsciiGridFileReader(new BufferedReader(new InputStreamReader(ascFile.getInputStream())));
            GridDimensions dimensions = new GridDimensions(asc.getSize(), asc.getEnvelope());
            DataBuffer data = asc.getData();
            BandedSampleModel sampleModel = new BandedSampleModel(data.getDataType(), dimensions.getGridWidth(), dimensions.getGridHeight(), 1);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, data, null);
            if (srcProj != null && dstProj != null && !srcProj.equals(dstProj)) {
                RasterDataset rasterDataset = new RasterDataset(raster, dimensions, srcProj, dstProj);
                return rasterDataset;
            }
            RasterDataset rasterDataset = new RasterDataset(dimensions, raster);
            return rasterDataset;
        }
        finally {
            if (asc != null) {
                try {
                    asc.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getAgentClassString() {
        return "OTPL";
    }

    public Syntax getSyntax() {
        return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.WildcardType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object reportInternal(Argument[] args, Context context) throws ExtensionException, IOException, LogoException, java.text.ParseException {
        _context = context;
        String dataFilePath = args[0].getString();
        Projection netLogoProjection = GISExtension.getState().getProjection();
        Projection datasetProjection = null;
        File prjFile = GISExtension.getState().getFile(StringUtils.changeFileExtension(dataFilePath, "prj"));
        if (prjFile != null) {
            try (BufferedReader prjReader = new BufferedReader(new InputStreamReader(prjFile.getInputStream()));){
                datasetProjection = ProjectionFormat.getInstance().parseProjection(prjReader);
            }
        }
        String extension = StringUtils.getFileExtension(dataFilePath);
        Dataset result = null;
        if (extension.equalsIgnoreCase("shp")) {
            result = LoadDataset.loadShapefile(dataFilePath, datasetProjection, netLogoProjection);
        } else if (extension.equalsIgnoreCase("asc") || extension.equalsIgnoreCase("grd")) {
            result = LoadDataset.loadAsciiGrid(dataFilePath, datasetProjection, netLogoProjection);
        } else if (extension.equalsIgnoreCase("geojson") || extension.equalsIgnoreCase("json")) {
            result = LoadDataset.loadGeoJson(dataFilePath, netLogoProjection);
        } else {
            throw new ExtensionException("unsupported file type " + extension);
        }
        if (!GISExtension.getState().isTransformationSet()) {
            World w = context.getAgent().world();
            GISExtension.getState().setTransformation(new CoordinateTransformation(result.getEnvelope(), new Envelope((double)w.minPxcor(), (double)w.maxPxcor(), (double)w.minPycor(), (double)w.maxPycor()), true));
        }
        return result;
    }
}

