/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.content.animation.animator;

import org.openimaj.content.animation.animator.LinearLongValueAnimator;
import org.openimaj.content.animation.animator.RandomLinearLongValueAnimator;
import org.openimaj.content.animation.animator.ValueAnimator;

public class LongArrayValueAnimator
implements ValueAnimator<long[]> {
    ValueAnimator<Long>[] animators;

    @SafeVarargs
    public LongArrayValueAnimator(ValueAnimator<Long> ... animators) {
        this.animators = animators;
    }

    public static LongArrayValueAnimator makeLinear(int duration, long ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new LinearLongValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new LongArrayValueAnimator(animators);
    }

    public static LongArrayValueAnimator makeLinear(int duration, int count, long start, long finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new LinearLongValueAnimator(start, finish, duration);
        }
        return new LongArrayValueAnimator(animators);
    }

    public static LongArrayValueAnimator makeRandomLinear(int duration, long ... maxs) {
        ValueAnimator[] animators = new ValueAnimator[maxs.length];
        for (int i = 0; i < maxs.length; ++i) {
            animators[i] = new RandomLinearLongValueAnimator(-maxs[i], maxs[i], duration);
        }
        return new LongArrayValueAnimator(animators);
    }

    public static LongArrayValueAnimator makeRandomLinear(int duration, int count, long start, long finish) {
        ValueAnimator[] animators = new ValueAnimator[count];
        for (int i = 0; i < count; ++i) {
            animators[i] = new RandomLinearLongValueAnimator(start, finish, duration);
        }
        return new LongArrayValueAnimator(animators);
    }

    @Override
    public long[] nextValue() {
        long[] value = new long[this.animators.length];
        for (int i = 0; i < this.animators.length; ++i) {
            value[i] = this.animators[i].nextValue();
        }
        return value;
    }

    @Override
    public boolean hasFinished() {
        for (ValueAnimator<Long> a : this.animators) {
            if (a.hasFinished()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        for (ValueAnimator<Long> animator : this.animators) {
            animator.reset();
        }
    }
}

