/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.la4j.io.MatrixStream;
import org.la4j.io.VectorStream;

public abstract class AbstractStream
implements MatrixStream,
VectorStream {
    protected BufferedReader reader;
    protected BufferedWriter writer;

    public AbstractStream(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public AbstractStream(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
    }

    protected void ensureReaderInitialized() {
        if (this.reader == null) {
            throw new IllegalStateException();
        }
    }

    protected void ensureWriterInitialized() {
        if (this.writer == null) {
            throw new IllegalStateException();
        }
    }

    protected void closeWriter() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected void closeReader() throws IOException {
        this.reader.close();
    }
}

