/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;

public class SingularValueDecompositor
implements MatrixDecompositor {
    @Override
    public Matrix[] decompose(Matrix matrix, Factory factory) {
        int i;
        double t;
        int k;
        int j;
        if (matrix.rows() < matrix.columns()) {
            throw new IllegalArgumentException("Wrong matrix size: rows < columns");
        }
        Matrix a = matrix.copy();
        int n = Math.min(a.rows(), a.columns());
        Matrix u = factory.createMatrix(a.rows(), n);
        Matrix s = factory.createMatrix(a.columns(), a.columns());
        Matrix v = factory.createMatrix(a.columns(), a.columns());
        Vector e = factory.createVector(a.columns());
        Vector work = factory.createVector(a.rows());
        int nct = Math.min(a.rows() - 1, a.columns());
        int nrt = Math.max(0, Math.min(a.columns() - 2, a.rows()));
        for (int k2 = 0; k2 < Math.max(nct, nrt); ++k2) {
            int i2;
            int i3;
            if (k2 < nct) {
                for (i3 = k2; i3 < a.rows(); ++i3) {
                    s.set(k2, k2, this.hypot(s.get(k2, k2), a.get(i3, k2)));
                }
                if (Math.abs(s.get(k2, k2)) > Matrices.EPS) {
                    if (a.get(k2, k2) < 0.0) {
                        s.update(k2, k2, Matrices.INV_FUNCTION);
                    }
                    for (i3 = k2; i3 < a.rows(); ++i3) {
                        a.update(i3, k2, Matrices.asDivFunction(s.get(k2, k2)));
                    }
                    a.update(k2, k2, Matrices.INC_FUNCTION);
                }
                s.update(k2, k2, Matrices.INV_FUNCTION);
            }
            for (j = k2 + 1; j < a.columns(); ++j) {
                if (k2 < nct & Math.abs(s.get(k2, k2)) > Matrices.EPS) {
                    double t2 = 0.0;
                    for (i2 = k2; i2 < a.rows(); ++i2) {
                        t2 += a.get(i2, k2) * a.get(i2, j);
                    }
                    t2 = -t2 / a.get(k2, k2);
                    for (i2 = k2; i2 < a.rows(); ++i2) {
                        a.update(i2, j, Matrices.asPlusFunction(t2 * a.get(i2, k2)));
                    }
                }
                e.set(j, a.get(k2, j));
            }
            if (k2 < nct) {
                for (i3 = k2; i3 < a.rows(); ++i3) {
                    u.set(i3, k2, a.get(i3, k2));
                }
            }
            if (k2 >= nrt) continue;
            e.set(k2, 0.0);
            for (i3 = k2 + 1; i3 < a.columns(); ++i3) {
                e.set(k2, this.hypot(e.get(k2), e.get(i3)));
            }
            if (Math.abs(e.get(k2)) > Matrices.EPS) {
                if (e.get(k2 + 1) < 0.0) {
                    e.update(k2, Vectors.INV_FUNCTION);
                }
                for (i3 = k2 + 1; i3 < a.columns(); ++i3) {
                    e.update(i3, Vectors.asDivFunction(e.get(k2)));
                }
                e.update(k2 + 1, Vectors.INC_FUNCTION);
            }
            e.set(k2, -e.get(k2));
            if (k2 + 1 < a.rows() & Math.abs(e.get(k2)) > Matrices.EPS) {
                for (j = k2 + 1; j < a.columns(); ++j) {
                    for (int i4 = k2 + 1; i4 < a.rows(); ++i4) {
                        work.update(i4, Vectors.asPlusFunction(e.get(j) * a.get(i4, j)));
                    }
                }
                for (j = k2 + 1; j < a.columns(); ++j) {
                    double t3 = -e.get(j) / e.get(k2 + 1);
                    for (i2 = k2 + 1; i2 < a.rows(); ++i2) {
                        a.update(i2, j, Matrices.asPlusFunction(t3 * work.get(i2)));
                    }
                }
            }
            for (i3 = k2 + 1; i3 < a.columns(); ++i3) {
                v.set(i3, k2, e.get(i3));
            }
        }
        int p = Math.min(a.columns(), a.rows() + 1);
        if (nct < a.columns()) {
            s.set(nct, nct, a.get(nct, nct));
        }
        if (a.rows() < p) {
            s.set(p - 1, p - 1, 0.0);
        }
        if (nrt + 1 < p) {
            e.set(nrt, a.get(nrt, p - 1));
        }
        e.set(p - 1, 0.0);
        for (j = nct; j < n; ++j) {
            for (int i5 = 0; i5 < a.rows(); ++i5) {
                u.set(i5, j, 0.0);
            }
            u.set(j, j, 1.0);
        }
        for (k = nct - 1; k >= 0; --k) {
            int i6;
            if (Math.abs(s.get(k, k)) > Matrices.EPS) {
                for (int j2 = k + 1; j2 < n; ++j2) {
                    t = 0.0;
                    for (i = k; i < a.rows(); ++i) {
                        t += u.get(i, k) * u.get(i, j2);
                    }
                    t = -t / u.get(k, k);
                    for (i = k; i < a.rows(); ++i) {
                        u.update(i, j2, Matrices.asPlusFunction(t * u.get(i, k)));
                    }
                }
                for (i6 = k; i6 < a.rows(); ++i6) {
                    u.update(i6, k, Matrices.INV_FUNCTION);
                }
                u.update(k, k, Matrices.INC_FUNCTION);
                for (i6 = 0; i6 < k - 1; ++i6) {
                    u.set(i6, k, 0.0);
                }
                continue;
            }
            for (i6 = 0; i6 < a.rows(); ++i6) {
                u.set(i6, k, 0.0);
            }
            u.set(k, k, 1.0);
        }
        for (k = n - 1; k >= 0; --k) {
            if (k < nrt & Math.abs(e.get(k)) > Matrices.EPS) {
                for (int j3 = k + 1; j3 < n; ++j3) {
                    t = 0.0;
                    for (i = k + 1; i < a.columns(); ++i) {
                        t += v.get(i, k) * v.get(i, j3);
                    }
                    t = -t / v.get(k + 1, k);
                    for (i = k + 1; i < a.columns(); ++i) {
                        v.update(i, j3, Matrices.asPlusFunction(t * v.get(i, k)));
                    }
                }
            }
            for (int i7 = 0; i7 < a.columns(); ++i7) {
                v.set(i7, k, 0.0);
            }
            v.set(k, k, 1.0);
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block34: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e.get(k3)) <= tiny + eps * (Math.abs(s.get(k3, k3)) + Math.abs(s.get(k3 + 1, k3 + 1))))) continue;
                e.set(k3, 0.0);
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t4 = (ks != p ? Math.abs(e.get(ks)) : 0.0) + (ks != k3 + 1 ? Math.abs(e.get(ks - 1)) : 0.0);
                    if (!(Math.abs(s.get(ks, ks)) <= tiny + eps * t4)) continue;
                    s.set(ks, ks, 0.0);
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e.get(p - 2);
                    e.set(p - 2, 0.0);
                    for (int j4 = p - 2; j4 >= k3; --j4) {
                        t5 = this.hypot(s.get(j4, j4), f);
                        cs = s.get(j4, j4) / t5;
                        sn = f / t5;
                        s.set(j4, j4, t5);
                        if (j4 != k3) {
                            f = -sn * e.get(j4 - 1);
                            e.set(j4 - 1, cs * e.get(j4 - 1));
                        }
                        for (i8 = 0; i8 < a.columns(); ++i8) {
                            t5 = cs * v.get(i8, j4) + sn * v.get(i8, p - 1);
                            v.set(i8, p - 1, -sn * v.get(i8, j4) + cs * v.get(i8, p - 1));
                            v.set(i8, j4, t5);
                        }
                    }
                    continue block34;
                }
                case 2: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e.get(k3 - 1);
                    e.set(k3 - 1, 0.0);
                    for (int j5 = k3; j5 < p; ++j5) {
                        t5 = this.hypot(s.get(j5, j5), f);
                        cs = s.get(j5, j5) / t5;
                        sn = f / t5;
                        s.set(j5, j5, t5);
                        f = -sn * e.get(j5);
                        e.set(j5, cs * e.get(j5));
                        for (i8 = 0; i8 < a.rows(); ++i8) {
                            t5 = cs * u.get(i8, j5) + sn * u.get(i8, k3 - 1);
                            u.set(i8, k3 - 1, -sn * u.get(i8, j5) + cs * u.get(i8, k3 - 1));
                            u.set(i8, j5, t5);
                        }
                    }
                    continue block34;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(s.get(p - 1, p - 1)), Math.abs(s.get(p - 2, p - 2))), Math.abs(e.get(p - 2))), Math.abs(s.get(k3, k3))), Math.abs(e.get(k3)));
                    double sp = s.get(p - 1, p - 1) / scale;
                    double spm1 = s.get(p - 2, p - 2) / scale;
                    double epm1 = e.get(p - 2) / scale;
                    double sk = s.get(k3, k3) / scale;
                    double ek = e.get(k3) / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j6 = k3; j6 < p - 1; ++j6) {
                        int i9;
                        double t6 = this.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e.set(j6 - 1, t6);
                        }
                        f = cs * s.get(j6, j6) + sn * e.get(j6);
                        e.set(j6, cs * e.get(j6) - sn * s.get(j6, j6));
                        g = sn * s.get(j6 + 1, j6 + 1);
                        s.set(j6 + 1, j6 + 1, cs * s.get(j6 + 1, j6 + 1));
                        for (i9 = 0; i9 < a.columns(); ++i9) {
                            t6 = cs * v.get(i9, j6) + sn * v.get(i9, j6 + 1);
                            v.set(i9, j6 + 1, -sn * v.get(i9, j6) + cs * v.get(i9, j6 + 1));
                            v.set(i9, j6, t6);
                        }
                        t6 = this.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        s.set(j6, j6, t6);
                        f = cs * e.get(j6) + sn * s.get(j6 + 1, j6 + 1);
                        s.set(j6 + 1, j6 + 1, -sn * e.get(j6) + cs * s.get(j6 + 1, j6 + 1));
                        g = sn * e.get(j6 + 1);
                        e.update(j6 + 1, Vectors.asMulFunction(cs));
                        if (j6 >= a.rows() - 1) continue;
                        for (i9 = 0; i9 < a.rows(); ++i9) {
                            t6 = cs * u.get(i9, j6) + sn * u.get(i9, j6 + 1);
                            u.set(i9, j6 + 1, -sn * u.get(i9, j6) + cs * u.get(i9, j6 + 1));
                            u.set(i9, j6, t6);
                        }
                    }
                    e.set(p - 2, f);
                    ++iter;
                    break;
                }
                case 4: {
                    if (s.get(k3, k3) <= 0.0) {
                        s.set(k3, k3, s.get(k3, k3) < 0.0 ? -s.get(k3, k3) : 0.0);
                        for (int i10 = 0; i10 <= pp; ++i10) {
                            v.update(i10, k3, Matrices.INV_FUNCTION);
                        }
                    }
                    while (k3 < pp && !(s.get(k3, k3) >= s.get(k3 + 1, k3 + 1))) {
                        int i11;
                        double t7 = s.get(k3, k3);
                        s.set(k3, k3, s.get(k3 + 1, k3 + 1));
                        s.set(k3 + 1, k3 + 1, t7);
                        if (k3 < a.columns() - 1) {
                            for (i11 = 0; i11 < a.columns(); ++i11) {
                                t7 = v.get(i11, k3 + 1);
                                v.set(i11, k3 + 1, v.get(i11, k3));
                                v.set(i11, k3, t7);
                            }
                        }
                        if (k3 < a.rows() - 1) {
                            for (i11 = 0; i11 < a.rows(); ++i11) {
                                t7 = u.get(i11, k3 + 1);
                                u.set(i11, k3 + 1, u.get(i11, k3));
                                u.set(i11, k3, t7);
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
        return new Matrix[]{u, s, v};
    }

    private double hypot(double a, double b) {
        double result;
        if (Math.abs(a) > Math.abs(b)) {
            result = b / a;
            result = Math.abs(a) * Math.sqrt(1.0 + result * result);
        } else if (b != 0.0) {
            result = a / b;
            result = Math.abs(b) * Math.sqrt(1.0 + result * result);
        } else {
            result = 0.0;
        }
        return result;
    }
}

