/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.ngs.ngunits.SystemOfUnits;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.format.SymbolMap;
import org.ngs.ngunits.format.UnitFormat;

public final class UserDefined
extends SystemOfUnits {
    public static UnitFormat FORMAT = UnitFormat.getInstance(new UserSymbolMap(ResourceBundle.getBundle("org.ngs.ngunits.format.UnitFormat")));

    private UserDefined() {
    }

    public static boolean isDefinitionEnabled() {
        return ((UserSymbolMap)FORMAT.getSymbols()).isDefinitionEnabled();
    }

    public static void setDefinitionEnabled(boolean bl) {
        ((UserSymbolMap)FORMAT.getSymbols()).setDefinitionEnabled(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class UserSymbolMap
    extends SymbolMap {
        private static final Pattern RESERVED_CHARS = Pattern.compile("[\u0000-\u001f\\(\\)\\*\\+\\-\\./0-9:\\^\u00b2\u00b3\u00b7\u00b9\u2070\u2074-\u2079]");
        private Map<String, Unit<?>> _symbolToUnit = new HashMap();
        private Map<Unit<?>, String> _unitToSymbol = new HashMap();
        private boolean _definitionEnabled = true;

        protected UserSymbolMap(ResourceBundle resourceBundle) {
            super(resourceBundle);
        }

        @Override
        public SymbolMap.Entry lookup(String string) {
            SymbolMap.Entry entry = super.lookup(string);
            if (entry == null) {
                String string2 = UserSymbolMap.makeValidUnitName(string);
                if (string2 == null) {
                    return null;
                }
                if (!string2.equals(string)) {
                    return this.lookup(string2);
                }
                Unit unit = this._symbolToUnit.get(string);
                if (unit == null && this._definitionEnabled) {
                    unit = SystemOfUnits.u(SystemOfUnits.DELEGATE.one().alternate(string));
                    this._symbolToUnit.put(string, unit);
                    this._unitToSymbol.put(unit, string);
                }
                if (unit != null) {
                    return new SymbolMap.Entry(null, unit);
                }
                return null;
            }
            return entry;
        }

        @Override
        public String getSymbol(Unit<?> unit) {
            String string = super.getSymbol(unit);
            if (string != null) {
                return string;
            }
            return this._unitToSymbol.get(unit);
        }

        public boolean isDefinitionEnabled() {
            return this._definitionEnabled;
        }

        public void setDefinitionEnabled(boolean bl) {
            this._definitionEnabled = bl;
        }

        private static final String makeValidUnitName(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (RESERVED_CHARS.matcher(string.substring(i, i + 1)).matches()) continue;
                char c = string.charAt(i);
                if (Character.isWhitespace(c)) {
                    stringBuilder.append('_');
                    continue;
                }
                stringBuilder.append(c);
                bl = true;
            }
            return bl ? stringBuilder.toString() : null;
        }
    }
}

