/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photos.geo;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.photos.GeoData;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotoUtils;
import com.flickr4java.flickr.photos.geo.GeoPermissions;
import com.flickr4java.flickr.util.StringUtilities;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GeoInterface {
    public static final String METHOD_GET_LOCATION = "flickr.photos.geo.getLocation";
    public static final String METHOD_GET_PERMS = "flickr.photos.geo.getPerms";
    public static final String METHOD_REMOVE_LOCATION = "flickr.photos.geo.removeLocation";
    public static final String METHOD_SET_LOCATION = "flickr.photos.geo.setLocation";
    public static final String METHOD_SET_PERMS = "flickr.photos.geo.setPerms";
    public static final String METHOD_BATCH_CORRECT_LOCATION = "flickr.photos.geo.batchCorrectLocation";
    public static final String METHOD_CORRECT_LOCATION = "flickr.photos.geo.correctLocation";
    public static final String METHOD_PHOTOS_FOR_LOCATION = "flickr.photos.geo.photosForLocation";
    public static final String METHOD_SET_CONTEXT = "flickr.photos.geo.setContext";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transport;

    public GeoInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transport = transport;
    }

    public GeoData getLocation(String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LOCATION);
        parameters.put("photo_id", photoId);
        Response response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photoElement = response.getPayload();
        Element locationElement = XMLUtilities.getChild(photoElement, "location");
        String latStr = locationElement.getAttribute("latitude");
        String lonStr = locationElement.getAttribute("longitude");
        String accStr = locationElement.getAttribute("accuracy");
        GeoData geoData = new GeoData(lonStr, latStr, accStr);
        return geoData;
    }

    public GeoPermissions getPerms(String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_PERMS);
        parameters.put("photo_id", photoId);
        Response response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        GeoPermissions perms = new GeoPermissions();
        Element permsElement = response.getPayload();
        perms.setPublic("1".equals(permsElement.getAttribute("ispublic")));
        perms.setContact("1".equals(permsElement.getAttribute("iscontact")));
        perms.setFriend("1".equals(permsElement.getAttribute("isfriend")));
        perms.setFamily("1".equals(permsElement.getAttribute("isfamily")));
        perms.setId(permsElement.getAttribute("id"));
        return perms;
    }

    public void removeLocation(String photoId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_REMOVE_LOCATION);
        parameters.put("photo_id", photoId);
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void setLocation(String photoId, GeoData location) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_LOCATION);
        parameters.put("photo_id", photoId);
        parameters.put("lat", String.valueOf(location.getLatitude()));
        parameters.put("lon", String.valueOf(location.getLongitude()));
        int accuracy = location.getAccuracy();
        if (accuracy > 0) {
            parameters.put("accuracy", String.valueOf(location.getAccuracy()));
        }
        if ((response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void setPerms(String photoId, GeoPermissions perms) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_PERMS);
        parameters.put("photo_id", photoId);
        parameters.put("is_public", perms.isPublic() ? "1" : "0");
        parameters.put("is_contact", perms.isContact() ? "1" : "0");
        parameters.put("is_friend", perms.isFriend() ? "1" : "0");
        parameters.put("is_family", perms.isFamily() ? "1" : "0");
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void batchCorrectLocation(GeoData location, String placeId, String woeId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_BATCH_CORRECT_LOCATION);
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        parameters.put("lat", Float.toString(location.getLatitude()));
        parameters.put("lon", Float.toString(location.getLongitude()));
        parameters.put("accuracy", Integer.toString(location.getAccuracy()));
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public void correctLocation(String photoId, String placeId, String woeId) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_CORRECT_LOCATION);
        parameters.put("photo_id", photoId);
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if ((response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }

    public PhotoList<Photo> photosForLocation(GeoData location, Set<String> extras, int perPage, int page) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PhotoList<Photo> photos = new PhotoList<Photo>();
        parameters.put("method", METHOD_PHOTOS_FOR_LOCATION);
        if (extras.size() > 0) {
            parameters.put("extras", StringUtilities.join(extras, ","));
        }
        if (perPage > 0) {
            parameters.put("per_page", Integer.toString(perPage));
        }
        if (page > 0) {
            parameters.put("page", Integer.toString(page));
        }
        parameters.put("lat", Float.toString(location.getLatitude()));
        parameters.put("lon", Float.toString(location.getLongitude()));
        parameters.put("accuracy", Integer.toString(location.getAccuracy()));
        Response response = this.transport.get(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element photosElement = response.getPayload();
        photos.setPage(photosElement.getAttribute("page"));
        photos.setPages(photosElement.getAttribute("pages"));
        photos.setPerPage(photosElement.getAttribute("perpage"));
        photos.setTotal(photosElement.getAttribute("total"));
        NodeList photoElements = photosElement.getElementsByTagName("photo");
        for (int i = 0; i < photoElements.getLength(); ++i) {
            Element photoElement = (Element)photoElements.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement));
        }
        return photos;
    }

    public void setContext(String photoId, int context) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_CONTEXT);
        parameters.put("photo_id", photoId);
        parameters.put("context", "" + context);
        Response response = this.transport.post(this.transport.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

