/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photos;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.util.StringUtilities;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SearchParameters {
    private String userId;
    private String groupId;
    private String woeId;
    private String media;
    private String contacts;
    private String[] tags;
    private String tagMode;
    private String text;
    private Date minUploadDate;
    private Date maxUploadDate;
    private Date minTakenDate;
    private Date maxTakenDate;
    private Date interestingnessDate;
    private String license;
    private Set<String> extras;
    private String[] bbox;
    private String placeId;
    private int accuracy = 0;
    private String safeSearch;
    private String[] machineTags;
    private String machineTagMode;
    private String latitude;
    private String longitude;
    private int radius = -1;
    private String radiusUnits;
    private boolean hasGeo = false;
    private boolean inGallery = false;
    private boolean isCommons = false;
    private boolean isGetty = false;
    public static final ThreadLocal<SimpleDateFormat> DATE_FORMATS = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> MYSQL_DATE_FORMATS = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static int DATE_POSTED_DESC = 0;
    public static int DATE_POSTED_ASC = 1;
    public static int DATE_TAKEN_DESC = 2;
    public static int DATE_TAKEN_ASC = 3;
    public static int INTERESTINGNESS_DESC = 4;
    public static int INTERESTINGNESS_ASC = 5;
    public static int RELEVANCE = 6;
    private int sort = 0;

    public void setAccuracy(int accuracy) {
        this.accuracy = accuracy;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setHasGeo(boolean hasGeo) {
        this.hasGeo = hasGeo;
    }

    public boolean getHasGeo() {
        return this.hasGeo;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public String getTagMode() {
        return this.tagMode;
    }

    public void setTagMode(String tagMode) {
        this.tagMode = tagMode;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Date getMinUploadDate() {
        return this.minUploadDate;
    }

    public void setMinUploadDate(Date minUploadDate) {
        this.minUploadDate = minUploadDate;
    }

    public Date getMaxUploadDate() {
        return this.maxUploadDate;
    }

    public void setMaxUploadDate(Date maxUploadDate) {
        this.maxUploadDate = maxUploadDate;
    }

    public Date getMinTakenDate() {
        return this.minTakenDate;
    }

    public void setMinTakenDate(Date minTakenDate) {
        this.minTakenDate = minTakenDate;
    }

    public Date getMaxTakenDate() {
        return this.maxTakenDate;
    }

    public void setMaxTakenDate(Date maxTakenDate) {
        this.maxTakenDate = maxTakenDate;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public Date getInterestingnessDate() {
        return this.interestingnessDate;
    }

    public void setInterestingnessDate(Date intrestingnessDate) {
        this.interestingnessDate = intrestingnessDate;
    }

    public void setMachineTags(String[] tags) {
        this.machineTags = tags;
    }

    public String[] getMachineTags() {
        return this.machineTags;
    }

    public void setMachineTagMode(String tagMode) {
        this.machineTagMode = tagMode;
    }

    public String getMachineTagMode() {
        return this.machineTagMode;
    }

    public void setExtras(Set<String> extras) {
        this.extras = extras;
    }

    public void setBBox(String minimum_longitude, String minimum_latitude, String maximum_longitude, String maximum_latitude) {
        this.bbox = new String[]{minimum_longitude, minimum_latitude, maximum_longitude, maximum_latitude};
    }

    public String[] getBBox() {
        return this.bbox;
    }

    public void setSafeSearch(String level) {
        this.safeSearch = level;
    }

    public String getSafeSearch() {
        return this.safeSearch;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int order) {
        this.sort = order;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public String getWoeId() {
        return this.woeId;
    }

    public void setWoeId(String woeId) {
        this.woeId = woeId;
    }

    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) throws FlickrException {
        if (!(media.equals("all") || media.equals("photos") || media.equals("videos"))) {
            throw new FlickrException("0", "Media type is not valid.");
        }
        this.media = media;
    }

    public String getContacts() {
        return this.contacts;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public Map<String, Object> getAsParameters() {
        boolean isGetty;
        boolean isCommons;
        boolean inGallery;
        boolean hasGeo;
        String safeSearch;
        String[] bbox;
        Date intrestingnessDate;
        String license;
        Date maxTakenDate;
        Date minTakenDate;
        Date maxUploadDate;
        Date minUploadDate;
        String text;
        String mtagMode;
        String[] mtags;
        String tagMode;
        String[] tags;
        String groupId;
        String userId;
        String media;
        String radiusUnits;
        int radius;
        String lon;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String lat = this.getLatitude();
        if (lat != null) {
            parameters.put("lat", lat);
        }
        if ((lon = this.getLongitude()) != null) {
            parameters.put("lon", lon);
        }
        if ((radius = this.getRadius()) > 0) {
            parameters.put("radius", Integer.toString(radius));
        }
        if ((radiusUnits = this.getRadiusUnits()) != null) {
            parameters.put("radius_units", radiusUnits);
        }
        if ((media = this.getMedia()) != null) {
            parameters.put("media", media);
        }
        if ((userId = this.getUserId()) != null) {
            parameters.put("user_id", userId);
            String contacts = this.getContacts();
            if (contacts != null) {
                parameters.put("contacts", contacts);
            }
        }
        if ((groupId = this.getGroupId()) != null) {
            parameters.put("group_id", groupId);
        }
        if ((tags = this.getTags()) != null) {
            parameters.put("tags", StringUtilities.join(tags, ","));
        }
        if ((tagMode = this.getTagMode()) != null) {
            parameters.put("tag_mode", tagMode);
        }
        if ((mtags = this.getMachineTags()) != null) {
            parameters.put("machine_tags", StringUtilities.join(mtags, ","));
        }
        if ((mtagMode = this.getMachineTagMode()) != null) {
            parameters.put("machine_tag_mode", mtagMode);
        }
        if ((text = this.getText()) != null) {
            parameters.put("text", text);
        }
        if ((minUploadDate = this.getMinUploadDate()) != null) {
            parameters.put("min_upload_date", Long.toString(minUploadDate.getTime() / 1000L));
        }
        if ((maxUploadDate = this.getMaxUploadDate()) != null) {
            parameters.put("max_upload_date", Long.toString(maxUploadDate.getTime() / 1000L));
        }
        if ((minTakenDate = this.getMinTakenDate()) != null) {
            parameters.put("min_taken_date", ((DateFormat)MYSQL_DATE_FORMATS.get()).format(minTakenDate));
        }
        if ((maxTakenDate = this.getMaxTakenDate()) != null) {
            parameters.put("max_taken_date", ((DateFormat)MYSQL_DATE_FORMATS.get()).format(maxTakenDate));
        }
        if ((license = this.getLicense()) != null) {
            parameters.put("license", license);
        }
        if ((intrestingnessDate = this.getInterestingnessDate()) != null) {
            parameters.put("date", ((DateFormat)DATE_FORMATS.get()).format(intrestingnessDate));
        }
        if ((bbox = this.getBBox()) != null) {
            parameters.put("bbox", StringUtilities.join(bbox, ","));
            if (this.accuracy > 0) {
                parameters.put("accuracy", Integer.toString(this.accuracy));
            }
        } else {
            String woeId = this.getWoeId();
            if (woeId != null) {
                parameters.put("woe_id", woeId);
            }
        }
        if ((safeSearch = this.getSafeSearch()) != null) {
            parameters.put("safe_search", safeSearch);
        }
        if (hasGeo = this.getHasGeo()) {
            parameters.put("has_geo", "true");
        }
        if (inGallery = this.getInGallery()) {
            parameters.put("in_gallery", "true");
        }
        if (isCommons = this.getIsCommons()) {
            parameters.put("is_commons", "true");
        }
        if (isGetty = this.getIsGetty()) {
            parameters.put("is_getty", "true");
        }
        if (this.extras != null && !this.extras.isEmpty()) {
            parameters.put("extras", StringUtilities.join(this.extras, ","));
        }
        if (this.sort != DATE_POSTED_DESC) {
            String sortArg = null;
            if (this.sort == DATE_POSTED_ASC) {
                sortArg = "date-posted-asc";
            }
            if (this.sort == DATE_TAKEN_DESC) {
                sortArg = "date-taken-desc";
            }
            if (this.sort == DATE_TAKEN_ASC) {
                sortArg = "date-taken-asc";
            }
            if (this.sort == INTERESTINGNESS_DESC) {
                sortArg = "interestingness-desc";
            }
            if (this.sort == INTERESTINGNESS_ASC) {
                sortArg = "interestingness-asc";
            }
            if (this.sort == RELEVANCE) {
                sortArg = "relevance";
            }
            if (sortArg != null) {
                parameters.put("sort", sortArg);
            }
        }
        if (this.placeId != null && !this.placeId.isEmpty()) {
            parameters.put("place_id", this.placeId);
        }
        return parameters;
    }

    public void setLatitude(String lat) {
        this.latitude = lat;
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    public void setLongitude(String lon) {
        this.longitude = lon;
    }

    public void setRadiusUnits(String units) {
        this.radiusUnits = units;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public int getRadius() {
        return this.radius;
    }

    public String getRadiusUnits() {
        return this.radiusUnits;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setInGallery(boolean inGallery) {
        this.inGallery = inGallery;
    }

    public boolean getInGallery() {
        return this.inGallery;
    }

    public void setIsCommons(boolean isCommons) {
        this.isCommons = isCommons;
    }

    public boolean getIsCommons() {
        return this.isCommons;
    }

    public void setIsGetty(boolean isGetty) {
        this.isGetty = isGetty;
    }

    public boolean getIsGetty() {
        return this.isGetty;
    }
}

