/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.movtool.streaming.tracks.ByteChannelPool;
import org.jcodec.movtool.streaming.tracks.SeekableByteChannelWrapper;

public class FilePool
implements ByteChannelPool {
    private BlockingQueue<SeekableByteChannel> channels;
    private List<SeekableByteChannel> allChannels = Collections.synchronizedList(new ArrayList());
    private File file;
    private int max;

    public FilePool(File file, int max) {
        this.file = file;
        this.max = max;
        this.channels = new LinkedBlockingQueue<SeekableByteChannel>();
    }

    @Override
    public SeekableByteChannel getChannel() throws IOException {
        SeekableByteChannel channel = (SeekableByteChannel)this.channels.poll();
        if (channel == null) {
            if (this.allChannels.size() < this.max) {
                channel = this.newChannel(this.file);
                this.allChannels.add(channel);
            } else {
                while (true) {
                    try {
                        channel = this.channels.take();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        return new PoolChannel(channel);
    }

    protected SeekableByteChannel newChannel(File file) throws FileNotFoundException {
        return NIOUtils.readableFileChannel(file);
    }

    @Override
    public void close() {
        while (!this.allChannels.isEmpty()) {
            SeekableByteChannel channel = this.allChannels.remove(0);
            if (channel == null) continue;
            try {
                channel.close();
            }
            catch (IOException iOException) {}
        }
    }

    public class PoolChannel
    extends SeekableByteChannelWrapper {
        public PoolChannel(SeekableByteChannel src) throws IOException {
            super(src);
            src.position(0L);
        }

        @Override
        public boolean isOpen() {
            return this.src != null;
        }

        @Override
        public void close() throws IOException {
            SeekableByteChannel ret = this.src;
            this.src = null;
            while (true) {
                try {
                    FilePool.this.channels.put(ret);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

