/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;

public class ClearApertureBox
extends FullBox {
    private float width;
    private float height;

    public static String fourcc() {
        return "clef";
    }

    public ClearApertureBox(Header atom) {
        super(atom);
    }

    public ClearApertureBox() {
        super(new Header(ClearApertureBox.fourcc()));
    }

    public ClearApertureBox(int width, int height) {
        this();
        this.width = width;
        this.height = height;
    }

    public ClearApertureBox(Header header, int width, int height) {
        super(header);
        this.width = width;
        this.height = height;
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.width = (float)input.getInt() / 65536.0f;
        this.height = (float)input.getInt() / 65536.0f;
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt((int)(this.width * 65536.0f));
        out.putInt((int)(this.height * 65536.0f));
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }
}

