/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jcodec.common.Codec;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.BoxFactory;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.MovieFragmentBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.TrakBox;

public class MP4Util {
    private static Map<Codec, String> codecMapping = new HashMap<Codec, String>();

    public static MovieBox createRefMovie(SeekableByteChannel input, String url) throws IOException {
        MovieBox movie = MP4Util.parseMovie(input);
        for (TrakBox trakBox : movie.getTracks()) {
            trakBox.setDataRef(url);
        }
        return movie;
    }

    public static MovieBox parseMovie(SeekableByteChannel input) throws IOException {
        for (Atom atom : MP4Util.getRootAtoms(input)) {
            if (!"moov".equals(atom.getHeader().getFourcc())) continue;
            return (MovieBox)atom.parseBox(input);
        }
        return null;
    }

    public static List<MovieFragmentBox> parseMovieFragments(SeekableByteChannel input) throws IOException {
        MovieBox moov = null;
        LinkedList<MovieFragmentBox> fragments = new LinkedList<MovieFragmentBox>();
        for (Atom atom : MP4Util.getRootAtoms(input)) {
            if ("moov".equals(atom.getHeader().getFourcc())) {
                moov = (MovieBox)atom.parseBox(input);
                continue;
            }
            if (!"moof".equalsIgnoreCase(atom.getHeader().getFourcc())) continue;
            fragments.add((MovieFragmentBox)atom.parseBox(input));
        }
        for (MovieFragmentBox fragment : fragments) {
            fragment.setMovie(moov);
        }
        return fragments;
    }

    public static List<Atom> getRootAtoms(SeekableByteChannel input) throws IOException {
        Header atom;
        input.position(0L);
        ArrayList<Atom> result = new ArrayList<Atom>();
        for (long off = 0L; off < input.size(); off += atom.getSize()) {
            input.position(off);
            atom = Header.read(NIOUtils.fetchFrom(input, 16));
            if (atom == null) break;
            result.add(new Atom(atom, off));
        }
        return result;
    }

    public static Atom atom(SeekableByteChannel input) throws IOException {
        long off = input.position();
        Header atom = Header.read(NIOUtils.fetchFrom(input, 16));
        return atom == null ? null : new Atom(atom, off);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MovieBox parseMovie(File source) throws IOException {
        FileChannelWrapper input = null;
        try {
            input = NIOUtils.readableFileChannel(source);
            MovieBox movieBox = MP4Util.parseMovie(input);
            return movieBox;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MovieBox createRefMovie(File source) throws IOException {
        FileChannelWrapper input = null;
        try {
            input = NIOUtils.readableFileChannel(source);
            MovieBox movieBox = MP4Util.createRefMovie(input, "file://" + source.getCanonicalPath());
            return movieBox;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMovie(File f, MovieBox movie) throws IOException {
        AbstractInterruptibleChannel out = null;
        try {
            out = new FileInputStream(f).getChannel();
            MP4Util.writeMovie(f, movie);
        }
        finally {
            out.close();
        }
    }

    public static void writeMovie(SeekableByteChannel out, MovieBox movie) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(0x1000000);
        movie.write(buf);
        buf.flip();
        out.write(buf);
    }

    public static Box cloneBox(Box box, int approxSize) {
        return MP4Util.cloneBox(box, approxSize, BoxFactory.getDefault());
    }

    public static Box cloneBox(Box box, int approxSize, BoxFactory bf) {
        ByteBuffer buf = ByteBuffer.allocate(approxSize);
        box.write(buf);
        buf.flip();
        return NodeBox.parseChildBox(buf, bf);
    }

    public static String getFourcc(Codec codec) {
        return codecMapping.get((Object)codec);
    }

    public static ByteBuffer writeBox(Box box, int approxSize) {
        ByteBuffer buf = ByteBuffer.allocate(approxSize);
        box.write(buf);
        buf.flip();
        return buf;
    }

    static {
        codecMapping.put(Codec.MPEG2, "m2v1");
        codecMapping.put(Codec.H264, "avc1");
        codecMapping.put(Codec.J2K, "mjp2");
    }

    public static class Atom {
        private long offset;
        private Header header;

        public Atom(Header header, long offset) {
            this.header = header;
            this.offset = offset;
        }

        public long getOffset() {
            return this.offset;
        }

        public Header getHeader() {
            return this.header;
        }

        public Box parseBox(SeekableByteChannel input) throws IOException {
            input.position(this.offset + this.header.headerSize());
            return NodeBox.parseBox(NIOUtils.fetchFrom(input, (int)this.header.getSize()), this.header, BoxFactory.getDefault());
        }

        public void copy(SeekableByteChannel input, WritableByteChannel out) throws IOException {
            input.position(this.offset);
            NIOUtils.copy(input, out, this.header.getSize());
        }
    }
}

