/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4;

import java.io.IOException;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.Chunk;
import org.jcodec.containers.mp4.boxes.AliasBox;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import org.jcodec.containers.mp4.boxes.ChunkOffsetsBox;
import org.jcodec.containers.mp4.boxes.DataInfoBox;
import org.jcodec.containers.mp4.boxes.DataRefBox;
import org.jcodec.containers.mp4.boxes.MediaInfoBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.TrakBox;

public class ChunkWriter {
    private long[] offsets;
    private SampleEntry[] entries;
    private SeekableByteChannel[] inputs;
    private int curChunk;
    private SeekableByteChannel out;
    byte[] buf = new byte[8092];
    private TrakBox trak;

    public ChunkWriter(TrakBox trak, SeekableByteChannel[] inputs, SeekableByteChannel out) {
        this.entries = NodeBox.findAll((Box)trak, SampleEntry.class, "mdia", "minf", "stbl", "stsd", null);
        ChunkOffsetsBox stco = NodeBox.findFirst((NodeBox)trak, ChunkOffsetsBox.class, "mdia", "minf", "stbl", "stco");
        ChunkOffsets64Box co64 = NodeBox.findFirst((NodeBox)trak, ChunkOffsets64Box.class, "mdia", "minf", "stbl", "co64");
        int size = stco != null ? stco.getChunkOffsets().length : co64.getChunkOffsets().length;
        this.inputs = inputs;
        this.offsets = new long[size];
        this.out = out;
        this.trak = trak;
    }

    public void apply() {
        NodeBox stbl = NodeBox.findFirst((NodeBox)this.trak, NodeBox.class, "mdia", "minf", "stbl");
        stbl.removeChildren("stco", "co64");
        stbl.add(new ChunkOffsets64Box(this.offsets));
        this.cleanDrefs(this.trak);
    }

    private void cleanDrefs(TrakBox trak) {
        DataRefBox dref;
        MediaInfoBox minf = trak.getMdia().getMinf();
        DataInfoBox dinf = trak.getMdia().getMinf().getDinf();
        if (dinf == null) {
            dinf = new DataInfoBox();
            minf.add(dinf);
        }
        if ((dref = dinf.getDref()) == null) {
            dref = new DataRefBox();
            dinf.add(dref);
        }
        dref.getBoxes().clear();
        dref.add(AliasBox.createSelfRef());
        for (SampleEntry entry : NodeBox.findAll((Box)trak, SampleEntry.class, "mdia", "minf", "stbl", "stsd", null)) {
            entry.setDrefInd((short)1);
        }
    }

    private SeekableByteChannel getInput(Chunk chunk) {
        SampleEntry se = this.entries[chunk.getEntry() - 1];
        return this.inputs[se.getDrefInd() - 1];
    }

    public void write(Chunk chunk) throws IOException {
        SeekableByteChannel input = this.getInput(chunk);
        input.position(chunk.getOffset());
        long pos = this.out.position();
        this.out.write(NIOUtils.fetchFrom(input, (int)chunk.getSize()));
        this.offsets[this.curChunk++] = pos;
    }
}

