/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.model;

import org.jcodec.common.StringUtils;
import org.jcodec.common.model.Rational;
import org.jcodec.common.tools.MathUtil;

public class RationalLarge {
    public static final Rational ONE = new Rational(1, 1);
    public static final Rational HALF = new Rational(1, 2);
    public static final RationalLarge ZERO = new RationalLarge(0L, 1L);
    final long num;
    final long den;

    public RationalLarge(long num, long den) {
        this.num = num;
        this.den = den;
    }

    public long getNum() {
        return this.num;
    }

    public long getDen() {
        return this.den;
    }

    public static Rational parse(String string) {
        String[] split = StringUtils.split(string, ":");
        return new Rational(Integer.parseInt(split[0]), Integer.parseInt(split[1]));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.den ^ this.den >>> 32);
        result = 31 * result + (int)(this.num ^ this.num >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RationalLarge other = (RationalLarge)obj;
        if (this.den != other.den) {
            return false;
        }
        return this.num == other.num;
    }

    public long multiplyS(long scalar) {
        return this.num * scalar / this.den;
    }

    public long divideS(long scalar) {
        return this.den * scalar / this.num;
    }

    public long divideByS(long scalar) {
        return this.num / (this.den * scalar);
    }

    public RationalLarge flip() {
        return new RationalLarge(this.den, this.num);
    }

    public static RationalLarge R(long num, long den) {
        return new RationalLarge(num, den);
    }

    public static RationalLarge R(long num) {
        return RationalLarge.R(num, 1L);
    }

    public boolean lessThen(RationalLarge sec) {
        return this.num * sec.den < sec.num * this.den;
    }

    public boolean greaterThen(RationalLarge sec) {
        return this.num * sec.den > sec.num * this.den;
    }

    public boolean smallerOrEqualTo(RationalLarge sec) {
        return this.num * sec.den <= sec.num * this.den;
    }

    public boolean greaterOrEqualTo(RationalLarge sec) {
        return this.num * sec.den >= sec.num * this.den;
    }

    public boolean equals(RationalLarge other) {
        return this.num * other.den == other.num * this.den;
    }

    public RationalLarge plus(RationalLarge other) {
        return MathUtil.reduce(this.num * other.den + other.num * this.den, this.den * other.den);
    }

    public RationalLarge plus(Rational other) {
        return MathUtil.reduce(this.num * (long)other.den + (long)other.num * this.den, this.den * (long)other.den);
    }

    public RationalLarge minus(RationalLarge other) {
        return MathUtil.reduce(this.num * other.den - other.num * this.den, this.den * other.den);
    }

    public RationalLarge minus(Rational other) {
        return MathUtil.reduce(this.num * (long)other.den - (long)other.num * this.den, this.den * (long)other.den);
    }

    public RationalLarge plus(long scalar) {
        return new RationalLarge(this.num + scalar * this.den, this.den);
    }

    public RationalLarge minus(long scalar) {
        return new RationalLarge(this.num - scalar * this.den, this.den);
    }

    public RationalLarge multiply(long scalar) {
        return new RationalLarge(this.num * scalar, this.den);
    }

    public RationalLarge divide(long scalar) {
        return new RationalLarge(this.den * scalar, this.num);
    }

    public RationalLarge divideBy(long scalar) {
        return new RationalLarge(this.num, this.den * scalar);
    }

    public RationalLarge multiply(RationalLarge other) {
        return MathUtil.reduce(this.num * other.num, this.den * other.den);
    }

    public RationalLarge multiply(Rational other) {
        return MathUtil.reduce(this.num * (long)other.num, this.den * (long)other.den);
    }

    public RationalLarge divide(RationalLarge other) {
        return MathUtil.reduce(other.num * this.den, other.den * this.num);
    }

    public RationalLarge divide(Rational other) {
        return MathUtil.reduce((long)other.num * this.den, (long)other.den * this.num);
    }

    public RationalLarge divideBy(RationalLarge other) {
        return MathUtil.reduce(this.num * other.den, this.den * other.num);
    }

    public RationalLarge divideBy(Rational other) {
        return MathUtil.reduce(this.num * (long)other.den, this.den * (long)other.num);
    }

    public double scalar() {
        return (double)this.num / (double)this.den;
    }

    public long scalarClip() {
        return this.num / this.den;
    }
}

