/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common;

import java.lang.reflect.Array;

public class ArrayUtil {
    public static <T> void shiftRight(T[] array) {
        for (int i = 1; i < array.length; ++i) {
            array[i] = array[i - 1];
        }
        array[0] = null;
    }

    public static <T> void shiftLeft(T[] array) {
        for (int i = 0; i < array.length - 1; ++i) {
            array[i] = array[i + 1];
        }
        array[array.length - 1] = null;
    }

    public static <T> void shiftRight(T[] array, int from, int to) {
        for (int i = to - 1; i > from; --i) {
            array[i] = array[i - 1];
        }
        array[from] = null;
    }

    public static <T> void shiftLeft(T[] array, int from, int to) {
        for (int i = from; i < to - 1; ++i) {
            array[i] = array[i + 1];
        }
        array[to - 1] = null;
    }

    public static <T> void shiftLeft(T[] array, int from) {
        ArrayUtil.shiftLeft(array, from, array.length);
    }

    public static <T> void shiftRight(T[] array, int to) {
        ArrayUtil.shiftRight(array, 0, to);
    }

    public static final void swap(int[] arr, int ind1, int ind2) {
        int tmp = arr[ind1];
        arr[ind1] = arr[ind2];
        arr[ind2] = tmp;
    }

    public static final int sum(int[] array) {
        int result = 0;
        for (int i = 0; i < array.length; ++i) {
            result += array[i];
        }
        return result;
    }

    public static int sum(int[] array, int from, int count) {
        int result = 0;
        for (int i = from; i < from + count; ++i) {
            result += array[i];
        }
        return result;
    }

    public static void add(int[] array, int val) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + val;
        }
    }

    public static int[] addAll(int[] array1, int[] array2) {
        if (array1 == null) {
            return ArrayUtil.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtil.clone(array1);
        }
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static long[] addAll(long[] array1, long[] array2) {
        if (array1 == null) {
            return ArrayUtil.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtil.clone(array1);
        }
        long[] joinedArray = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static Object[] addAll(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return ArrayUtil.clone(array2);
        }
        if (array2 == null) {
            return ArrayUtil.clone(array1);
        }
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static int[] clone(int[] array) {
        if (array == null) {
            return null;
        }
        return (int[])array.clone();
    }

    public static long[] clone(long[] array) {
        if (array == null) {
            return null;
        }
        return (long[])array.clone();
    }

    public static Object[] clone(Object[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static byte[] toByteArray(int[] val) {
        byte[] result = new byte[val.length];
        for (int i = 0; i < val.length; ++i) {
            result[i] = (byte)val[i];
        }
        return result;
    }

    public static int[] toUnsignedIntArray(byte[] val) {
        int[] result = new int[val.length];
        for (int i = 0; i < val.length; ++i) {
            result[i] = val[i] & 0xFF;
        }
        return result;
    }

    public static <T> void reverse(T[] frames) {
        int i = 0;
        int j = frames.length - 1;
        while (i < frames.length >> 1) {
            T tmp = frames[i];
            frames[i] = frames[j];
            frames[j] = tmp;
            ++i;
            --j;
        }
    }
}

