/*
 * Decompiled with CFR 0.152.
 */
package arduino;

import arduino.ErrorRecord;
import arduino.PortListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingDeque;
import jssc.SerialPort;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Reporter;
import org.nlogo.core.Primitive;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public class ArduinoExtension
extends DefaultClassManager {
    static SerialPort serialPort;
    static PortListener portListener;
    static int BAUD_RATE;
    static int KEPT_MESSAGES_COUNT;
    public Map<String, Object> values = Collections.synchronizedMap(new HashMap());
    public Deque<ErrorRecord> inboundErrors = new LinkedBlockingDeque<ErrorRecord>();
    public LinkedList<String> outboundMessages = new LinkedList();

    public ArduinoExtension() {
        this.values.put("BaudRate", BAUD_RATE);
    }

    public void load(PrimitiveManager pm) throws ExtensionException {
        pm.addPrimitive("primitives", (Primitive)new Primitives());
        pm.addPrimitive("ports", (Primitive)new Ports());
        pm.addPrimitive("open", (Primitive)new Open(this.values, this.inboundErrors));
        pm.addPrimitive("close", (Primitive)new Close());
        pm.addPrimitive("get", (Primitive)new Get(this.values));
        pm.addPrimitive("write-string", (Primitive)new WriteString(this.outboundMessages));
        pm.addPrimitive("write-int", (Primitive)new WriteInt(this.outboundMessages));
        pm.addPrimitive("write-byte", (Primitive)new WriteByte(this.outboundMessages));
        pm.addPrimitive("is-open?", (Primitive)new IsOpen());
        pm.addPrimitive("debug-to-arduino", (Primitive)new DebugToArduino(this.outboundMessages));
        pm.addPrimitive("debug-from-arduino", (Primitive)new DebugFromArduino(this.inboundErrors));
    }

    static void addMessage(LinkedList<String> messages, String messageType, String messageValue) {
        while (messages.size() >= 5) {
            messages.removeLast();
        }
        messages.addFirst(messageType + ":" + messageValue);
    }

    public static void doClose() throws ExtensionException {
        try {
            serialPort.removeEventListener();
            serialPort.closePort();
        }
        catch (SerialPortException e) {
            throw new ExtensionException("Error in writing: " + e.getMessage());
        }
    }

    public void unload(ExtensionManager em) {
        if (portListener != null && serialPort != null) {
            try {
                serialPort.removeEventListener();
            }
            catch (SerialPortException e) {
                e.printStackTrace();
            }
            try {
                serialPort.closePort();
            }
            catch (SerialPortException e2) {
                e2.printStackTrace();
            }
        } else if (serialPort != null && serialPort.isOpened()) {
            try {
                serialPort.closePort();
            }
            catch (SerialPortException e) {
                e.printStackTrace();
            }
        }
        try {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Field field = ClassLoader.class.getDeclaredField("nativeLibraries");
            field.setAccessible(true);
            Vector libs = (Vector)field.get(classLoader);
            for (Object o : libs) {
                Method finalize = o.getClass().getDeclaredMethod("finalize", new Class[0]);
                finalize.setAccessible(true);
                finalize.invoke(o, new Object[0]);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    static {
        BAUD_RATE = 9600;
        KEPT_MESSAGES_COUNT = 5;
    }

    public static class DebugToArduino
    implements Reporter {
        private final LinkedList<String> outboundMessages;

        public DebugToArduino(LinkedList<String> outboundMessages) {
            this.outboundMessages = outboundMessages;
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            LogoListBuilder llist = new LogoListBuilder();
            Iterator iter = this.outboundMessages.iterator();
            while (iter.hasNext()) {
                llist.add(iter.next());
            }
            return llist.toLogoList();
        }
    }

    public static class DebugFromArduino
    implements Reporter {
        private final Deque<ErrorRecord> inboundErrors;

        public DebugFromArduino(Deque<ErrorRecord> inboundErrors) {
            this.inboundErrors = inboundErrors;
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            LogoListBuilder llist = new LogoListBuilder();
            Iterator<ErrorRecord> iter = this.inboundErrors.iterator();
            while (iter.hasNext()) {
                LogoListBuilder itemBuilder = new LogoListBuilder();
                ErrorRecord record = iter.next();
                itemBuilder.add((Object)record.inboundString());
                itemBuilder.add((Object)record.errorDescription());
                if (record.exception().nonEmpty()) {
                    itemBuilder.add((Object)((Exception)record.exception().get()).getMessage());
                }
                llist.add((Object)itemBuilder.toLogoList());
            }
            return llist.toLogoList();
        }
    }

    public static class WriteByte
    implements Command {
        private final LinkedList<String> outboundMessages;

        public WriteByte(LinkedList<String> outboundMessages) {
            this.outboundMessages = outboundMessages;
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context ctxt) throws ExtensionException, LogoException {
            if (serialPort == null || !serialPort.isOpened()) {
                throw new ExtensionException("Serial Port not Open");
            }
            try {
                byte arg = (byte)args[0].getIntValue();
                serialPort.writeByte(arg);
                ArduinoExtension.addMessage(this.outboundMessages, "b", Integer.toString(arg));
            }
            catch (SerialPortException e) {
                throw new ExtensionException("Error in writing: " + e.getMessage());
            }
        }
    }

    public static class WriteInt
    implements Command {
        private final LinkedList<String> outboundMessages;

        public WriteInt(LinkedList<String> outboundMessages) {
            this.outboundMessages = outboundMessages;
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.NumberType()});
        }

        public void perform(Argument[] args, Context ctxt) throws ExtensionException, LogoException {
            if (serialPort == null || !serialPort.isOpened()) {
                throw new ExtensionException("Serial Port not Open");
            }
            try {
                int arg = args[0].getIntValue();
                serialPort.writeInt(arg);
                ArduinoExtension.addMessage(this.outboundMessages, "i", Integer.toString(arg));
            }
            catch (SerialPortException e) {
                throw new ExtensionException("Error in writing: " + e.getMessage());
            }
        }
    }

    public static class WriteString
    implements Command {
        private final LinkedList<String> outboundMessages;

        public WriteString(LinkedList<String> outboundMessages) {
            this.outboundMessages = outboundMessages;
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType()});
        }

        public void perform(Argument[] args, Context ctxt) throws ExtensionException, LogoException {
            if (serialPort == null || !serialPort.isOpened()) {
                throw new ExtensionException("Serial Port not Open");
            }
            try {
                String arg = args[0].getString();
                serialPort.writeString(arg);
                ArduinoExtension.addMessage(this.outboundMessages, "s", arg);
            }
            catch (SerialPortException e) {
                throw new ExtensionException("Error in writing: " + e.getMessage());
            }
        }
    }

    public static class Get
    implements Reporter {
        private Map<String, Object> values;

        public Get(Map<String, Object> values) {
            this.values = values;
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)(Syntax.StringType() | Syntax.BooleanType() | Syntax.NumberType()));
        }

        public Object report(Argument[] args, Context ctxt) throws ExtensionException, LogoException {
            return this.get(args[0].getString());
        }

        public Object get(String key) {
            String lcKey = key.toLowerCase();
            if (this.values.containsKey(lcKey)) {
                return this.values.get(lcKey);
            }
            return Boolean.FALSE;
        }
    }

    public static class Close
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] args, Context ctxt) throws ExtensionException, LogoException {
            if (serialPort == null || !serialPort.isOpened()) {
                throw new ExtensionException("Serial Port not Open");
            }
            ArduinoExtension.doClose();
        }
    }

    public static class IsOpen
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.BooleanType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            return serialPort != null && serialPort.isOpened() && portListener != null;
        }
    }

    public static class Open
    implements Command {
        private Map<String, Object> values;
        private Deque<ErrorRecord> inboundErrors;

        public Open(Map<String, Object> values, Deque<ErrorRecord> inboundErrors) {
            this.values = values;
            this.inboundErrors = inboundErrors;
        }

        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.StringType()});
        }

        public void perform(Argument[] args, Context ctxt) throws ExtensionException, LogoException {
            if (serialPort != null && serialPort.isOpened()) {
                throw new ExtensionException("Port is already open");
            }
            try {
                serialPort = new SerialPort(args[0].getString());
                serialPort.openPort();
                serialPort.setParams(BAUD_RATE, 8, 1, 0);
                int mask = 25;
                serialPort.setEventsMask(mask);
                portListener = new PortListener(serialPort, this.values, this.inboundErrors);
                serialPort.addEventListener((SerialPortEventListener)portListener);
            }
            catch (SerialPortException e) {
                throw new ExtensionException("Error in opening port: " + e.getMessage());
            }
        }
    }

    public static class Ports
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            String[] names;
            LogoListBuilder llist = new LogoListBuilder();
            for (String name : names = SerialPortList.getPortNames()) {
                llist.add((Object)name);
            }
            return llist.toLogoList();
        }
    }

    public static class Primitives
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] arg0, Context arg1) throws ExtensionException, LogoException {
            String[] prims;
            LogoListBuilder llist = new LogoListBuilder();
            for (String prim : prims = new String[]{"reporter:primitives", "reporter:ports", "reporter:get[Name:String(case-insensitive)]", "reporter:is-open?", "reporter:debug-to-arduino", "reporter:debug-from-arduino", "", "command:open[Port:String]", "command:close", "command:write-string[Message:String]", "command:write-int[Message:int]", "command:write-byte[Message:byte]", "", "ALSO NOTE: Baud Rate of 9600 is expected"}) {
                llist.add((Object)prim);
            }
            return llist.toLogoList();
        }
    }
}

