/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamExceptionHandler;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebcamPanel
extends JPanel
implements WebcamListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(WebcamPanel.class);
    public static final double MIN_FREQUENCY = 0.016;
    private static final double MAX_FREQUENCY = 50.0;
    private static final ThreadFactory THREAD_FACTORY = new PanelThreadFactory();
    public static final Map<RenderingHints.Key, Object> DEFAULT_IMAGE_RENDERING_HINTS = new HashMap<RenderingHints.Key, Object>();
    private final Runnable repaint = new SwingRepainter(this);
    private Map<RenderingHints.Key, Object> imageRenderingHints = new HashMap<RenderingHints.Key, Object>(DEFAULT_IMAGE_RENDERING_HINTS);
    private ScheduledExecutorService executor = null;
    private ResourceBundle rb = null;
    private DrawMode drawMode = DrawMode.FIT;
    private double frequency = 5.0;
    private boolean frequencyLimit = false;
    private boolean frequencyDisplayed = false;
    private boolean imageSizeDisplayed = false;
    private boolean antialiasingEnabled = true;
    private final Webcam webcam;
    private final ImageSupplier supplier;
    private final ImageUpdater updater;
    private BufferedImage image = null;
    private volatile boolean starting = false;
    private volatile boolean paused = false;
    private volatile boolean errored = false;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Painter defaultPainter;
    private Painter painter = this.defaultPainter = new DefaultPainter();
    private Dimension defaultSize = null;
    private boolean displayDebugInfo = false;
    private boolean mirrored = false;

    public WebcamPanel(Webcam webcam) {
        this(webcam, true);
    }

    public WebcamPanel(Webcam webcam, boolean start) {
        this(webcam, null, start);
    }

    public WebcamPanel(Webcam webcam, Dimension size, boolean start) {
        this(webcam, size, start, new DefaultImageSupplier(webcam));
    }

    public WebcamPanel(Webcam webcam, Dimension size, boolean start, ImageSupplier supplier) {
        if (webcam == null) {
            throw new IllegalArgumentException(String.format("Webcam argument in %s constructor cannot be null!", this.getClass().getSimpleName()));
        }
        this.defaultSize = size;
        this.webcam = webcam;
        this.updater = new ImageUpdater();
        this.supplier = supplier;
        this.rb = WebcamUtils.loadRB(WebcamPanel.class, this.getLocale());
        this.setDoubleBuffered(true);
        this.addPropertyChangeListener("locale", this);
        if (size == null) {
            Dimension r = webcam.getViewSize();
            if (r == null) {
                r = webcam.getViewSizes()[0];
            }
            this.setPreferredSize(r);
        } else {
            this.setPreferredSize(size);
        }
        if (start) {
            this.start();
        }
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
    }

    public Painter getPainter() {
        return this.painter;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image == null) {
            this.painter.paintPanel(this, (Graphics2D)g);
        } else {
            this.painter.paintImage(this, this.image, (Graphics2D)g);
        }
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.webcam.addWebcamListener(this);
        LOG.debug("Starting panel rendering and trying to open attached webcam");
        this.updater.start();
        this.starting = true;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    if (!WebcamPanel.this.webcam.isOpen()) {
                        WebcamPanel.this.errored = !WebcamPanel.this.webcam.open();
                    }
                }
                catch (WebcamException e) {
                    WebcamPanel.this.errored = true;
                    throw e;
                }
                finally {
                    WebcamPanel.this.starting = false;
                    WebcamPanel.this.repaintPanel();
                }
                return null;
            }
        };
        worker.execute();
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.webcam.removeWebcamListener(this);
        LOG.debug("Stopping panel rendering and closing attached webcam");
        try {
            this.updater.stop();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.image = null;
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    if (WebcamPanel.this.webcam.isOpen()) {
                        WebcamPanel.this.errored = !WebcamPanel.this.webcam.close();
                    }
                }
                catch (WebcamException e) {
                    WebcamPanel.this.errored = true;
                    throw e;
                }
                finally {
                    WebcamPanel.this.repaintPanel();
                }
                return null;
            }
        };
        worker.execute();
    }

    private void repaintPanel() {
        SwingUtilities.invokeLater(this.repaint);
    }

    public void pause() {
        if (this.paused) {
            return;
        }
        LOG.debug("Pausing panel rendering");
        this.paused = true;
    }

    public void resume() {
        if (!this.paused) {
            return;
        }
        LOG.debug("Resuming panel rendering");
        this.paused = false;
    }

    public boolean isFPSLimited() {
        return this.frequencyLimit;
    }

    public void setFPSLimited(boolean frequencyLimit) {
        this.frequencyLimit = frequencyLimit;
    }

    public double getFPSLimit() {
        return this.frequency;
    }

    public void setFPSLimit(double fps) {
        if (fps > 50.0) {
            fps = 50.0;
        }
        if (fps < 0.016) {
            fps = 0.016;
        }
        this.frequency = fps;
    }

    public boolean isDisplayDebugInfo() {
        return this.displayDebugInfo;
    }

    public void setDisplayDebugInfo(boolean displayDebugInfo) {
        this.displayDebugInfo = displayDebugInfo;
    }

    public boolean isFPSDisplayed() {
        return this.frequencyDisplayed;
    }

    public void setFPSDisplayed(boolean displayed) {
        this.frequencyDisplayed = displayed;
    }

    public boolean isImageSizeDisplayed() {
        return this.imageSizeDisplayed;
    }

    public void setImageSizeDisplayed(boolean imageSizeDisplayed) {
        this.imageSizeDisplayed = imageSizeDisplayed;
    }

    public void setAntialiasingEnabled(boolean antialiasing) {
        this.antialiasingEnabled = antialiasing;
    }

    public boolean isAntialiasingEnabled() {
        return this.antialiasingEnabled;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public DrawMode getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(DrawMode drawMode) {
        this.drawMode = drawMode;
    }

    public boolean isErrored() {
        return this.errored;
    }

    @Deprecated
    public Map<RenderingHints.Key, Object> getImageRenderingHints() {
        return this.imageRenderingHints;
    }

    @Deprecated
    public boolean isFitArea() {
        return this.drawMode == DrawMode.FIT;
    }

    @Deprecated
    public void setFitArea(boolean fitArea) {
        this.drawMode = fitArea ? DrawMode.FIT : DrawMode.NONE;
    }

    @Deprecated
    public void setFillArea(boolean fillArea) {
        this.drawMode = fillArea ? DrawMode.FILL : DrawMode.NONE;
    }

    @Deprecated
    public boolean isFillArea() {
        return this.drawMode == DrawMode.FILL;
    }

    public Painter getDefaultPainter() {
        return this.defaultPainter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Locale lc = (Locale)evt.getNewValue();
        if (lc != null) {
            this.rb = WebcamUtils.loadRB(WebcamPanel.class, lc);
        }
    }

    @Override
    public void webcamOpen(WebcamEvent we) {
        if (this.defaultSize == null) {
            this.setPreferredSize(this.webcam.getViewSize());
        }
    }

    @Override
    public void webcamClosed(WebcamEvent we) {
        this.stop();
    }

    @Override
    public void webcamDisposed(WebcamEvent we) {
        this.stop();
    }

    @Override
    public void webcamImageObtained(WebcamEvent we) {
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public void setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
    }

    public Webcam getWebcam() {
        return this.webcam;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    static {
        DEFAULT_IMAGE_RENDERING_HINTS.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        DEFAULT_IMAGE_RENDERING_HINTS.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        DEFAULT_IMAGE_RENDERING_HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private class ImageUpdater
    implements Runnable {
        private Thread scheduler = null;
        private AtomicBoolean running = new AtomicBoolean(false);

        private ImageUpdater() {
        }

        public void start() {
            if (this.running.compareAndSet(false, true)) {
                WebcamPanel.this.executor = Executors.newScheduledThreadPool(1, THREAD_FACTORY);
                this.scheduler = new RepaintScheduler();
                this.scheduler.start();
            }
        }

        public void stop() throws InterruptedException {
            if (this.running.compareAndSet(true, false)) {
                WebcamPanel.this.executor.shutdown();
                WebcamPanel.this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                this.scheduler.join();
            }
        }

        @Override
        public void run() {
            try {
                this.update();
            }
            catch (Throwable t) {
                WebcamPanel.this.errored = true;
                WebcamExceptionHandler.handle(t);
            }
        }

        private void update() {
            if (!this.running.get() || !WebcamPanel.this.webcam.isOpen() || WebcamPanel.this.paused) {
                return;
            }
            BufferedImage tmp = WebcamPanel.this.supplier.get();
            boolean repaint = true;
            if (tmp != null) {
                if (WebcamPanel.this.image == tmp) {
                    repaint = false;
                }
                WebcamPanel.this.errored = false;
                WebcamPanel.this.image = tmp;
            }
            if (repaint) {
                WebcamPanel.this.repaintPanel();
            }
        }

        private class RepaintScheduler
        extends Thread {
            public RepaintScheduler() {
                this.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
                this.setName(String.format("repaint-scheduler-%s", WebcamPanel.this.webcam.getName()));
                this.setDaemon(true);
            }

            @Override
            public void run() {
                if (!ImageUpdater.this.running.get()) {
                    return;
                }
                WebcamPanel.this.repaintPanel();
                while (WebcamPanel.this.starting) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    if (WebcamPanel.this.webcam.isOpen()) {
                        if (WebcamPanel.this.isFPSLimited()) {
                            WebcamPanel.this.executor.scheduleAtFixedRate(WebcamPanel.this.updater, 0L, (long)(1000.0 / WebcamPanel.this.frequency), TimeUnit.MILLISECONDS);
                        } else {
                            WebcamPanel.this.executor.scheduleWithFixedDelay(WebcamPanel.this.updater, 100L, 1L, TimeUnit.MILLISECONDS);
                        }
                    } else {
                        WebcamPanel.this.executor.schedule(this, 500L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (RejectedExecutionException e) {
                    LOG.warn("Executor rejected paint update");
                    LOG.trace("Executor rejected paint update because of", (Throwable)e);
                }
            }
        }
    }

    private static final class SwingRepainter
    implements Runnable {
        private WebcamPanel panel = null;

        public SwingRepainter(WebcamPanel panel) {
            this.panel = panel;
        }

        @Override
        public void run() {
            this.panel.repaint();
        }
    }

    private static final class PanelThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger number = new AtomicInteger(0);

        private PanelThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, String.format("webcam-panel-scheduled-executor-%d", number.incrementAndGet()));
            t.setUncaughtExceptionHandler(WebcamExceptionHandler.getInstance());
            t.setDaemon(true);
            return t;
        }
    }

    public class DefaultPainter
    implements Painter {
        private String name = null;
        private long lastRepaintTime = -1L;
        private BufferedImage resizedImage = null;

        @Override
        public void paintPanel(WebcamPanel owner, Graphics2D g2) {
            assert (owner != null);
            assert (g2 != null);
            Object antialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, WebcamPanel.this.isAntialiasingEnabled() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setBackground(Color.BLACK);
            g2.fillRect(0, 0, WebcamPanel.this.getWidth(), WebcamPanel.this.getHeight());
            int cx = (WebcamPanel.this.getWidth() - 70) / 2;
            int cy = (WebcamPanel.this.getHeight() - 40) / 2;
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillRoundRect(cx, cy, 70, 40, 10, 10);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 5, cy + 5, 30, 30);
            g2.setColor(Color.LIGHT_GRAY);
            g2.fillOval(cx + 10, cy + 10, 20, 20);
            g2.setColor(Color.WHITE);
            g2.fillOval(cx + 12, cy + 12, 16, 16);
            g2.fillRoundRect(cx + 50, cy + 5, 15, 10, 5, 5);
            g2.fillRect(cx + 63, cy + 25, 7, 2);
            g2.fillRect(cx + 63, cy + 28, 7, 2);
            g2.fillRect(cx + 63, cy + 31, 7, 2);
            g2.setColor(Color.DARK_GRAY);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(0, 0, WebcamPanel.this.getWidth(), WebcamPanel.this.getHeight());
            g2.drawLine(0, WebcamPanel.this.getHeight(), WebcamPanel.this.getWidth(), 0);
            String strInitDevice = WebcamPanel.this.rb.getString("INITIALIZING_DEVICE");
            String strNoImage = WebcamPanel.this.rb.getString("NO_IMAGE");
            String strDeviceError = WebcamPanel.this.rb.getString("DEVICE_ERROR");
            String str = WebcamPanel.this.errored ? strDeviceError : (WebcamPanel.this.starting ? strInitDevice : strNoImage);
            FontMetrics metrics = g2.getFontMetrics(WebcamPanel.this.getFont());
            int w = metrics.stringWidth(str);
            int h = metrics.getHeight();
            int x = (WebcamPanel.this.getWidth() - w) / 2;
            int y = cy - h;
            g2.setFont(WebcamPanel.this.getFont());
            g2.setColor(Color.WHITE);
            g2.drawString(str, x, y);
            if (this.name == null) {
                this.name = WebcamPanel.this.webcam.getName();
            }
            str = this.name;
            w = metrics.stringWidth(str);
            h = metrics.getHeight();
            g2.drawString(str, (WebcamPanel.this.getWidth() - w) / 2, cy - 2 * h);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintImage(WebcamPanel owner, BufferedImage image, Graphics2D g2) {
            assert (owner != null);
            assert (image != null);
            assert (g2 != null);
            int pw = WebcamPanel.this.getWidth();
            int ph = WebcamPanel.this.getHeight();
            int iw = image.getWidth();
            int ih = image.getHeight();
            Object antialiasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            Object rendering = g2.getRenderingHint(RenderingHints.KEY_RENDERING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setBackground(Color.BLACK);
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, pw, ph);
            int x = 0;
            int y = 0;
            int w = 0;
            int h = 0;
            switch (WebcamPanel.this.drawMode) {
                case NONE: {
                    w = image.getWidth();
                    h = image.getHeight();
                    break;
                }
                case FILL: {
                    w = pw;
                    h = ph;
                    break;
                }
                case FIT: {
                    double s = Math.max((double)iw / (double)pw, (double)ih / (double)ph);
                    double niw = (double)iw / s;
                    double nih = (double)ih / s;
                    double dx = ((double)pw - niw) / 2.0;
                    double dy = ((double)ph - nih) / 2.0;
                    w = (int)niw;
                    h = (int)nih;
                    x = (int)dx;
                    y = (int)dy;
                }
            }
            if (this.resizedImage != null) {
                this.resizedImage.flush();
            }
            if (w == image.getWidth() && h == image.getHeight() && !WebcamPanel.this.mirrored) {
                this.resizedImage = image;
            } else {
                GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsConfiguration gc = genv.getDefaultScreenDevice().getDefaultConfiguration();
                Graphics gr = null;
                try {
                    int sy2;
                    int sx2;
                    int sy1;
                    int sx1;
                    this.resizedImage = gc.createCompatibleImage(pw, ph);
                    gr = this.resizedImage.createGraphics();
                    ((Graphics2D)gr).setComposite(AlphaComposite.Src);
                    for (Map.Entry hint : WebcamPanel.this.imageRenderingHints.entrySet()) {
                        ((Graphics2D)gr).setRenderingHint((RenderingHints.Key)hint.getKey(), hint.getValue());
                    }
                    ((Graphics2D)gr).setBackground(Color.BLACK);
                    gr.setColor(Color.BLACK);
                    gr.fillRect(0, 0, pw, ph);
                    int dx1 = x;
                    int dy1 = y;
                    int dx2 = x + w;
                    int dy2 = y + h;
                    if (WebcamPanel.this.mirrored) {
                        sx1 = iw;
                        sy1 = 0;
                        sx2 = 0;
                        sy2 = ih;
                    } else {
                        sx1 = 0;
                        sy1 = 0;
                        sx2 = iw;
                        sy2 = ih;
                    }
                    gr.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
                }
                finally {
                    if (gr != null) {
                        gr.dispose();
                    }
                }
            }
            g2.drawImage((Image)this.resizedImage, 0, 0, null);
            if (WebcamPanel.this.isFPSDisplayed()) {
                String str = String.format("FPS: %.1f", WebcamPanel.this.webcam.getFPS());
                int sx = 5;
                int sy = ph - 5;
                g2.setFont(WebcamPanel.this.getFont());
                g2.setColor(Color.BLACK);
                g2.drawString(str, sx + 1, sy + 1);
                g2.setColor(Color.WHITE);
                g2.drawString(str, sx, sy);
            }
            if (WebcamPanel.this.isImageSizeDisplayed()) {
                String res = String.format("%d\u2a2f%d px", iw, ih);
                FontMetrics metrics = g2.getFontMetrics(WebcamPanel.this.getFont());
                int sw = metrics.stringWidth(res);
                int sx = pw - sw - 5;
                int sy = ph - 5;
                g2.setFont(WebcamPanel.this.getFont());
                g2.setColor(Color.BLACK);
                g2.drawString(res, sx + 1, sy + 1);
                g2.setColor(Color.WHITE);
                g2.drawString(res, sx, sy);
            }
            if (WebcamPanel.this.isDisplayDebugInfo()) {
                if (this.lastRepaintTime < 0L) {
                    this.lastRepaintTime = System.currentTimeMillis();
                } else {
                    long now = System.currentTimeMillis();
                    String res = String.format("DEBUG: repaints per second: %.1f", 1000.0 / (double)(now - this.lastRepaintTime));
                    this.lastRepaintTime = now;
                    g2.setFont(WebcamPanel.this.getFont());
                    g2.setColor(Color.BLACK);
                    g2.drawString(res, 6, 16);
                    g2.setColor(Color.WHITE);
                    g2.drawString(res, 5, 15);
                }
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, rendering);
        }
    }

    public static interface Painter {
        public void paintPanel(WebcamPanel var1, Graphics2D var2);

        public void paintImage(WebcamPanel var1, BufferedImage var2, Graphics2D var3);
    }

    private static class DefaultImageSupplier
    implements ImageSupplier {
        private final Webcam webcam;

        public DefaultImageSupplier(Webcam webcam) {
            this.webcam = webcam;
        }

        @Override
        public BufferedImage get() {
            return this.webcam.getImage();
        }
    }

    public static interface ImageSupplier {
        public BufferedImage get();
    }

    public static enum DrawMode {
        NONE,
        FILL,
        FIT;

    }
}

