/*
 * Decompiled with CFR 0.152.
 */
package view25d.view.gl;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import java.awt.Color;
import java.util.HashMap;
import view25d.view.LinkValue;
import view25d.view.MouseableGLWindow;
import view25d.view.TurtleValue;
import view25d.view.TurtleView;
import view25d.view.gl.Compilables;

public class TurtleGL
extends MouseableGLWindow
implements GLEventListener {
    int patchTileListHandle;
    int stemSkyscraperHandle;
    int pinHeadListHandle;
    int axisHeadHandle;
    protected GLUquadric quadric;

    public TurtleGL(TurtleView parent) {
        super(parent);
    }

    private void setupCompiledDisplayLists(GL2 gl) {
        this.patchTileListHandle = gl.glGenLists(1);
        gl.glNewList(this.patchTileListHandle, 4864);
        Compilables.PatchTile(gl);
        gl.glEndList();
        this.quadric = this.glu.gluNewQuadric();
        this.glu.gluQuadricDrawStyle(this.quadric, 100012);
        this.glu.gluQuadricNormals(this.quadric, 100000);
        this.nlGLU.setQuadric(this.quadric);
        this.stemSkyscraperHandle = gl.glGenLists(1);
        gl.glNewList(this.stemSkyscraperHandle, 4864);
        int hexSlices = 6;
        Compilables.ThickStem(gl, this.glu, this.quadric, 1.0, 6);
        gl.glEndList();
        this.pinHeadListHandle = gl.glGenLists(1);
        float radius = 0.4f;
        int slices = 16;
        gl.glNewList(this.pinHeadListHandle, 4864);
        Compilables.PinHead(gl, this.glu, this.quadric, 0.4f, 16);
        gl.glEndList();
        this.compileShapes(gl, this.compiledShapes, false);
        this.axisHeadHandle = gl.glGenLists(1);
        gl.glNewList(this.axisHeadHandle, 4864);
        Compilables.AxisHead(gl, this.glu, this.quadric, 1.3, 16);
        gl.glEndList();
    }

    public void display(GLAutoDrawable drawable) {
        Color c;
        int j;
        int i;
        GL2 gl = (GL2)drawable.getGL();
        if (this.areShapesStale) {
            this.compileShapes(gl, this.compiledShapes, false);
            this.setDeletedShapesToDefaultShape(this.compiledShapes);
            this.areShapesStale = false;
        }
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glClear(16640);
        gl.glLineWidth(1.0f);
        gl.glPushMatrix();
        this.observer.applyPerspective(gl);
        if (((TurtleView)this.myViewer).viewOptions.usePColor()) {
            for (i = 0; i < this.myViewer.worldWidth; ++i) {
                for (j = 0; j < this.myViewer.worldHeight; ++j) {
                    gl.glPushMatrix();
                    gl.glTranslated((double)(i + this.myViewer.minPxcor), (double)(j + this.myViewer.minPycor), 0.0);
                    Color c2 = ((TurtleView)this.myViewer).patchColorMatrix[i][j];
                    float red = (float)c2.getRed() / 255.0f;
                    float green = (float)c2.getGreen() / 255.0f;
                    float blue = (float)c2.getBlue() / 255.0f;
                    this.setColorAndStandardMaterial(gl, red, green, blue);
                    gl.glCallList(this.patchTileListHandle);
                    gl.glPopMatrix();
                }
            }
        } else {
            this.setColorAndStandardMaterial(gl, 0.1f, 0.1f, 1.0f);
            for (i = 0; i < this.myViewer.worldWidth; ++i) {
                for (j = 0; j < this.myViewer.worldHeight; ++j) {
                    gl.glPushMatrix();
                    gl.glTranslated((double)(i + this.myViewer.minPxcor), (double)(j + this.myViewer.minPycor), 0.0);
                    gl.glCallList(this.patchTileListHandle);
                    gl.glPopMatrix();
                }
            }
        }
        double stemThickness = ((TurtleView)this.myViewer).viewOptions.getStemThickness();
        for (TurtleValue tv : ((TurtleView)this.myViewer).getCopyOfReporterValues()) {
            gl.glPushMatrix();
            double zval = this.myViewer.zScale * tv.reporterValue;
            gl.glTranslated(tv.xcor, tv.ycor, zval);
            double stemColor = tv.stemColor;
            c = org.nlogo.api.Color.getColor((Object)stemColor);
            float stemRed = (float)c.getRed() / 255.0f;
            float stemGreen = (float)c.getGreen() / 255.0f;
            float stemBlue = (float)c.getBlue() / 255.0f;
            this.setColorAndStandardMaterial(gl, stemRed, stemGreen, stemBlue);
            if (stemThickness == 0.0) {
                gl.glLineWidth(0.1f);
                gl.glBegin(1);
                gl.glVertex3i(0, 0, 0);
                gl.glVertex3d(0.0, 0.0, -zval);
                gl.glEnd();
            } else {
                gl.glPushMatrix();
                gl.glTranslated(0.0, 0.0, -zval);
                gl.glScaled(stemThickness, stemThickness, zval);
                gl.glCallList(this.stemSkyscraperHandle);
                gl.glPopMatrix();
            }
            float red = 0.8f;
            float green = 0.8f;
            float blue = 0.45f;
            if (((TurtleView)this.myViewer).viewOptions.showSize()) {
                gl.glScaled(tv.size, tv.size, tv.size);
            }
            if (((TurtleView)this.myViewer).viewOptions.showColor()) {
                red = (float)tv.color.getRed() / 255.0f;
                green = (float)tv.color.getGreen() / 255.0f;
                blue = (float)tv.color.getBlue() / 255.0f;
            }
            this.setColorAndStandardMaterial(gl, red, green, blue);
            if (((TurtleView)this.myViewer).viewOptions.showShape()) {
                this.observer.applyNormal(gl);
                if (stemThickness > 0.0) {
                    gl.glTranslated(0.0, 0.0, stemThickness / 2.0);
                }
                gl.glScaled(3.0, 3.0, 3.0);
                gl.glCallList(((Integer)this.compiledShapes.get(tv.shape)).intValue());
            } else {
                gl.glCallList(this.pinHeadListHandle);
            }
            gl.glPopMatrix();
        }
        for (LinkValue lv : ((TurtleView)this.myViewer).linkValues) {
            double zval1 = 0.0;
            double zval2 = 0.0;
            if (((TurtleView)this.myViewer).viewOptions.linksAreThreeD()) {
                zval1 = this.myViewer.zScale * lv.zcor1;
                zval2 = this.myViewer.zScale * lv.zcor2;
            }
            c = lv.color;
            float linkRed = (float)c.getRed() / 255.0f;
            float linkGreen = (float)c.getGreen() / 255.0f;
            float linkBlue = (float)c.getBlue() / 255.0f;
            this.setColorAndStandardMaterial(gl, linkRed, linkGreen, linkBlue);
            if (lv.thickness == 0.0) {
                lv.thickness = 0.1f;
            }
            gl.glLineWidth((float)lv.thickness);
            gl.glBegin(1);
            gl.glVertex3d(lv.xcor1, lv.ycor1, zval1);
            gl.glVertex3d(lv.xcor2, lv.ycor2, zval2);
            gl.glEnd();
        }
        this.drawAxesIfDragging(gl, this.axisHeadHandle);
        gl.glPopMatrix();
    }

    public void init(GLAutoDrawable drawable) {
        this.compiledShapes = new HashMap();
        GL2 gl = (GL2)drawable.getGL();
        this.glu = new GLU();
        this.setupCompiledDisplayLists(gl);
        this.setupLightingAndViewPort(gl, this.glu);
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }
}

