/*
 * Decompiled with CFR 0.152.
 */
package bsearch.representations;

import bsearch.representations.Chromosome;
import bsearch.representations.ChromosomeFactory;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.nlogo.api.MersenneTwisterFast;

public strictfp class MixedTypeChromosome
implements Chromosome {
    private Object[] paramVals;
    private SearchSpace searchSpace;

    private MixedTypeChromosome(SearchSpace searchSpace, MersenneTwisterFast rng) {
        this.searchSpace = searchSpace;
        List<ParameterSpec> paramSpecs = searchSpace.getParamSpecs();
        this.paramVals = new Object[paramSpecs.size()];
        int i = 0;
        for (ParameterSpec p : paramSpecs) {
            this.paramVals[i++] = p.generateRandomValue(rng);
        }
    }

    private MixedTypeChromosome(SearchSpace searchSpace, LinkedHashMap<String, Object> paramSettings) {
        this.searchSpace = searchSpace;
        List<ParameterSpec> paramSpecs = searchSpace.getParamSpecs();
        if (paramSpecs.size() != paramSettings.size()) {
            throw new IllegalStateException("# of parameter settings does not match search space parameter specifications.");
        }
        this.paramVals = new Object[paramSettings.size()];
        int i = 0;
        for (ParameterSpec p : paramSpecs) {
            this.paramVals[i++] = paramSettings.get(p.getParameterName());
        }
    }

    private MixedTypeChromosome(Object[] paramVals, SearchSpace searchSpace) {
        this.paramVals = (Object[])paramVals.clone();
        this.searchSpace = searchSpace;
    }

    @Override
    public LinkedHashMap<String, Object> getParamSettings() {
        LinkedHashMap<String, Object> paramSettings = new LinkedHashMap<String, Object>();
        int i = 0;
        for (ParameterSpec p : this.searchSpace.getParamSpecs()) {
            paramSettings.put(p.getParameterName(), this.paramVals[i++]);
        }
        return paramSettings;
    }

    @Override
    public MixedTypeChromosome clone() {
        return new MixedTypeChromosome(this.paramVals, this.searchSpace);
    }

    @Override
    public MixedTypeChromosome mutate(double mutRate, MersenneTwisterFast rng) {
        MixedTypeChromosome mc = this.clone();
        int i = 0;
        for (ParameterSpec ps : this.searchSpace.getParamSpecs()) {
            if (rng.nextDouble() < mutRate) {
                mc.paramVals[i] = ps.mutate(this.paramVals[i], 0.1, rng);
            }
            ++i;
        }
        return mc;
    }

    @Override
    public Chromosome[] crossoverWith(Chromosome other, MersenneTwisterFast rng) {
        if (!(other instanceof MixedTypeChromosome)) {
            throw new IllegalStateException("Can't crossover different types of Chromosomes.");
        }
        MixedTypeChromosome parent0 = this;
        MixedTypeChromosome parent1 = (MixedTypeChromosome)other;
        Chromosome[] children = new MixedTypeChromosome[]{parent0.clone(), parent1.clone()};
        int len = parent1.paramVals.length - 1;
        int splitPoint = len > 0 ? 1 + rng.nextInt(len) : 0;
        for (int i = 0; i < len; ++i) {
            if (i < splitPoint) continue;
            ((MixedTypeChromosome)children[0]).paramVals[i] = parent1.paramVals[i];
            ((MixedTypeChromosome)children[1]).paramVals[i] = parent0.paramVals[i];
        }
        return children;
    }

    @Override
    public SearchSpace getSearchSpace() {
        return this.searchSpace;
    }

    public boolean equals(Object other) {
        if (other instanceof MixedTypeChromosome) {
            MixedTypeChromosome dc = (MixedTypeChromosome)other;
            return Arrays.equals(this.paramVals, dc.paramVals);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Object o : this.paramVals) {
            hashCode = hashCode * 2 + o.hashCode();
        }
        return hashCode;
    }

    public strictfp static class Factory
    implements ChromosomeFactory {
        @Override
        public Chromosome createChromosome(SearchSpace searchSpace, MersenneTwisterFast rng) {
            return new MixedTypeChromosome(searchSpace, rng);
        }

        @Override
        public Chromosome createChromosome(SearchSpace searchSpace, LinkedHashMap<String, Object> paramSettings) {
            return new MixedTypeChromosome(searchSpace, paramSettings);
        }

        @Override
        public String getHTMLHelpText() {
            return "<strong>MixedTypeChromosome</strong> This encoding most closely matches the way that one commonly thinks of the ABM parameters.  Each parameter is stored separately with its own data type (discrete numeric, continuous numeric, categorical, boolean, etc). Mutation applies to each parameter separately (e.g. continous parameters use Gaussian mutation, boolean parameters get flipped).";
        }
    }
}

