/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;

public abstract class Track {
    private String name;
    private long trackID;
    private Locale locale;
    private Map<String, Object> metadata;
    private String description;

    public final String getName() {
        return this.name;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final long getTrackID() {
        return this.trackID;
    }

    public final Map<String, Object> getMetadata() {
        return this.metadata;
    }

    Track(long trackID, Map<String, Object> metadata) {
        this.trackID = trackID;
        Object value = metadata.get("name");
        if (null != value && value instanceof String) {
            this.name = (String)value;
        }
        if (null != (value = metadata.get("locale")) && value instanceof Locale) {
            this.locale = (Locale)value;
        }
        this.metadata = Collections.unmodifiableMap(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        Track track = this;
        synchronized (track) {
            if (null == this.description) {
                StringBuilder sb = new StringBuilder();
                Map<String, Object> md = this.getMetadata();
                sb.append(this.getClass().getName());
                sb.append("[ track id = ");
                sb.append(this.trackID);
                for (Map.Entry<String, Object> entry : md.entrySet()) {
                    Object value = entry.getValue();
                    if (null == value) continue;
                    sb.append(", ");
                    sb.append(entry.getKey());
                    sb.append(" = ");
                    sb.append(value.toString());
                }
                sb.append("]");
                this.description = sb.toString();
            }
        }
        return this.description;
    }
}

