/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.ProgressIndicatorSkin;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class ProgressIndicator
extends Control {
    public static final double INDETERMINATE_PROGRESS = -1.0;
    private ReadOnlyBooleanWrapper indeterminate;
    private DoubleProperty progress;
    private static final String DEFAULT_STYLE_CLASS = "progress-indicator";
    private static final PseudoClass PSEUDO_CLASS_DETERMINATE = PseudoClass.getPseudoClass("determinate");
    private static final PseudoClass PSEUDO_CLASS_INDETERMINATE = PseudoClass.getPseudoClass("indeterminate");

    public ProgressIndicator() {
        this(-1.0);
    }

    public ProgressIndicator(double progress) {
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
        this.setProgress(progress);
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.PROGRESS_INDICATOR);
        int c = Double.compare(-1.0, progress);
        this.pseudoClassStateChanged(PSEUDO_CLASS_INDETERMINATE, c == 0);
        this.pseudoClassStateChanged(PSEUDO_CLASS_DETERMINATE, c != 0);
    }

    private void setIndeterminate(boolean value) {
        this.indeterminatePropertyImpl().set(value);
    }

    public final boolean isIndeterminate() {
        return this.indeterminate == null ? true : this.indeterminate.get();
    }

    public final ReadOnlyBooleanProperty indeterminateProperty() {
        return this.indeterminatePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper indeterminatePropertyImpl() {
        if (this.indeterminate == null) {
            this.indeterminate = new ReadOnlyBooleanWrapper(true){

                @Override
                protected void invalidated() {
                    boolean active = this.get();
                    ProgressIndicator.this.pseudoClassStateChanged(PSEUDO_CLASS_INDETERMINATE, active);
                    ProgressIndicator.this.pseudoClassStateChanged(PSEUDO_CLASS_DETERMINATE, !active);
                }

                @Override
                public Object getBean() {
                    return ProgressIndicator.this;
                }

                @Override
                public String getName() {
                    return "indeterminate";
                }
            };
        }
        return this.indeterminate;
    }

    public final void setProgress(double value) {
        this.progressProperty().set(value);
    }

    public final double getProgress() {
        return this.progress == null ? -1.0 : this.progress.get();
    }

    public final DoubleProperty progressProperty() {
        if (this.progress == null) {
            this.progress = new DoublePropertyBase(-1.0){

                @Override
                protected void invalidated() {
                    ProgressIndicator.this.setIndeterminate(ProgressIndicator.this.getProgress() < 0.0);
                }

                @Override
                public Object getBean() {
                    return ProgressIndicator.this;
                }

                @Override
                public String getName() {
                    return "progress";
                }
            };
        }
        return this.progress;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ProgressIndicatorSkin(this);
    }

    @Override
    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case VALUE: {
                return this.getProgress();
            }
            case MAX_VALUE: {
                return 1.0;
            }
            case MIN_VALUE: {
                return 0.0;
            }
            case INDETERMINATE: {
                return this.isIndeterminate();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }
}

