/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.graphics;

import com.sun.webkit.Invoker;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.WCGraphicsContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class WCMediaPlayer
extends Ref {
    protected static final Logger log = Logger.getLogger("webkit.mediaplayer");
    protected static final boolean verbose;
    private long nPtr;
    protected static final int NETWORK_STATE_EMPTY = 0;
    protected static final int NETWORK_STATE_IDLE = 1;
    protected static final int NETWORK_STATE_LOADING = 2;
    protected static final int NETWORK_STATE_LOADED = 3;
    protected static final int NETWORK_STATE_FORMAT_ERROR = 4;
    protected static final int NETWORK_STATE_NETWORK_ERROR = 5;
    protected static final int NETWORK_STATE_DECODE_ERROR = 6;
    protected static final int READY_STATE_HAVE_NOTHING = 0;
    protected static final int READY_STATE_HAVE_METADATA = 1;
    protected static final int READY_STATE_HAVE_CURRENT_DATA = 2;
    protected static final int READY_STATE_HAVE_FUTURE_DATA = 3;
    protected static final int READY_STATE_HAVE_ENOUGH_DATA = 4;
    protected static final int PRELOAD_NONE = 0;
    protected static final int PRELOAD_METADATA = 1;
    protected static final int PRELOAD_AUTO = 2;
    private int networkState = 0;
    private int readyState = 0;
    private int preload = 2;
    private boolean paused = true;
    private boolean seeking = false;
    private Runnable newFrameNotifier = () -> {
        if (this.nPtr != 0L) {
            this.notifyNewFrame(this.nPtr);
        }
    };
    private boolean preserve = true;

    protected WCMediaPlayer() {
    }

    void setNativePointer(long nativePointer) {
        if (nativePointer == 0L) {
            throw new IllegalArgumentException("nativePointer is 0");
        }
        if (this.nPtr != 0L) {
            throw new IllegalStateException("nPtr is not 0");
        }
        this.nPtr = nativePointer;
    }

    protected abstract void load(String var1, String var2);

    protected abstract void cancelLoad();

    protected abstract void disposePlayer();

    protected abstract void prepareToPlay();

    protected abstract void play();

    protected abstract void pause();

    protected abstract float getCurrentTime();

    protected abstract void seek(float var1);

    protected abstract void setRate(float var1);

    protected abstract void setVolume(float var1);

    protected abstract void setMute(boolean var1);

    protected abstract void setSize(int var1, int var2);

    protected abstract void setPreservesPitch(boolean var1);

    protected abstract void renderCurrentFrame(WCGraphicsContext var1, int var2, int var3, int var4, int var5);

    protected boolean getPreservesPitch() {
        return this.preserve;
    }

    protected int getNetworkState() {
        return this.networkState;
    }

    protected int getReadyState() {
        return this.readyState;
    }

    protected int getPreload() {
        return this.preload;
    }

    protected boolean isPaused() {
        return this.paused;
    }

    protected boolean isSeeking() {
        return this.seeking;
    }

    protected void notifyNetworkStateChanged(int networkState) {
        if (this.networkState != networkState) {
            this.networkState = networkState;
            int _networkState = networkState;
            Invoker.getInvoker().invokeOnEventThread(() -> {
                if (this.nPtr != 0L) {
                    this.notifyNetworkStateChanged(this.nPtr, _networkState);
                }
            });
        }
    }

    protected void notifyReadyStateChanged(int readyState) {
        if (this.readyState != readyState) {
            this.readyState = readyState;
            int _readyState = readyState;
            Invoker.getInvoker().invokeOnEventThread(() -> {
                if (this.nPtr != 0L) {
                    this.notifyReadyStateChanged(this.nPtr, _readyState);
                }
            });
        }
    }

    protected void notifyPaused(boolean paused) {
        if (verbose) {
            log.log(Level.FINE, "notifyPaused, {0} => {1}", new Object[]{this.paused, paused});
        }
        if (this.paused != paused) {
            this.paused = paused;
            boolean _paused = paused;
            Invoker.getInvoker().invokeOnEventThread(() -> {
                if (this.nPtr != 0L) {
                    this.notifyPaused(this.nPtr, _paused);
                }
            });
        }
    }

    protected void notifySeeking(boolean seeking, int readyState) {
        if (verbose) {
            log.log(Level.FINE, "notifySeeking, {0} => {1}", new Object[]{this.seeking, seeking});
        }
        if (this.seeking != seeking || this.readyState != readyState) {
            this.seeking = seeking;
            this.readyState = readyState;
            boolean _seeking = seeking;
            int _readyState = readyState;
            Invoker.getInvoker().invokeOnEventThread(() -> {
                if (this.nPtr != 0L) {
                    this.notifySeeking(this.nPtr, _seeking, _readyState);
                }
            });
        }
    }

    protected void notifyFinished() {
        Invoker.getInvoker().invokeOnEventThread(() -> {
            if (this.nPtr != 0L) {
                this.notifyFinished(this.nPtr);
            }
        });
    }

    protected void notifyReady(boolean hasVideo, boolean hasAudio, float duration) {
        boolean _hasVideo = hasVideo;
        boolean _hasAudio = hasAudio;
        float _duration = duration;
        Invoker.getInvoker().invokeOnEventThread(() -> {
            if (this.nPtr != 0L) {
                this.notifyReady(this.nPtr, _hasVideo, _hasAudio, _duration);
            }
        });
    }

    protected void notifyDurationChanged(float newDuration) {
        float _newDuration = newDuration;
        Invoker.getInvoker().invokeOnEventThread(() -> {
            if (this.nPtr != 0L) {
                this.notifyDurationChanged(this.nPtr, _newDuration);
            }
        });
    }

    protected void notifySizeChanged(int width, int height) {
        int _width = width;
        int _height = height;
        Invoker.getInvoker().invokeOnEventThread(() -> {
            if (this.nPtr != 0L) {
                this.notifySizeChanged(this.nPtr, _width, _height);
            }
        });
    }

    protected void notifyNewFrame() {
        Invoker.getInvoker().invokeOnEventThread(this.newFrameNotifier);
    }

    protected void notifyBufferChanged(float[] ranges, int bytesLoaded) {
        float[] _ranges = ranges;
        int _bytesLoaded = bytesLoaded;
        Invoker.getInvoker().invokeOnEventThread(() -> {
            if (this.nPtr != 0L) {
                this.notifyBufferChanged(this.nPtr, _ranges, _bytesLoaded);
            }
        });
    }

    private void fwkLoad(String url, String userAgent) {
        if (verbose) {
            log.log(Level.FINE, "fwkLoad, url={0}, userAgent={1}", new Object[]{url, userAgent});
        }
        this.load(url, userAgent);
    }

    private void fwkCancelLoad() {
        if (verbose) {
            log.log(Level.FINE, "fwkCancelLoad");
        }
        this.cancelLoad();
    }

    private void fwkPrepareToPlay() {
        if (verbose) {
            log.log(Level.FINE, "fwkPrepareToPlay");
        }
        this.prepareToPlay();
    }

    private void fwkDispose() {
        if (verbose) {
            log.log(Level.FINE, "fwkDispose");
        }
        this.nPtr = 0L;
        this.cancelLoad();
        this.disposePlayer();
    }

    private void fwkPlay() {
        if (verbose) {
            log.log(Level.FINE, "fwkPlay");
        }
        this.play();
    }

    private void fwkPause() {
        if (verbose) {
            log.log(Level.FINE, "fwkPause");
        }
        this.pause();
    }

    private float fwkGetCurrentTime() {
        float res = this.getCurrentTime();
        if (verbose) {
            log.log(Level.FINER, "fwkGetCurrentTime(), return {0}", Float.valueOf(res));
        }
        return res;
    }

    private void fwkSeek(float time) {
        if (verbose) {
            log.log(Level.FINE, "fwkSeek({0})", Float.valueOf(time));
        }
        this.seek(time);
    }

    private void fwkSetRate(float rate) {
        if (verbose) {
            log.log(Level.FINE, "fwkSetRate({0})", Float.valueOf(rate));
        }
        this.setRate(rate);
    }

    private void fwkSetVolume(float volume) {
        if (verbose) {
            log.log(Level.FINE, "fwkSetVolume({0})", Float.valueOf(volume));
        }
        this.setVolume(volume);
    }

    private void fwkSetMute(boolean mute) {
        if (verbose) {
            log.log(Level.FINE, "fwkSetMute({0})", mute);
        }
        this.setMute(mute);
    }

    private void fwkSetSize(int w, int h) {
        this.setSize(w, h);
    }

    private void fwkSetPreservesPitch(boolean preserve) {
        if (verbose) {
            log.log(Level.FINE, "setPreservesPitch({0})", preserve);
        }
        this.preserve = preserve;
        this.setPreservesPitch(preserve);
    }

    private void fwkSetPreload(int preload) {
        if (verbose) {
            log.log(Level.FINE, "fwkSetPreload({0})", preload == 0 ? "PRELOAD_NONE" : (preload == 1 ? "PRELOAD_METADATA" : (preload == 2 ? "PRELOAD_AUTO" : "INVALID VALUE: " + preload)));
        }
        this.preload = preload;
    }

    void render(WCGraphicsContext gc, int x, int y, int w, int h) {
        if (verbose) {
            log.log(Level.FINER, "render(x={0}, y={1}, w={2}, h={3}", new Object[]{x, y, w, h});
        }
        this.renderCurrentFrame(gc, x, y, w, h);
    }

    private native void notifyNetworkStateChanged(long var1, int var3);

    private native void notifyReadyStateChanged(long var1, int var3);

    private native void notifyPaused(long var1, boolean var3);

    private native void notifySeeking(long var1, boolean var3, int var4);

    private native void notifyFinished(long var1);

    private native void notifyReady(long var1, boolean var3, boolean var4, float var5);

    private native void notifyDurationChanged(long var1, float var3);

    private native void notifySizeChanged(long var1, int var3, int var4);

    private native void notifyNewFrame(long var1);

    private native void notifyBufferChanged(long var1, float[] var3, int var4);

    static {
        if (log.getLevel() == null) {
            verbose = false;
            log.setLevel(Level.OFF);
        } else {
            verbose = true;
            log.log(Level.CONFIG, "webkit.mediaplayer logging is ON, level: {0}", log.getLevel());
        }
    }
}

