/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.IllegalPathStateException;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;

public abstract class Shape {
    public static final int RECT_INTERSECTS = Integer.MIN_VALUE;
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    public abstract RectBounds getBounds();

    public abstract boolean contains(float var1, float var2);

    public boolean contains(Point2D p) {
        return this.contains(p.x, p.y);
    }

    public abstract boolean intersects(float var1, float var2, float var3, float var4);

    public boolean intersects(RectBounds r) {
        float x = r.getMinX();
        float y = r.getMinY();
        float w = r.getMaxX() - x;
        float h = r.getMaxY() - y;
        return this.intersects(x, y, w, h);
    }

    public abstract boolean contains(float var1, float var2, float var3, float var4);

    public boolean contains(RectBounds r) {
        float x = r.getMinX();
        float y = r.getMinY();
        float w = r.getMaxX() - x;
        float h = r.getMaxY() - y;
        return this.contains(x, y, w, h);
    }

    public abstract PathIterator getPathIterator(BaseTransform var1);

    public abstract PathIterator getPathIterator(BaseTransform var1, float var2);

    public abstract Shape copy();

    public static int pointCrossingsForPath(PathIterator pi, float px, float py) {
        if (pi.isDone()) {
            return 0;
        }
        float[] coords = new float[6];
        if (pi.currentSegment(coords) != 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        pi.next();
        float movx = coords[0];
        float movy = coords[1];
        float curx = movx;
        float cury = movy;
        int crossings = 0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (cury != movy) {
                        crossings += Shape.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                    }
                    movx = curx = coords[0];
                    movy = cury = coords[1];
                    break;
                }
                case 1: {
                    float endx = coords[0];
                    float endy = coords[1];
                    crossings += Shape.pointCrossingsForLine(px, py, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 2: {
                    float endx = coords[2];
                    float endy = coords[3];
                    crossings += Shape.pointCrossingsForQuad(px, py, curx, cury, coords[0], coords[1], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 3: {
                    float endx = coords[4];
                    float endy = coords[5];
                    crossings += Shape.pointCrossingsForCubic(px, py, curx, cury, coords[0], coords[1], coords[2], coords[3], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 4: {
                    if (cury != movy) {
                        crossings += Shape.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        if (cury != movy) {
            crossings += Shape.pointCrossingsForLine(px, py, curx, cury, movx, movy);
        }
        return crossings;
    }

    public static int pointCrossingsForLine(float px, float py, float x0, float y0, float x1, float y1) {
        if (py < y0 && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= x1) {
            return 0;
        }
        if (px < x0 && px < x1) {
            return y0 < y1 ? 1 : -1;
        }
        float xintercept = x0 + (py - y0) * (x1 - x0) / (y1 - y0);
        if (px >= xintercept) {
            return 0;
        }
        return y0 < y1 ? 1 : -1;
    }

    public static int pointCrossingsForQuad(float px, float py, float x0, float y0, float xc, float yc, float x1, float y1, int level) {
        if (py < y0 && py < yc && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= yc && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= xc && px >= x1) {
            return 0;
        }
        if (px < x0 && px < xc && px < x1) {
            if (py >= y0) {
                if (py < y1) {
                    return 1;
                }
            } else if (py >= y1) {
                return -1;
            }
            return 0;
        }
        if (level > 52) {
            return Shape.pointCrossingsForLine(px, py, x0, y0, x1, y1);
        }
        float x0c = (x0 + xc) / 2.0f;
        float y0c = (y0 + yc) / 2.0f;
        float xc1 = (xc + x1) / 2.0f;
        float yc1 = (yc + y1) / 2.0f;
        xc = (x0c + xc1) / 2.0f;
        yc = (y0c + yc1) / 2.0f;
        if (Float.isNaN(xc) || Float.isNaN(yc)) {
            return 0;
        }
        return Shape.pointCrossingsForQuad(px, py, x0, y0, x0c, y0c, xc, yc, level + 1) + Shape.pointCrossingsForQuad(px, py, xc, yc, xc1, yc1, x1, y1, level + 1);
    }

    public static int pointCrossingsForCubic(float px, float py, float x0, float y0, float xc0, float yc0, float xc1, float yc1, float x1, float y1, int level) {
        if (py < y0 && py < yc0 && py < yc1 && py < y1) {
            return 0;
        }
        if (py >= y0 && py >= yc0 && py >= yc1 && py >= y1) {
            return 0;
        }
        if (px >= x0 && px >= xc0 && px >= xc1 && px >= x1) {
            return 0;
        }
        if (px < x0 && px < xc0 && px < xc1 && px < x1) {
            if (py >= y0) {
                if (py < y1) {
                    return 1;
                }
            } else if (py >= y1) {
                return -1;
            }
            return 0;
        }
        if (level > 52) {
            return Shape.pointCrossingsForLine(px, py, x0, y0, x1, y1);
        }
        float xmid = (xc0 + xc1) / 2.0f;
        float ymid = (yc0 + yc1) / 2.0f;
        xc0 = (x0 + xc0) / 2.0f;
        yc0 = (y0 + yc0) / 2.0f;
        xc1 = (xc1 + x1) / 2.0f;
        yc1 = (yc1 + y1) / 2.0f;
        float xc0m = (xc0 + xmid) / 2.0f;
        float yc0m = (yc0 + ymid) / 2.0f;
        float xmc1 = (xmid + xc1) / 2.0f;
        float ymc1 = (ymid + yc1) / 2.0f;
        xmid = (xc0m + xmc1) / 2.0f;
        ymid = (yc0m + ymc1) / 2.0f;
        if (Float.isNaN(xmid) || Float.isNaN(ymid)) {
            return 0;
        }
        return Shape.pointCrossingsForCubic(px, py, x0, y0, xc0, yc0, xc0m, yc0m, xmid, ymid, level + 1) + Shape.pointCrossingsForCubic(px, py, xmid, ymid, xmc1, ymc1, xc1, yc1, x1, y1, level + 1);
    }

    public static int rectCrossingsForPath(PathIterator pi, float rxmin, float rymin, float rxmax, float rymax) {
        float movy;
        float movx;
        if (rxmax <= rxmin || rymax <= rymin) {
            return 0;
        }
        if (pi.isDone()) {
            return 0;
        }
        float[] coords = new float[6];
        if (pi.currentSegment(coords) != 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        pi.next();
        float curx = movx = coords[0];
        float cury = movy = coords[1];
        int crossings = 0;
        while (crossings != Integer.MIN_VALUE && !pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (curx != movx || cury != movy) {
                        crossings = Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    movx = curx = coords[0];
                    movy = cury = coords[1];
                    break;
                }
                case 1: {
                    float endx = coords[0];
                    float endy = coords[1];
                    crossings = Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 2: {
                    float endx = coords[2];
                    float endy = coords[3];
                    crossings = Shape.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, curx, cury, coords[0], coords[1], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 3: {
                    float endx = coords[4];
                    float endy = coords[5];
                    crossings = Shape.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, curx, cury, coords[0], coords[1], coords[2], coords[3], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    break;
                }
                case 4: {
                    if (curx != movx || cury != movy) {
                        crossings = Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        if (crossings != Integer.MIN_VALUE && (curx != movx || cury != movy)) {
            crossings = Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
        }
        return crossings;
    }

    public static int rectCrossingsForLine(int crossings, float rxmin, float rymin, float rxmax, float rymax, float x0, float y0, float x1, float y1) {
        if (y0 >= rymax && y1 >= rymax) {
            return crossings;
        }
        if (y0 <= rymin && y1 <= rymin) {
            return crossings;
        }
        if (x0 <= rxmin && x1 <= rxmin) {
            return crossings;
        }
        if (x0 >= rxmax && x1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin) {
                    ++crossings;
                }
                if (y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin) {
                    --crossings;
                }
                if (y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax) {
            return Integer.MIN_VALUE;
        }
        float xi0 = x0;
        if (y0 < rymin) {
            xi0 += (rymin - y0) * (x1 - x0) / (y1 - y0);
        } else if (y0 > rymax) {
            xi0 += (rymax - y0) * (x1 - x0) / (y1 - y0);
        }
        float xi1 = x1;
        if (y1 < rymin) {
            xi1 += (rymin - y1) * (x0 - x1) / (y0 - y1);
        } else if (y1 > rymax) {
            xi1 += (rymax - y1) * (x0 - x1) / (y0 - y1);
        }
        if (xi0 <= rxmin && xi1 <= rxmin) {
            return crossings;
        }
        if (xi0 >= rxmax && xi1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin) {
                    ++crossings;
                }
                if (y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin) {
                    --crossings;
                }
                if (y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        return Integer.MIN_VALUE;
    }

    public static int rectCrossingsForQuad(int crossings, float rxmin, float rymin, float rxmax, float rymax, float x0, float y0, float xc, float yc, float x1, float y1, int level) {
        if (y0 >= rymax && yc >= rymax && y1 >= rymax) {
            return crossings;
        }
        if (y0 <= rymin && yc <= rymin && y1 <= rymin) {
            return crossings;
        }
        if (x0 <= rxmin && xc <= rxmin && x1 <= rxmin) {
            return crossings;
        }
        if (x0 >= rxmax && xc >= rxmax && x1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin && y1 > rymin) {
                    ++crossings;
                }
                if (y0 < rymax && y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin && y0 > rymin) {
                    --crossings;
                }
                if (y1 < rymax && y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (x0 < rxmax && x0 > rxmin && y0 < rymax && y0 > rymin || x1 < rxmax && x1 > rxmin && y1 < rymax && y1 > rymin) {
            return Integer.MIN_VALUE;
        }
        if (level > 52) {
            return Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
        }
        float x0c = (x0 + xc) / 2.0f;
        float y0c = (y0 + yc) / 2.0f;
        float xc1 = (xc + x1) / 2.0f;
        float yc1 = (yc + y1) / 2.0f;
        xc = (x0c + xc1) / 2.0f;
        yc = (y0c + yc1) / 2.0f;
        if (Float.isNaN(xc) || Float.isNaN(yc)) {
            return 0;
        }
        if ((crossings = Shape.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x0c, y0c, xc, yc, level + 1)) != Integer.MIN_VALUE) {
            crossings = Shape.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, xc, yc, xc1, yc1, x1, y1, level + 1);
        }
        return crossings;
    }

    public static int rectCrossingsForCubic(int crossings, float rxmin, float rymin, float rxmax, float rymax, float x0, float y0, float xc0, float yc0, float xc1, float yc1, float x1, float y1, int level) {
        if (y0 >= rymax && yc0 >= rymax && yc1 >= rymax && y1 >= rymax) {
            return crossings;
        }
        if (y0 <= rymin && yc0 <= rymin && yc1 <= rymin && y1 <= rymin) {
            return crossings;
        }
        if (x0 <= rxmin && xc0 <= rxmin && xc1 <= rxmin && x1 <= rxmin) {
            return crossings;
        }
        if (x0 >= rxmax && xc0 >= rxmax && xc1 >= rxmax && x1 >= rxmax) {
            if (y0 < y1) {
                if (y0 <= rymin && y1 > rymin) {
                    ++crossings;
                }
                if (y0 < rymax && y1 >= rymax) {
                    ++crossings;
                }
            } else if (y1 < y0) {
                if (y1 <= rymin && y0 > rymin) {
                    --crossings;
                }
                if (y1 < rymax && y0 >= rymax) {
                    --crossings;
                }
            }
            return crossings;
        }
        if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax) {
            return Integer.MIN_VALUE;
        }
        if (level > 52) {
            return Shape.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
        }
        float xmid = (xc0 + xc1) / 2.0f;
        float ymid = (yc0 + yc1) / 2.0f;
        xc0 = (x0 + xc0) / 2.0f;
        yc0 = (y0 + yc0) / 2.0f;
        xc1 = (xc1 + x1) / 2.0f;
        yc1 = (yc1 + y1) / 2.0f;
        float xc0m = (xc0 + xmid) / 2.0f;
        float yc0m = (yc0 + ymid) / 2.0f;
        float xmc1 = (xmid + xc1) / 2.0f;
        float ymc1 = (ymid + yc1) / 2.0f;
        xmid = (xc0m + xmc1) / 2.0f;
        ymid = (yc0m + ymc1) / 2.0f;
        if (Float.isNaN(xmid) || Float.isNaN(ymid)) {
            return 0;
        }
        if ((crossings = Shape.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, x0, y0, xc0, yc0, xc0m, yc0m, xmid, ymid, level + 1)) != Integer.MIN_VALUE) {
            crossings = Shape.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, xmid, ymid, xmc1, ymc1, xc1, yc1, x1, y1, level + 1);
        }
        return crossings;
    }

    static boolean intersectsLine(float rx1, float ry1, float rwidth, float rheight, float x1, float y1, float x2, float y2) {
        int out1;
        int out2 = Shape.outcode(rx1, ry1, rwidth, rheight, x2, y2);
        if (out2 == 0) {
            return true;
        }
        while ((out1 = Shape.outcode(rx1, ry1, rwidth, rheight, x1, y1)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                if ((out1 & 4) != 0) {
                    rx1 += rwidth;
                }
                y1 += (rx1 - x1) * (y2 - y1) / (x2 - x1);
                x1 = rx1;
                continue;
            }
            if ((out1 & 8) != 0) {
                ry1 += rheight;
            }
            x1 += (ry1 - y1) * (x2 - x1) / (y2 - y1);
            y1 = ry1;
        }
        return true;
    }

    static int outcode(float rx, float ry, float rwidth, float rheight, float x, float y) {
        int out = 0;
        if (rwidth <= 0.0f) {
            out |= 5;
        } else if (x < rx) {
            out |= 1;
        } else if ((double)x > (double)rx + (double)rwidth) {
            out |= 4;
        }
        if (rheight <= 0.0f) {
            out |= 0xA;
        } else if (y < ry) {
            out |= 2;
        } else if ((double)y > (double)ry + (double)rheight) {
            out |= 8;
        }
        return out;
    }

    public static void accumulate(float[] bbox, Shape s, BaseTransform tx) {
        PathIterator pi = s.getPathIterator(tx);
        float[] coords = new float[6];
        float mx = 0.0f;
        float my = 0.0f;
        float x0 = 0.0f;
        float y0 = 0.0f;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    mx = coords[0];
                    my = coords[1];
                }
                case 1: {
                    x0 = coords[0];
                    y0 = coords[1];
                    if (bbox[0] > x0) {
                        bbox[0] = x0;
                    }
                    if (bbox[1] > y0) {
                        bbox[1] = y0;
                    }
                    if (bbox[2] < x0) {
                        bbox[2] = x0;
                    }
                    if (!(bbox[3] < y0)) break;
                    bbox[3] = y0;
                    break;
                }
                case 2: {
                    float x1 = coords[2];
                    float y1 = coords[3];
                    if (bbox[0] > x1) {
                        bbox[0] = x1;
                    }
                    if (bbox[1] > y1) {
                        bbox[1] = y1;
                    }
                    if (bbox[2] < x1) {
                        bbox[2] = x1;
                    }
                    if (bbox[3] < y1) {
                        bbox[3] = y1;
                    }
                    if (bbox[0] > coords[0] || bbox[2] < coords[0]) {
                        Shape.accumulateQuad(bbox, 0, x0, coords[0], x1);
                    }
                    if (bbox[1] > coords[1] || bbox[3] < coords[1]) {
                        Shape.accumulateQuad(bbox, 1, y0, coords[1], y1);
                    }
                    x0 = x1;
                    y0 = y1;
                    break;
                }
                case 3: {
                    float x1 = coords[4];
                    float y1 = coords[5];
                    if (bbox[0] > x1) {
                        bbox[0] = x1;
                    }
                    if (bbox[1] > y1) {
                        bbox[1] = y1;
                    }
                    if (bbox[2] < x1) {
                        bbox[2] = x1;
                    }
                    if (bbox[3] < y1) {
                        bbox[3] = y1;
                    }
                    if (bbox[0] > coords[0] || bbox[2] < coords[0] || bbox[0] > coords[2] || bbox[2] < coords[2]) {
                        Shape.accumulateCubic(bbox, 0, x0, coords[0], coords[2], x1);
                    }
                    if (bbox[1] > coords[1] || bbox[3] < coords[1] || bbox[1] > coords[3] || bbox[3] < coords[3]) {
                        Shape.accumulateCubic(bbox, 1, y0, coords[1], coords[3], y1);
                    }
                    x0 = x1;
                    y0 = y1;
                    break;
                }
                case 4: {
                    x0 = mx;
                    y0 = my;
                }
            }
            pi.next();
        }
    }

    public static void accumulateQuad(float[] bbox, int off, float v0, float vc, float v1) {
        float t;
        float num = v0 - vc;
        float den = v1 - vc + num;
        if (den != 0.0f && (t = num / den) > 0.0f && t < 1.0f) {
            float u = 1.0f - t;
            float v = v0 * u * u + 2.0f * vc * t * u + v1 * t * t;
            if (bbox[off] > v) {
                bbox[off] = v;
            }
            if (bbox[off + 2] < v) {
                bbox[off + 2] = v;
            }
        }
    }

    public static void accumulateCubic(float[] bbox, int off, float v0, float vc0, float vc1, float v1) {
        float c = vc0 - v0;
        float b = 2.0f * (vc1 - vc0 - c);
        float a = v1 - vc1 - b - c;
        if (a == 0.0f) {
            if (b == 0.0f) {
                return;
            }
            Shape.accumulateCubic(bbox, off, -c / b, v0, vc0, vc1, v1);
        } else {
            float d = b * b - 4.0f * a * c;
            if (d < 0.0f) {
                return;
            }
            d = (float)Math.sqrt(d);
            if (b < 0.0f) {
                d = -d;
            }
            float q = (b + d) / -2.0f;
            Shape.accumulateCubic(bbox, off, q / a, v0, vc0, vc1, v1);
            if (q != 0.0f) {
                Shape.accumulateCubic(bbox, off, c / q, v0, vc0, vc1, v1);
            }
        }
    }

    public static void accumulateCubic(float[] bbox, int off, float t, float v0, float vc0, float vc1, float v1) {
        if (t > 0.0f && t < 1.0f) {
            float u = 1.0f - t;
            float v = v0 * u * u * u + 3.0f * vc0 * t * u * u + 3.0f * vc1 * t * t * u + v1 * t * t * t;
            if (bbox[off] > v) {
                bbox[off] = v;
            }
            if (bbox[off + 2] < v) {
                bbox[off + 2] = v;
            }
        }
    }
}

