/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.builder;

import com.sun.javafx.fxml.BeanAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javafx.beans.NamedArg;
import javafx.util.Builder;
import sun.reflect.misc.ConstructorUtil;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public class ProxyBuilder<T>
extends AbstractMap<String, Object>
implements Builder<T> {
    private Class<?> type;
    private final Map<Constructor, Map<String, AnnotationValue>> constructorsMap;
    private final Map<String, Property> propertiesMap;
    private final Set<Constructor> constructors;
    private Set<String> propertyNames;
    private boolean hasDefaultConstructor = false;
    private Constructor defaultConstructor;
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private final Comparator<Constructor> constructorComparator = (o1, o2) -> {
        int len1 = o1.getParameterCount();
        int len2 = o2.getParameterCount();
        int lim = Math.min(len1, len2);
        for (int i = 0; i < lim; ++i) {
            Class<?> c2;
            Class<?> c1 = o1.getParameterTypes()[i];
            if (c1.equals(c2 = o2.getParameterTypes()[i])) continue;
            if (c1.equals(Integer.TYPE) && c2.equals(Double.TYPE)) {
                return -1;
            }
            if (c1.equals(Double.TYPE) && c2.equals(Integer.TYPE)) {
                return 1;
            }
            return c1.getCanonicalName().compareTo(c2.getCanonicalName());
        }
        return len1 - len2;
    };
    private final Map<String, Object> userValues = new HashMap<String, Object>();
    private final Map<String, Object> containers = new HashMap<String, Object>();
    private static final Map<Class<?>, Object> defaultsMap = new HashMap();

    public ProxyBuilder(Class<?> tp) {
        Constructor<?>[] ctors;
        this.type = tp;
        this.constructorsMap = new HashMap<Constructor, Map<String, AnnotationValue>>();
        for (Constructor<?> c : ctors = ConstructorUtil.getConstructors(this.type)) {
            Class<?>[] paramTypes = c.getParameterTypes();
            Annotation[][] paramAnnotations = c.getParameterAnnotations();
            if (paramTypes.length == 0) {
                this.hasDefaultConstructor = true;
                this.defaultConstructor = c;
                continue;
            }
            int i = 0;
            boolean properlyAnnotated = true;
            LinkedHashMap<String, AnnotationValue> args = new LinkedHashMap<String, AnnotationValue>();
            for (Class<?> clazz : paramTypes) {
                NamedArg argAnnotation = null;
                for (Annotation annotation : paramAnnotations[i]) {
                    if (!(annotation instanceof NamedArg)) continue;
                    argAnnotation = (NamedArg)annotation;
                    break;
                }
                if (argAnnotation == null) {
                    properlyAnnotated = false;
                    break;
                }
                AnnotationValue av = new AnnotationValue(argAnnotation.value(), argAnnotation.defaultValue(), clazz);
                args.put(argAnnotation.value(), av);
                ++i;
            }
            if (!properlyAnnotated) continue;
            this.constructorsMap.put(c, args);
        }
        if (!this.hasDefaultConstructor && this.constructorsMap.isEmpty()) {
            throw new RuntimeException("Cannot create instance of " + this.type.getCanonicalName() + " the constructor is not properly annotated.");
        }
        this.constructors = new TreeSet<Constructor>(this.constructorComparator);
        this.constructors.addAll(this.constructorsMap.keySet());
        this.propertiesMap = this.scanForSetters();
    }

    @Override
    public Object put(String key, Object value) {
        this.userValues.put(key, value);
        return null;
    }

    private Object getTemporaryContainer(String propName) {
        Object o = this.containers.get(propName);
        if (o == null && (o = this.getReadOnlyProperty(propName)) != null) {
            this.containers.put(propName, o);
        }
        return o;
    }

    private Object getReadOnlyProperty(String propName) {
        return new ArrayListWrapper();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getTemporaryContainer(key.toString()) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(Object key) {
        return this.getTemporaryContainer(key.toString());
    }

    @Override
    public T build() {
        Object retObj = null;
        for (Map.Entry<String, Object> entry : this.containers.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
        this.propertyNames = this.userValues.keySet();
        for (Constructor c : this.constructors) {
            Set<String> argumentNames = this.getArgumentNames(c);
            if (!this.propertyNames.equals(argumentNames) || (retObj = this.createObjectWithExactArguments(c, argumentNames)) == null) continue;
            return (T)retObj;
        }
        Set<String> settersArgs = this.propertiesMap.keySet();
        if (settersArgs.containsAll(this.propertyNames) && this.hasDefaultConstructor && (retObj = this.createObjectFromDefaultConstructor()) != null) {
            return (T)retObj;
        }
        HashSet<String> propertiesToSet = new HashSet<String>(this.propertyNames);
        propertiesToSet.retainAll(settersArgs);
        Set<Constructor> chosenConstructors = this.chooseBestConstructors(settersArgs);
        for (Constructor constructor : chosenConstructors) {
            retObj = this.createObjectFromConstructor(constructor, propertiesToSet);
            if (retObj == null) continue;
            return (T)retObj;
        }
        if (retObj == null) {
            throw new RuntimeException("Cannot create instance of " + this.type.getCanonicalName() + " with given set of properties: " + this.userValues.keySet().toString());
        }
        return (T)retObj;
    }

    private Set<Constructor> chooseBestConstructors(Set<String> settersArgs) {
        HashSet<String> immutablesToSet = new HashSet<String>(this.propertyNames);
        immutablesToSet.removeAll(settersArgs);
        HashSet<String> propertiesToSet = new HashSet<String>(this.propertyNames);
        propertiesToSet.retainAll(settersArgs);
        int propertiesToSetCount = Integer.MAX_VALUE;
        int mutablesToSetCount = Integer.MAX_VALUE;
        TreeSet<Constructor> chosenConstructors = new TreeSet<Constructor>(this.constructorComparator);
        Set argsNotSet = null;
        for (Constructor c : this.constructors) {
            Set<String> argumentNames = this.getArgumentNames(c);
            if (!argumentNames.containsAll(immutablesToSet)) continue;
            HashSet<String> propertiesToSetInConstructor = new HashSet<String>(argumentNames);
            propertiesToSetInConstructor.removeAll(this.propertyNames);
            HashSet<String> mutablesNotSet = new HashSet<String>(propertiesToSet);
            mutablesNotSet.removeAll(argumentNames);
            int currentPropSize = propertiesToSetInConstructor.size();
            if (propertiesToSetCount == currentPropSize && mutablesToSetCount == mutablesNotSet.size()) {
                chosenConstructors.add(c);
            }
            if (propertiesToSetCount <= currentPropSize && (propertiesToSetCount != currentPropSize || mutablesToSetCount <= mutablesNotSet.size())) continue;
            propertiesToSetCount = currentPropSize;
            mutablesToSetCount = mutablesNotSet.size();
            chosenConstructors.clear();
            chosenConstructors.add(c);
        }
        if (argsNotSet != null && !argsNotSet.isEmpty()) {
            throw new RuntimeException("Cannot create instance of " + this.type.getCanonicalName() + " no constructor contains all properties specified in FXML.");
        }
        return chosenConstructors;
    }

    private Set<String> getArgumentNames(Constructor c) {
        Map<String, AnnotationValue> constructorArgsMap = this.constructorsMap.get(c);
        Set<String> argumentNames = null;
        if (constructorArgsMap != null) {
            argumentNames = constructorArgsMap.keySet();
        }
        return argumentNames;
    }

    private Object createObjectFromDefaultConstructor() throws RuntimeException {
        Object retObj = null;
        try {
            retObj = this.createInstance(this.defaultConstructor, new Object[0]);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        for (String propName : this.propertyNames) {
            try {
                Property property = this.propertiesMap.get(propName);
                property.invoke(retObj, this.getUserValue(propName, property.getType()));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return retObj;
    }

    private Object createObjectFromConstructor(Constructor constructor, Set<String> propertiesToSet) {
        Object retObj = null;
        Map<String, AnnotationValue> constructorArgsMap = this.constructorsMap.get(constructor);
        Object[] argsForConstruction = new Object[constructorArgsMap.size()];
        int i = 0;
        HashSet<String> currentPropertiesToSet = new HashSet<String>(propertiesToSet);
        for (AnnotationValue value : constructorArgsMap.values()) {
            Object userValue = this.getUserValue(value.getName(), value.getType());
            if (userValue != null) {
                try {
                    argsForConstruction[i] = BeanAdapter.coerce(userValue, value.getType());
                }
                catch (Exception ex) {
                    return null;
                }
            } else if (!value.getDefaultValue().isEmpty()) {
                try {
                    argsForConstruction[i] = BeanAdapter.coerce(value.getDefaultValue(), value.getType());
                }
                catch (Exception ex) {
                    return null;
                }
            } else {
                argsForConstruction[i] = ProxyBuilder.getDefaultValue(value.getType());
            }
            currentPropertiesToSet.remove(value.getName());
            ++i;
        }
        try {
            retObj = this.createInstance(constructor, argsForConstruction);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (retObj != null) {
            for (String propName : currentPropertiesToSet) {
                try {
                    Property property = this.propertiesMap.get(propName);
                    property.invoke(retObj, this.getUserValue(propName, property.getType()));
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return retObj;
    }

    private Object getUserValue(String key, Class<?> type) {
        Object val = this.userValues.get(key);
        if (val == null) {
            return null;
        }
        if (type.isAssignableFrom(val.getClass())) {
            return val;
        }
        if (type.isArray()) {
            try {
                return ProxyBuilder.convertListToArray(val, type);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (ArrayListWrapper.class.equals(val.getClass())) {
            List l = (List)val;
            return l.get(0);
        }
        return val;
    }

    private Object createObjectWithExactArguments(Constructor c, Set<String> argumentNames) {
        Object retObj = null;
        Object[] argsForConstruction = new Object[argumentNames.size()];
        Map<String, AnnotationValue> constructorArgsMap = this.constructorsMap.get(c);
        int i = 0;
        for (String arg : argumentNames) {
            Class<?> tp = constructorArgsMap.get(arg).getType();
            Object value = this.getUserValue(arg, tp);
            try {
                argsForConstruction[i++] = BeanAdapter.coerce(value, tp);
            }
            catch (Exception ex) {
                return null;
            }
        }
        try {
            retObj = this.createInstance(c, argsForConstruction);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retObj;
    }

    private Object createInstance(Constructor c, Object[] args) throws Exception {
        Object retObj = null;
        ReflectUtil.checkPackageAccess(this.type);
        retObj = c.newInstance(args);
        return retObj;
    }

    private Map<String, Property> scanForSetters() {
        HashMap<String, Property> strsMap = new HashMap<String, Property>();
        HashMap<String, LinkedList<Method>> methods = ProxyBuilder.getClassMethodCache(this.type);
        for (String methodName : methods.keySet()) {
            Class<?>[] argType;
            Class<?> retType;
            List methodsList;
            String propName;
            if (methodName.startsWith(SETTER_PREFIX)) {
                propName = methodName.substring(SETTER_PREFIX.length());
                propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                methodsList = (List)methods.get(methodName);
                for (Method m : methodsList) {
                    retType = m.getReturnType();
                    argType = m.getParameterTypes();
                    if (!retType.equals(Void.TYPE) || argType.length != 1) continue;
                    strsMap.put(propName, new Setter(m, argType[0]));
                }
            }
            if (!methodName.startsWith(GETTER_PREFIX)) continue;
            propName = methodName.substring(SETTER_PREFIX.length());
            propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
            methodsList = (List)methods.get(methodName);
            for (Method m : methodsList) {
                retType = m.getReturnType();
                argType = m.getParameterTypes();
                if (!Collection.class.isAssignableFrom(retType) || argType.length != 0) continue;
                strsMap.put(propName, new Getter(m, retType));
            }
        }
        return strsMap;
    }

    private static HashMap<String, LinkedList<Method>> getClassMethodCache(Class<?> type) {
        Method[] declaredMethods;
        HashMap<String, LinkedList<Method>> classMethodCache = new HashMap<String, LinkedList<Method>>();
        ReflectUtil.checkPackageAccess(type);
        for (Method method : declaredMethods = type.getMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
            String name = method.getName();
            LinkedList<Method> namedMethods = classMethodCache.get(name);
            if (namedMethods == null) {
                namedMethods = new LinkedList();
                classMethodCache.put(name, namedMethods);
            }
            namedMethods.add(method);
        }
        return classMethodCache;
    }

    private static Object[] convertListToArray(Object userValue, Class<?> localType) {
        Class<?> arrayType = localType.getComponentType();
        List l = BeanAdapter.coerce(userValue, List.class);
        return l.toArray((Object[])Array.newInstance(arrayType, 0));
    }

    private static Object getDefaultValue(Class clazz) {
        return defaultsMap.get(clazz);
    }

    static {
        defaultsMap.put(Byte.TYPE, (byte)0);
        defaultsMap.put(Short.TYPE, (short)0);
        defaultsMap.put(Integer.TYPE, 0);
        defaultsMap.put(Long.TYPE, 0L);
        defaultsMap.put(Integer.TYPE, 0);
        defaultsMap.put(Float.TYPE, Float.valueOf(0.0f));
        defaultsMap.put(Double.TYPE, 0.0);
        defaultsMap.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultsMap.put(Boolean.TYPE, false);
        defaultsMap.put(Object.class, null);
    }

    private static class AnnotationValue {
        private final String name;
        private final String defaultValue;
        private final Class<?> type;

        public AnnotationValue(String name, String defaultValue, Class<?> type) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Class<?> getType() {
            return this.type;
        }
    }

    private static class Getter
    extends Property {
        public Getter(Method m, Class<?> t) {
            super(m, t);
        }

        @Override
        public void invoke(Object obj, Object argStr) throws Exception {
            Collection to = (Collection)MethodUtil.invoke(this.method, obj, new Object[0]);
            if (argStr instanceof Collection) {
                Collection from = (Collection)argStr;
                to.addAll(from);
            } else {
                to.add(argStr);
            }
        }
    }

    private static class Setter
    extends Property {
        public Setter(Method m, Class<?> t) {
            super(m, t);
        }

        @Override
        public void invoke(Object obj, Object argStr) throws Exception {
            Object[] arg = new Object[]{BeanAdapter.coerce(argStr, this.type)};
            MethodUtil.invoke(this.method, obj, arg);
        }
    }

    private static abstract class Property {
        protected final Method method;
        protected final Class<?> type;

        public Property(Method m, Class<?> t) {
            this.method = m;
            this.type = t;
        }

        public Class<?> getType() {
            return this.type;
        }

        public abstract void invoke(Object var1, Object var2) throws Exception;
    }

    private static class ArrayListWrapper<T>
    extends ArrayList<T> {
        private ArrayListWrapper() {
        }
    }
}

