/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.DisposerRecord;
import com.sun.javafx.font.FontConstants;
import com.sun.javafx.font.FontFileReader;
import com.sun.javafx.font.FontFileWriter;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.OpenTypeGlyphMapper;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.PrismFontStrike;
import com.sun.javafx.font.PrismMetrics;
import com.sun.javafx.font.WoffDecoder;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class PrismFontFile
implements FontResource,
FontConstants {
    private int fontInstallationType = -1;
    String familyName;
    String fullName;
    String psName;
    String localeFamilyName;
    String localeFullName;
    String styleName;
    String localeStyleName;
    String filename;
    int filesize;
    FontFileReader filereader;
    int numGlyphs = -1;
    short indexToLocFormat;
    int fontIndex;
    boolean isCFF;
    boolean isEmbedded = false;
    boolean isCopy = false;
    boolean isTracked = false;
    boolean isDecoded = false;
    boolean isRegistered = true;
    Map<FontStrikeDesc, WeakReference<PrismFontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<PrismFontStrike>>();
    HashMap<Integer, int[]> bbCache = null;
    static final int[] EMPTY_BOUNDS = new int[4];
    private Object peer;
    int directoryCount = 1;
    int numTables;
    DirectoryEntry[] tableDirectory;
    private static final int fsSelectionItalicBit = 1;
    private static final int fsSelectionBoldBit = 32;
    private static final int MACSTYLE_BOLD_BIT = 1;
    private static final int MACSTYLE_ITALIC_BIT = 2;
    private boolean isBold;
    private boolean isItalic;
    private float upem;
    private float ascent;
    private float descent;
    private float linegap;
    private int numHMetrics;
    public static final int MAC_PLATFORM_ID = 1;
    public static final int MACROMAN_SPECIFIC_ID = 0;
    public static final int MACROMAN_ENGLISH_LANG = 0;
    public static final int MS_PLATFORM_ID = 3;
    public static final short MS_ENGLISH_LOCALE_ID = 1033;
    public static final int FAMILY_NAME_ID = 1;
    public static final int STYLE_NAME_ID = 2;
    public static final int FULL_NAME_ID = 4;
    public static final int PS_NAME_ID = 6;
    private static Map<String, Short> lcidMap;
    static short nameLocaleID;
    private OpenTypeGlyphMapper mapper = null;
    char[] advanceWidths = null;
    private float[] styleMetrics;

    protected PrismFontFile(String name, String filename, int fIndex, boolean register, boolean embedded, boolean copy, boolean tracked) throws Exception {
        this.filename = filename;
        this.isRegistered = register;
        this.isEmbedded = embedded;
        this.isCopy = copy;
        this.isTracked = tracked;
        this.init(name, fIndex);
    }

    WeakReference<PrismFontFile> createFileDisposer(PrismFontFactory factory) {
        FileDisposer disposer = new FileDisposer(this.filename, this.isTracked);
        WeakReference ref = Disposer.addRecord(this, disposer);
        disposer.setFactory(factory, ref);
        return ref;
    }

    void setIsDecoded(boolean decoded) {
        this.isDecoded = decoded;
    }

    protected synchronized void disposeOnShutdown() {
        if (this.isCopy || this.isDecoded) {
            AccessController.doPrivileged(() -> {
                try {
                    boolean delOK = new File(this.filename).delete();
                    if (!delOK && PrismFontFactory.debugFonts) {
                        System.err.println("Temp file not deleted : " + this.filename);
                    }
                    this.isDecoded = false;
                    this.isCopy = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            });
            if (PrismFontFactory.debugFonts) {
                System.err.println("Temp file deleted: " + this.filename);
            }
        }
    }

    @Override
    public int getDefaultAAMode() {
        return 0;
    }

    public boolean isInstalledFont() {
        if (this.fontInstallationType == -1) {
            PrismFontFactory factory = PrismFontFactory.getFontFactory();
            this.fontInstallationType = factory.isInstalledFont(this.filename) ? 1 : 0;
        }
        return this.fontInstallationType > 0;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    protected int getFileSize() {
        return this.filesize;
    }

    protected int getFontIndex() {
        return this.fontIndex;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getPSName() {
        if (this.psName == null) {
            this.psName = this.fullName;
        }
        return this.psName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getStyleName() {
        return this.styleName;
    }

    @Override
    public String getLocaleFullName() {
        return this.localeFullName;
    }

    @Override
    public String getLocaleFamilyName() {
        return this.localeFamilyName;
    }

    @Override
    public String getLocaleStyleName() {
        return this.localeStyleName;
    }

    @Override
    public int getFeatures() {
        return -1;
    }

    public Map getStrikeMap() {
        return this.strikeMap;
    }

    protected abstract PrismFontStrike createStrike(float var1, BaseTransform var2, int var3, FontStrikeDesc var4);

    @Override
    public FontStrike getStrike(float size, BaseTransform transform, int aaMode) {
        FontStrikeDesc desc = new FontStrikeDesc(size, transform, aaMode);
        WeakReference<PrismFontStrike> ref = this.strikeMap.get(desc);
        PrismFontStrike strike = null;
        if (ref != null) {
            strike = (PrismFontStrike)ref.get();
        }
        if (strike == null) {
            strike = this.createStrike(size, transform, aaMode, desc);
            DisposerRecord disposer = strike.getDisposer();
            ref = disposer != null ? Disposer.addRecord(strike, disposer) : new WeakReference<PrismFontStrike>(strike);
            this.strikeMap.put(desc, ref);
        }
        return strike;
    }

    protected abstract int[] createGlyphBoundingBox(int var1);

    @Override
    public float[] getGlyphBoundingBox(int gc, float size, float[] retArr) {
        int[] bb;
        if (retArr == null || retArr.length < 4) {
            retArr = new float[4];
        }
        if (gc >= this.getNumGlyphs()) {
            retArr[3] = 0.0f;
            retArr[2] = 0.0f;
            retArr[1] = 0.0f;
            retArr[0] = 0.0f;
            return retArr;
        }
        if (this.bbCache == null) {
            this.bbCache = new HashMap();
        }
        if ((bb = this.bbCache.get(gc)) == null) {
            bb = this.createGlyphBoundingBox(gc);
            if (bb == null) {
                bb = EMPTY_BOUNDS;
            }
            this.bbCache.put(gc, bb);
        }
        float scale = size / (float)this.getUnitsPerEm();
        retArr[0] = (float)bb[0] * scale;
        retArr[1] = (float)bb[1] * scale;
        retArr[2] = (float)bb[2] * scale;
        retArr[3] = (float)bb[3] * scale;
        return retArr;
    }

    int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            FontFileReader.Buffer buffer = this.readTable(1835104368);
            this.numGlyphs = buffer.getChar(4);
        }
        return this.numGlyphs;
    }

    protected boolean isCFF() {
        return this.isCFF;
    }

    @Override
    public Object getPeer() {
        return this.peer;
    }

    @Override
    public void setPeer(Object peer) {
        this.peer = peer;
    }

    int getTableLength(int tag) {
        int len = 0;
        DirectoryEntry tagDE = this.getDirectoryEntry(tag);
        if (tagDE != null) {
            len = tagDE.length;
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized FontFileReader.Buffer readTable(int tag) {
        FontFileReader.Buffer buffer = null;
        boolean openedFile = false;
        try {
            openedFile = this.filereader.openFile();
            DirectoryEntry tagDE = this.getDirectoryEntry(tag);
            if (tagDE != null) {
                buffer = this.filereader.readBlock(tagDE.offset, tagDE.length);
            }
        }
        catch (Exception e) {
            if (PrismFontFactory.debugFonts) {
                e.printStackTrace();
            }
        }
        finally {
            if (openedFile) {
                try {
                    this.filereader.closeFile();
                }
                catch (Exception exception) {}
            }
        }
        return buffer;
    }

    public int getFontCount() {
        return this.directoryCount;
    }

    DirectoryEntry getDirectoryEntry(int tag) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != tag) continue;
            return this.tableDirectory[i];
        }
        return null;
    }

    private void init(String name, int fIndex) throws Exception {
        this.filereader = new FontFileReader(this.filename);
        FontFileWriter decoder = null;
        try {
            if (!this.filereader.openFile()) {
                throw new FileNotFoundException("Unable to create FontResource for file " + this.filename);
            }
            FontFileReader.Buffer buffer = this.filereader.readBlock(0, 12);
            int sfntTag = buffer.getInt();
            if (sfntTag == 2001684038) {
                decoder = new WoffDecoder();
                File file = decoder.openFile();
                ((WoffDecoder)decoder).decode(this.filereader);
                decoder.closeFile();
                this.filereader.closeFile();
                this.filereader = new FontFileReader(file.getPath());
                if (!this.filereader.openFile()) {
                    throw new FileNotFoundException("Unable to create FontResource for file " + this.filename);
                }
                buffer = this.filereader.readBlock(0, 12);
                sfntTag = buffer.getInt();
            }
            this.filesize = (int)this.filereader.getLength();
            int headerOffset = 0;
            if (sfntTag == 1953784678) {
                buffer.getInt();
                this.directoryCount = buffer.getInt();
                if (fIndex >= this.directoryCount) {
                    throw new Exception("Bad collection index");
                }
                this.fontIndex = fIndex;
                buffer = this.filereader.readBlock(12 + 4 * fIndex, 4);
                headerOffset = buffer.getInt();
                buffer = this.filereader.readBlock(headerOffset, 4);
                sfntTag = buffer.getInt();
            }
            switch (sfntTag) {
                case 65536: 
                case 1953658213: {
                    break;
                }
                case 0x4F54544F: {
                    this.isCFF = true;
                    break;
                }
                default: {
                    throw new Exception("Unsupported sfnt " + this.filename);
                }
            }
            buffer = this.filereader.readBlock(headerOffset + 4, 2);
            this.numTables = buffer.getShort();
            int directoryOffset = headerOffset + 12;
            FontFileReader.Buffer ibuffer = this.filereader.readBlock(directoryOffset, this.numTables * 16);
            this.tableDirectory = new DirectoryEntry[this.numTables];
            for (int i = 0; i < this.numTables; ++i) {
                DirectoryEntry table;
                this.tableDirectory[i] = table = new DirectoryEntry();
                table.tag = ibuffer.getInt();
                ibuffer.skip(4);
                table.offset = ibuffer.getInt();
                table.length = ibuffer.getInt();
                if (table.offset + table.length <= this.filesize) continue;
                throw new Exception("bad table, tag=" + table.tag);
            }
            DirectoryEntry headDE = this.getDirectoryEntry(1751474532);
            FontFileReader.Buffer headTable = this.filereader.readBlock(headDE.offset, headDE.length);
            this.upem = headTable.getShort(18) & 0xFFFF;
            if (!(16.0f <= this.upem) || !(this.upem <= 16384.0f)) {
                this.upem = 2048.0f;
            }
            this.indexToLocFormat = headTable.getShort(50);
            if (this.indexToLocFormat < 0 || this.indexToLocFormat > 1) {
                throw new Exception("Bad indexToLocFormat");
            }
            FontFileReader.Buffer hhea = this.readTable(1751672161);
            if (hhea == null) {
                this.numHMetrics = -1;
            } else {
                this.ascent = -((float)hhea.getShort(4));
                this.descent = -((float)hhea.getShort(6));
                this.linegap = hhea.getShort(8);
                this.numHMetrics = hhea.getChar(34) & 0xFFFF;
                int hmtxEntries = this.getTableLength(1752003704) >> 2;
                if (this.numHMetrics > hmtxEntries) {
                    this.numHMetrics = hmtxEntries;
                }
            }
            this.getNumGlyphs();
            this.setStyle();
            this.checkCMAP();
            this.initNames();
            if (this.familyName == null || this.fullName == null) {
                String fontName;
                String string = fontName = name != null ? name : "";
                if (this.fullName == null) {
                    String string2 = this.fullName = this.familyName != null ? this.familyName : fontName;
                }
                if (this.familyName == null) {
                    this.familyName = this.fullName != null ? this.fullName : fontName;
                }
                throw new Exception("Font name not found.");
            }
            if (decoder != null) {
                this.isDecoded = true;
                this.filename = this.filereader.getFilename();
                PrismFontFactory.getFontFactory().addDecodedFont(this);
            }
        }
        catch (Exception e) {
            if (decoder != null) {
                decoder.deleteFile();
            }
            throw e;
        }
        finally {
            this.filereader.closeFile();
        }
    }

    private void setStyle() {
        DirectoryEntry os2_DE = this.getDirectoryEntry(1330851634);
        if (os2_DE != null) {
            FontFileReader.Buffer os_2Table = this.filereader.readBlock(os2_DE.offset, os2_DE.length);
            int fsSelection = os_2Table.getChar(62) & 0xFFFF;
            this.isItalic = (fsSelection & 1) != 0;
            this.isBold = (fsSelection & 0x20) != 0;
        } else {
            DirectoryEntry headDE = this.getDirectoryEntry(1751474532);
            FontFileReader.Buffer headTable = this.filereader.readBlock(headDE.offset, headDE.length);
            short macStyleBits = headTable.getShort(44);
            this.isItalic = (macStyleBits & 2) != 0;
            this.isBold = (macStyleBits & 1) != 0;
        }
    }

    @Override
    public boolean isBold() {
        return this.isBold;
    }

    @Override
    public boolean isItalic() {
        return this.isItalic;
    }

    public boolean isDecoded() {
        return this.isDecoded;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    @Override
    public boolean isEmbeddedFont() {
        return this.isEmbedded;
    }

    public int getUnitsPerEm() {
        return (int)this.upem;
    }

    public short getIndexToLocFormat() {
        return this.indexToLocFormat;
    }

    public int getNumHMetrics() {
        return this.numHMetrics;
    }

    void initNames() throws Exception {
        byte[] name = new byte[256];
        DirectoryEntry nameDE = this.getDirectoryEntry(1851878757);
        FontFileReader.Buffer buffer = this.filereader.readBlock(nameDE.offset, nameDE.length);
        buffer.skip(2);
        int numRecords = buffer.getShort();
        int stringPtr = buffer.getShort() & 0xFFFF;
        for (int i = 0; i < numRecords; ++i) {
            short platformID = buffer.getShort();
            if (platformID != 3 && platformID != 1) {
                buffer.skip(10);
                continue;
            }
            short encodingID = buffer.getShort();
            if (platformID == 3 && encodingID > 1 || platformID == 1 && encodingID != 0) {
                buffer.skip(8);
                continue;
            }
            short langID = buffer.getShort();
            if (platformID == 1 && langID != 0) {
                buffer.skip(6);
                continue;
            }
            short nameID = buffer.getShort();
            int nameLen = buffer.getShort() & 0xFFFF;
            int namePtr = (buffer.getShort() & 0xFFFF) + stringPtr;
            String tmpName = null;
            switch (nameID) {
                case 1: {
                    if (this.familyName != null && langID != 1033 && langID != nameLocaleID) break;
                    buffer.get(namePtr, name, 0, nameLen);
                    String enc = platformID == 1 ? "US-ASCII" : "UTF-16BE";
                    tmpName = new String(name, 0, nameLen, enc);
                    if (this.familyName == null || langID == 1033) {
                        this.familyName = tmpName;
                    }
                    if (langID != nameLocaleID) break;
                    this.localeFamilyName = tmpName;
                    break;
                }
                case 4: {
                    if (this.fullName != null && langID != 1033 && langID != nameLocaleID) break;
                    buffer.get(namePtr, name, 0, nameLen);
                    String enc = platformID == 1 ? "US-ASCII" : "UTF-16BE";
                    tmpName = new String(name, 0, nameLen, enc);
                    if (this.fullName == null || langID == 1033) {
                        this.fullName = tmpName;
                    }
                    if (langID != nameLocaleID) break;
                    this.localeFullName = tmpName;
                    break;
                }
                case 6: {
                    if (this.psName != null) break;
                    buffer.get(namePtr, name, 0, nameLen);
                    String enc = platformID == 1 ? "US-ASCII" : "UTF-16BE";
                    this.psName = new String(name, 0, nameLen, enc);
                    break;
                }
                case 2: {
                    if (this.styleName != null && langID != 1033 && langID != nameLocaleID) break;
                    buffer.get(namePtr, name, 0, nameLen);
                    String enc = platformID == 1 ? "US-ASCII" : "UTF-16BE";
                    tmpName = new String(name, 0, nameLen, enc);
                    if (this.styleName == null || langID == 1033) {
                        this.styleName = tmpName;
                    }
                    if (langID != nameLocaleID) break;
                    this.localeStyleName = tmpName;
                    break;
                }
            }
            if (this.localeFamilyName == null) {
                this.localeFamilyName = this.familyName;
            }
            if (this.localeFullName == null) {
                this.localeFullName = this.fullName;
            }
            if (this.localeStyleName != null) continue;
            this.localeStyleName = this.styleName;
        }
    }

    private void checkCMAP() throws Exception {
        DirectoryEntry cmapDE = this.getDirectoryEntry(1668112752);
        if (cmapDE != null) {
            if (cmapDE.length < 4) {
                throw new Exception("Invalid cmap table length");
            }
            FontFileReader.Buffer cmapTableHeader = this.filereader.readBlock(cmapDE.offset, 4);
            short version = cmapTableHeader.getShort();
            int numberSubTables = cmapTableHeader.getShort();
            int indexLength = numberSubTables * 8;
            if (numberSubTables <= 0 || cmapDE.length < indexLength + 4) {
                throw new Exception("Invalid cmap subtables count");
            }
            FontFileReader.Buffer cmapTableIndex = this.filereader.readBlock(cmapDE.offset + 4, indexLength);
            for (int i = 0; i < numberSubTables; ++i) {
                short platformID = cmapTableIndex.getShort();
                short encodingID = cmapTableIndex.getShort();
                int offset = cmapTableIndex.getInt();
                if (offset >= 0 && offset < cmapDE.length) continue;
                throw new Exception("Invalid cmap subtable offset");
            }
        }
    }

    private static void addLCIDMapEntry(Map<String, Short> map, String key, short value) {
        map.put(key, value);
    }

    private static synchronized void createLCIDMap() {
        if (lcidMap != null) {
            return;
        }
        HashMap<String, Short> map = new HashMap<String, Short>(200);
        PrismFontFile.addLCIDMapEntry(map, "ar", (short)1025);
        PrismFontFile.addLCIDMapEntry(map, "bg", (short)1026);
        PrismFontFile.addLCIDMapEntry(map, "ca", (short)1027);
        PrismFontFile.addLCIDMapEntry(map, "zh", (short)1028);
        PrismFontFile.addLCIDMapEntry(map, "cs", (short)1029);
        PrismFontFile.addLCIDMapEntry(map, "da", (short)1030);
        PrismFontFile.addLCIDMapEntry(map, "de", (short)1031);
        PrismFontFile.addLCIDMapEntry(map, "el", (short)1032);
        PrismFontFile.addLCIDMapEntry(map, "es", (short)1034);
        PrismFontFile.addLCIDMapEntry(map, "fi", (short)1035);
        PrismFontFile.addLCIDMapEntry(map, "fr", (short)1036);
        PrismFontFile.addLCIDMapEntry(map, "iw", (short)1037);
        PrismFontFile.addLCIDMapEntry(map, "hu", (short)1038);
        PrismFontFile.addLCIDMapEntry(map, "is", (short)1039);
        PrismFontFile.addLCIDMapEntry(map, "it", (short)1040);
        PrismFontFile.addLCIDMapEntry(map, "ja", (short)1041);
        PrismFontFile.addLCIDMapEntry(map, "ko", (short)1042);
        PrismFontFile.addLCIDMapEntry(map, "nl", (short)1043);
        PrismFontFile.addLCIDMapEntry(map, "no", (short)1044);
        PrismFontFile.addLCIDMapEntry(map, "pl", (short)1045);
        PrismFontFile.addLCIDMapEntry(map, "pt", (short)1046);
        PrismFontFile.addLCIDMapEntry(map, "rm", (short)1047);
        PrismFontFile.addLCIDMapEntry(map, "ro", (short)1048);
        PrismFontFile.addLCIDMapEntry(map, "ru", (short)1049);
        PrismFontFile.addLCIDMapEntry(map, "hr", (short)1050);
        PrismFontFile.addLCIDMapEntry(map, "sk", (short)1051);
        PrismFontFile.addLCIDMapEntry(map, "sq", (short)1052);
        PrismFontFile.addLCIDMapEntry(map, "sv", (short)1053);
        PrismFontFile.addLCIDMapEntry(map, "th", (short)1054);
        PrismFontFile.addLCIDMapEntry(map, "tr", (short)1055);
        PrismFontFile.addLCIDMapEntry(map, "ur", (short)1056);
        PrismFontFile.addLCIDMapEntry(map, "in", (short)1057);
        PrismFontFile.addLCIDMapEntry(map, "uk", (short)1058);
        PrismFontFile.addLCIDMapEntry(map, "be", (short)1059);
        PrismFontFile.addLCIDMapEntry(map, "sl", (short)1060);
        PrismFontFile.addLCIDMapEntry(map, "et", (short)1061);
        PrismFontFile.addLCIDMapEntry(map, "lv", (short)1062);
        PrismFontFile.addLCIDMapEntry(map, "lt", (short)1063);
        PrismFontFile.addLCIDMapEntry(map, "fa", (short)1065);
        PrismFontFile.addLCIDMapEntry(map, "vi", (short)1066);
        PrismFontFile.addLCIDMapEntry(map, "hy", (short)1067);
        PrismFontFile.addLCIDMapEntry(map, "eu", (short)1069);
        PrismFontFile.addLCIDMapEntry(map, "mk", (short)1071);
        PrismFontFile.addLCIDMapEntry(map, "tn", (short)1074);
        PrismFontFile.addLCIDMapEntry(map, "xh", (short)1076);
        PrismFontFile.addLCIDMapEntry(map, "zu", (short)1077);
        PrismFontFile.addLCIDMapEntry(map, "af", (short)1078);
        PrismFontFile.addLCIDMapEntry(map, "ka", (short)1079);
        PrismFontFile.addLCIDMapEntry(map, "fo", (short)1080);
        PrismFontFile.addLCIDMapEntry(map, "hi", (short)1081);
        PrismFontFile.addLCIDMapEntry(map, "mt", (short)1082);
        PrismFontFile.addLCIDMapEntry(map, "se", (short)1083);
        PrismFontFile.addLCIDMapEntry(map, "gd", (short)1084);
        PrismFontFile.addLCIDMapEntry(map, "ms", (short)1086);
        PrismFontFile.addLCIDMapEntry(map, "kk", (short)1087);
        PrismFontFile.addLCIDMapEntry(map, "ky", (short)1088);
        PrismFontFile.addLCIDMapEntry(map, "sw", (short)1089);
        PrismFontFile.addLCIDMapEntry(map, "tt", (short)1092);
        PrismFontFile.addLCIDMapEntry(map, "bn", (short)1093);
        PrismFontFile.addLCIDMapEntry(map, "pa", (short)1094);
        PrismFontFile.addLCIDMapEntry(map, "gu", (short)1095);
        PrismFontFile.addLCIDMapEntry(map, "ta", (short)1097);
        PrismFontFile.addLCIDMapEntry(map, "te", (short)1098);
        PrismFontFile.addLCIDMapEntry(map, "kn", (short)1099);
        PrismFontFile.addLCIDMapEntry(map, "ml", (short)1100);
        PrismFontFile.addLCIDMapEntry(map, "mr", (short)1102);
        PrismFontFile.addLCIDMapEntry(map, "sa", (short)1103);
        PrismFontFile.addLCIDMapEntry(map, "mn", (short)1104);
        PrismFontFile.addLCIDMapEntry(map, "cy", (short)1106);
        PrismFontFile.addLCIDMapEntry(map, "gl", (short)1110);
        PrismFontFile.addLCIDMapEntry(map, "dv", (short)1125);
        PrismFontFile.addLCIDMapEntry(map, "qu", (short)1131);
        PrismFontFile.addLCIDMapEntry(map, "mi", (short)1153);
        PrismFontFile.addLCIDMapEntry(map, "ar_IQ", (short)2049);
        PrismFontFile.addLCIDMapEntry(map, "zh_CN", (short)2052);
        PrismFontFile.addLCIDMapEntry(map, "de_CH", (short)2055);
        PrismFontFile.addLCIDMapEntry(map, "en_GB", (short)2057);
        PrismFontFile.addLCIDMapEntry(map, "es_MX", (short)2058);
        PrismFontFile.addLCIDMapEntry(map, "fr_BE", (short)2060);
        PrismFontFile.addLCIDMapEntry(map, "it_CH", (short)2064);
        PrismFontFile.addLCIDMapEntry(map, "nl_BE", (short)2067);
        PrismFontFile.addLCIDMapEntry(map, "no_NO_NY", (short)2068);
        PrismFontFile.addLCIDMapEntry(map, "pt_PT", (short)2070);
        PrismFontFile.addLCIDMapEntry(map, "ro_MD", (short)2072);
        PrismFontFile.addLCIDMapEntry(map, "ru_MD", (short)2073);
        PrismFontFile.addLCIDMapEntry(map, "sr_CS", (short)2074);
        PrismFontFile.addLCIDMapEntry(map, "sv_FI", (short)2077);
        PrismFontFile.addLCIDMapEntry(map, "az_AZ", (short)2092);
        PrismFontFile.addLCIDMapEntry(map, "se_SE", (short)2107);
        PrismFontFile.addLCIDMapEntry(map, "ga_IE", (short)2108);
        PrismFontFile.addLCIDMapEntry(map, "ms_BN", (short)2110);
        PrismFontFile.addLCIDMapEntry(map, "uz_UZ", (short)2115);
        PrismFontFile.addLCIDMapEntry(map, "qu_EC", (short)2155);
        PrismFontFile.addLCIDMapEntry(map, "ar_EG", (short)3073);
        PrismFontFile.addLCIDMapEntry(map, "zh_HK", (short)3076);
        PrismFontFile.addLCIDMapEntry(map, "de_AT", (short)3079);
        PrismFontFile.addLCIDMapEntry(map, "en_AU", (short)3081);
        PrismFontFile.addLCIDMapEntry(map, "fr_CA", (short)3084);
        PrismFontFile.addLCIDMapEntry(map, "sr_CS", (short)3098);
        PrismFontFile.addLCIDMapEntry(map, "se_FI", (short)3131);
        PrismFontFile.addLCIDMapEntry(map, "qu_PE", (short)3179);
        PrismFontFile.addLCIDMapEntry(map, "ar_LY", (short)4097);
        PrismFontFile.addLCIDMapEntry(map, "zh_SG", (short)4100);
        PrismFontFile.addLCIDMapEntry(map, "de_LU", (short)4103);
        PrismFontFile.addLCIDMapEntry(map, "en_CA", (short)4105);
        PrismFontFile.addLCIDMapEntry(map, "es_GT", (short)4106);
        PrismFontFile.addLCIDMapEntry(map, "fr_CH", (short)4108);
        PrismFontFile.addLCIDMapEntry(map, "hr_BA", (short)4122);
        PrismFontFile.addLCIDMapEntry(map, "ar_DZ", (short)5121);
        PrismFontFile.addLCIDMapEntry(map, "zh_MO", (short)5124);
        PrismFontFile.addLCIDMapEntry(map, "de_LI", (short)5127);
        PrismFontFile.addLCIDMapEntry(map, "en_NZ", (short)5129);
        PrismFontFile.addLCIDMapEntry(map, "es_CR", (short)5130);
        PrismFontFile.addLCIDMapEntry(map, "fr_LU", (short)5132);
        PrismFontFile.addLCIDMapEntry(map, "bs_BA", (short)5146);
        PrismFontFile.addLCIDMapEntry(map, "ar_MA", (short)6145);
        PrismFontFile.addLCIDMapEntry(map, "en_IE", (short)6153);
        PrismFontFile.addLCIDMapEntry(map, "es_PA", (short)6154);
        PrismFontFile.addLCIDMapEntry(map, "fr_MC", (short)6156);
        PrismFontFile.addLCIDMapEntry(map, "sr_BA", (short)6170);
        PrismFontFile.addLCIDMapEntry(map, "ar_TN", (short)7169);
        PrismFontFile.addLCIDMapEntry(map, "en_ZA", (short)7177);
        PrismFontFile.addLCIDMapEntry(map, "es_DO", (short)7178);
        PrismFontFile.addLCIDMapEntry(map, "sr_BA", (short)7194);
        PrismFontFile.addLCIDMapEntry(map, "ar_OM", (short)8193);
        PrismFontFile.addLCIDMapEntry(map, "en_JM", (short)8201);
        PrismFontFile.addLCIDMapEntry(map, "es_VE", (short)8202);
        PrismFontFile.addLCIDMapEntry(map, "ar_YE", (short)9217);
        PrismFontFile.addLCIDMapEntry(map, "es_CO", (short)9226);
        PrismFontFile.addLCIDMapEntry(map, "ar_SY", (short)10241);
        PrismFontFile.addLCIDMapEntry(map, "en_BZ", (short)10249);
        PrismFontFile.addLCIDMapEntry(map, "es_PE", (short)10250);
        PrismFontFile.addLCIDMapEntry(map, "ar_JO", (short)11265);
        PrismFontFile.addLCIDMapEntry(map, "en_TT", (short)11273);
        PrismFontFile.addLCIDMapEntry(map, "es_AR", (short)11274);
        PrismFontFile.addLCIDMapEntry(map, "ar_LB", (short)12289);
        PrismFontFile.addLCIDMapEntry(map, "en_ZW", (short)12297);
        PrismFontFile.addLCIDMapEntry(map, "es_EC", (short)12298);
        PrismFontFile.addLCIDMapEntry(map, "ar_KW", (short)13313);
        PrismFontFile.addLCIDMapEntry(map, "en_PH", (short)13321);
        PrismFontFile.addLCIDMapEntry(map, "es_CL", (short)13322);
        PrismFontFile.addLCIDMapEntry(map, "ar_AE", (short)14337);
        PrismFontFile.addLCIDMapEntry(map, "es_UY", (short)14346);
        PrismFontFile.addLCIDMapEntry(map, "ar_BH", (short)15361);
        PrismFontFile.addLCIDMapEntry(map, "es_PY", (short)15370);
        PrismFontFile.addLCIDMapEntry(map, "ar_QA", (short)16385);
        PrismFontFile.addLCIDMapEntry(map, "es_BO", (short)16394);
        PrismFontFile.addLCIDMapEntry(map, "es_SV", (short)17418);
        PrismFontFile.addLCIDMapEntry(map, "es_HN", (short)18442);
        PrismFontFile.addLCIDMapEntry(map, "es_NI", (short)19466);
        PrismFontFile.addLCIDMapEntry(map, "es_PR", (short)20490);
        lcidMap = map;
    }

    private static short getLCIDFromLocale(Locale locale) {
        if (locale.equals(Locale.US) || locale.getLanguage().equals("en")) {
            return 1033;
        }
        if (lcidMap == null) {
            PrismFontFile.createLCIDMap();
        }
        String key = locale.toString();
        while (!key.isEmpty()) {
            Short lcidObject = lcidMap.get(key);
            if (lcidObject != null) {
                return lcidObject;
            }
            int pos = key.lastIndexOf(95);
            if (pos < 1) {
                return 1033;
            }
            key = key.substring(0, pos);
        }
        return 1033;
    }

    private static short getSystemLCID() {
        if (PrismFontFactory.isWindows) {
            return PrismFontFactory.getSystemLCID();
        }
        return PrismFontFile.getLCIDFromLocale(Locale.getDefault());
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new OpenTypeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public FontStrike getStrike(float size, BaseTransform transform) {
        return this.getStrike(size, transform, this.getDefaultAAMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAdvance(int glyphCode, float ptSize) {
        if (glyphCode == 65535) {
            return 0.0f;
        }
        if (this.advanceWidths == null && this.numHMetrics > 0) {
            PrismFontFile prismFontFile = this;
            synchronized (prismFontFile) {
                FontFileReader.Buffer hmtx = this.readTable(1752003704);
                if (hmtx == null) {
                    this.numHMetrics = -1;
                    return 0.0f;
                }
                char[] aw = new char[this.numHMetrics];
                for (int i = 0; i < this.numHMetrics; ++i) {
                    aw[i] = hmtx.getChar(i * 4);
                }
                this.advanceWidths = aw;
            }
        }
        if (this.numHMetrics > 0) {
            char cadv = glyphCode < this.numHMetrics ? this.advanceWidths[glyphCode] : this.advanceWidths[this.numHMetrics - 1];
            return (float)(cadv & 0xFFFF) * ptSize / this.upem;
        }
        return 0.0f;
    }

    public PrismMetrics getFontMetrics(float ptSize) {
        return new PrismMetrics(this.ascent * ptSize / this.upem, this.descent * ptSize / this.upem, this.linegap * ptSize / this.upem, this, ptSize);
    }

    float[] getStyleMetrics(float ptSize) {
        if (this.styleMetrics == null) {
            FontFileReader.Buffer postTable;
            int length;
            float[] smetrics = new float[9];
            FontFileReader.Buffer os_2 = this.readTable(1330851634);
            int n = length = os_2 != null ? os_2.capacity() : 0;
            if (length >= 30) {
                smetrics[5] = (float)os_2.getShort(26) / this.upem;
                smetrics[6] = (float)(-os_2.getShort(28)) / this.upem;
            } else {
                smetrics[5] = 0.05f;
                smetrics[6] = -0.4f;
            }
            if (length >= 74) {
                smetrics[2] = (float)(-os_2.getShort(68)) / this.upem;
                smetrics[3] = (float)(-os_2.getShort(70)) / this.upem;
                smetrics[4] = (float)os_2.getShort(72) / this.upem;
            } else {
                smetrics[2] = this.ascent / this.upem;
                smetrics[3] = this.descent / this.upem;
                smetrics[4] = this.linegap / this.upem;
            }
            if (length >= 90) {
                smetrics[0] = (float)os_2.getShort(86) / this.upem;
                smetrics[1] = os_2.getShort(88);
                smetrics[1] = (double)(smetrics[1] / this.ascent) < 0.5 ? 0.0f : smetrics[1] / this.upem;
            }
            if (smetrics[0] == 0.0f || smetrics[1] == 0.0f) {
                RectBounds fbds;
                int gc;
                FontStrike strike = this.getStrike(ptSize, BaseTransform.IDENTITY_TRANSFORM);
                CharToGlyphMapper mapper = this.getGlyphMapper();
                int missingGlyph = mapper.getMissingGlyphCode();
                if (smetrics[0] == 0.0f) {
                    gc = mapper.charToGlyph('x');
                    if (gc != missingGlyph) {
                        fbds = strike.getGlyph(gc).getBBox();
                        smetrics[0] = fbds.getHeight() / ptSize;
                    } else {
                        smetrics[0] = -this.ascent * 0.6f / this.upem;
                    }
                }
                if (smetrics[1] == 0.0f) {
                    gc = mapper.charToGlyph('H');
                    if (gc != missingGlyph) {
                        fbds = strike.getGlyph(gc).getBBox();
                        smetrics[1] = fbds.getHeight() / ptSize;
                    } else {
                        smetrics[1] = -this.ascent * 0.9f / this.upem;
                    }
                }
            }
            if ((postTable = this.readTable(1886352244)) == null || postTable.capacity() < 12) {
                smetrics[8] = 0.1f;
                smetrics[7] = 0.05f;
            } else {
                smetrics[8] = (float)(-postTable.getShort(8)) / this.upem;
                smetrics[7] = (float)postTable.getShort(10) / this.upem;
            }
            this.styleMetrics = smetrics;
        }
        float[] metrics = new float[9];
        for (int i = 0; i < 9; ++i) {
            metrics[i] = this.styleMetrics[i] * ptSize;
        }
        return metrics;
    }

    byte[] getTableBytes(int tag) {
        FontFileReader.Buffer buffer = this.readTable(tag);
        byte[] table = null;
        if (buffer != null) {
            table = new byte[buffer.capacity()];
            buffer.get(0, table, 0, buffer.capacity());
        }
        return table;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrismFontFile)) {
            return false;
        }
        PrismFontFile other = (PrismFontFile)obj;
        return this.filename.equals(other.filename) && this.fullName.equals(other.fullName);
    }

    public int hashCode() {
        return this.filename.hashCode() + 71 * this.fullName.hashCode();
    }

    static {
        nameLocaleID = PrismFontFile.getSystemLCID();
    }

    static class DirectoryEntry {
        int tag;
        int offset;
        int length;

        DirectoryEntry() {
        }
    }

    static class FileDisposer
    implements DisposerRecord {
        String fileName;
        boolean isTracked;
        PrismFontFactory factory;
        WeakReference<PrismFontFile> refKey;

        public FileDisposer(String fileName, boolean isTracked) {
            this.fileName = fileName;
            this.isTracked = isTracked;
        }

        public void setFactory(PrismFontFactory factory, WeakReference<PrismFontFile> refKey) {
            this.factory = factory;
            this.refKey = refKey;
        }

        @Override
        public synchronized void dispose() {
            if (this.fileName != null) {
                AccessController.doPrivileged(() -> {
                    block5: {
                        try {
                            Object o;
                            File file = new File(this.fileName);
                            int size = (int)file.length();
                            file.delete();
                            if (this.isTracked) {
                                FontFileWriter.FontTracker.getTracker().subBytes(size);
                            }
                            if (this.factory != null && this.refKey != null && (o = this.refKey.get()) == null) {
                                this.factory.removeTmpFont(this.refKey);
                                this.factory = null;
                                this.refKey = null;
                            }
                            if (PrismFontFactory.debugFonts) {
                                System.err.println("FileDisposer=" + this.fileName);
                            }
                        }
                        catch (Exception e) {
                            if (!PrismFontFactory.debugFonts) break block5;
                            e.printStackTrace();
                        }
                    }
                    return null;
                });
                this.fileName = null;
            }
        }
    }
}

