/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.event;

import com.sun.javafx.event.EventDispatchTree;
import javafx.event.Event;
import javafx.event.EventDispatcher;

public final class EventDispatchTreeImpl
implements EventDispatchTree {
    private static final int CAPACITY_GROWTH_FACTOR = 8;
    private static final int NULL_INDEX = -1;
    private EventDispatcher[] dispatchers;
    private int[] nextChildren;
    private int[] nextSiblings;
    private int reservedCount;
    private int rootIndex = -1;
    private int tailFirstIndex = -1;
    private int tailLastIndex = -1;
    private boolean expandTailFirstPath;

    public void reset() {
        for (int i = 0; i < this.reservedCount; ++i) {
            this.dispatchers[i] = null;
        }
        this.reservedCount = 0;
        this.rootIndex = -1;
        this.tailFirstIndex = -1;
        this.tailLastIndex = -1;
    }

    @Override
    public EventDispatchTree createTree() {
        return new EventDispatchTreeImpl();
    }

    @Override
    public EventDispatchTree mergeTree(EventDispatchTree tree) {
        int srcLevelIndex;
        if (this.tailFirstIndex != -1) {
            if (this.rootIndex != -1) {
                this.expandTailFirstPath = true;
                this.expandTail(this.rootIndex);
            } else {
                this.rootIndex = this.tailFirstIndex;
            }
            this.tailFirstIndex = -1;
            this.tailLastIndex = -1;
        }
        EventDispatchTreeImpl treeImpl = (EventDispatchTreeImpl)tree;
        int n = srcLevelIndex = treeImpl.rootIndex != -1 ? treeImpl.rootIndex : treeImpl.tailFirstIndex;
        if (this.rootIndex == -1) {
            this.rootIndex = this.copyTreeLevel(treeImpl, srcLevelIndex);
        } else {
            this.mergeTreeLevel(treeImpl, this.rootIndex, srcLevelIndex);
        }
        return this;
    }

    @Override
    public EventDispatchTree append(EventDispatcher eventDispatcher) {
        this.ensureCapacity(this.reservedCount + 1);
        this.dispatchers[this.reservedCount] = eventDispatcher;
        this.nextSiblings[this.reservedCount] = -1;
        this.nextChildren[this.reservedCount] = -1;
        if (this.tailFirstIndex == -1) {
            this.tailFirstIndex = this.reservedCount;
        } else {
            this.nextChildren[this.tailLastIndex] = this.reservedCount;
        }
        this.tailLastIndex = this.reservedCount++;
        return this;
    }

    @Override
    public EventDispatchTree prepend(EventDispatcher eventDispatcher) {
        this.ensureCapacity(this.reservedCount + 1);
        this.dispatchers[this.reservedCount] = eventDispatcher;
        this.nextSiblings[this.reservedCount] = -1;
        this.nextChildren[this.reservedCount] = this.rootIndex;
        this.rootIndex = this.reservedCount++;
        return this;
    }

    @Override
    public Event dispatchEvent(Event event) {
        if (this.rootIndex == -1) {
            if (this.tailFirstIndex == -1) {
                return event;
            }
            this.rootIndex = this.tailFirstIndex;
            this.tailFirstIndex = -1;
            this.tailLastIndex = -1;
        }
        int savedReservedCount = this.reservedCount;
        int savedRootIndex = this.rootIndex;
        int savedTailFirstIndex = this.tailFirstIndex;
        int savedTailLastIndex = this.tailLastIndex;
        Event returnEvent = null;
        int index = this.rootIndex;
        do {
            this.rootIndex = this.nextChildren[index];
            Event branchReturnEvent = this.dispatchers[index].dispatchEvent(event, this);
            if (branchReturnEvent == null) continue;
            Event event2 = returnEvent = returnEvent != null ? event : branchReturnEvent;
        } while ((index = this.nextSiblings[index]) != -1);
        this.reservedCount = savedReservedCount;
        this.rootIndex = savedRootIndex;
        this.tailFirstIndex = savedTailFirstIndex;
        this.tailLastIndex = savedTailLastIndex;
        return returnEvent;
    }

    public String toString() {
        int levelIndex;
        int n = levelIndex = this.rootIndex != -1 ? this.rootIndex : this.tailFirstIndex;
        if (levelIndex == -1) {
            return "()";
        }
        StringBuilder sb = new StringBuilder();
        this.appendTreeLevel(sb, levelIndex);
        return sb.toString();
    }

    private void ensureCapacity(int size) {
        int newCapacity = size + 8 - 1 & 0xFFFFFFF8;
        if (newCapacity == 0) {
            return;
        }
        if (this.dispatchers == null || this.dispatchers.length < newCapacity) {
            EventDispatcher[] newDispatchers = new EventDispatcher[newCapacity];
            int[] newNextChildren = new int[newCapacity];
            int[] newNextSiblings = new int[newCapacity];
            if (this.reservedCount > 0) {
                System.arraycopy(this.dispatchers, 0, newDispatchers, 0, this.reservedCount);
                System.arraycopy(this.nextChildren, 0, newNextChildren, 0, this.reservedCount);
                System.arraycopy(this.nextSiblings, 0, newNextSiblings, 0, this.reservedCount);
            }
            this.dispatchers = newDispatchers;
            this.nextChildren = newNextChildren;
            this.nextSiblings = newNextSiblings;
        }
    }

    private void expandTail(int levelIndex) {
        int index = levelIndex;
        while (index != -1) {
            if (this.nextChildren[index] != -1) {
                this.expandTail(this.nextChildren[index]);
            } else if (this.expandTailFirstPath) {
                this.nextChildren[index] = this.tailFirstIndex;
                this.expandTailFirstPath = false;
            } else {
                int childLevelIndex;
                this.nextChildren[index] = childLevelIndex = this.copyTreeLevel(this, this.tailFirstIndex);
            }
            index = this.nextSiblings[index];
        }
    }

    private void mergeTreeLevel(EventDispatchTreeImpl srcTree, int dstLevelIndex, int srcLevelIndex) {
        int srcIndex = srcLevelIndex;
        while (srcIndex != -1) {
            EventDispatcher srcDispatcher = srcTree.dispatchers[srcIndex];
            int dstIndex = dstLevelIndex;
            int lastDstIndex = dstLevelIndex;
            while (dstIndex != -1 && srcDispatcher != this.dispatchers[dstIndex]) {
                lastDstIndex = dstIndex;
                dstIndex = this.nextSiblings[dstIndex];
            }
            if (dstIndex == -1) {
                int siblingIndex;
                this.nextSiblings[lastDstIndex] = siblingIndex = this.copySubtree(srcTree, srcIndex);
                this.nextSiblings[siblingIndex] = -1;
            } else {
                int nextDstLevelIndex = this.nextChildren[dstIndex];
                int nextSrcLevelIndex = EventDispatchTreeImpl.getChildIndex(srcTree, srcIndex);
                if (nextDstLevelIndex != -1) {
                    this.mergeTreeLevel(srcTree, nextDstLevelIndex, nextSrcLevelIndex);
                } else {
                    this.nextChildren[dstIndex] = nextDstLevelIndex = this.copyTreeLevel(srcTree, nextSrcLevelIndex);
                }
            }
            srcIndex = srcTree.nextSiblings[srcIndex];
        }
    }

    private int copyTreeLevel(EventDispatchTreeImpl srcTree, int srcLevelIndex) {
        int dstLevelIndex;
        if (srcLevelIndex == -1) {
            return -1;
        }
        int srcIndex = srcLevelIndex;
        int lastDstIndex = dstLevelIndex = this.copySubtree(srcTree, srcIndex);
        srcIndex = srcTree.nextSiblings[srcIndex];
        while (srcIndex != -1) {
            int dstIndex;
            this.nextSiblings[lastDstIndex] = dstIndex = this.copySubtree(srcTree, srcIndex);
            lastDstIndex = dstIndex;
            srcIndex = srcTree.nextSiblings[srcIndex];
        }
        this.nextSiblings[lastDstIndex] = -1;
        return dstLevelIndex;
    }

    private int copySubtree(EventDispatchTreeImpl srcTree, int srcIndex) {
        this.ensureCapacity(this.reservedCount + 1);
        int dstIndex = this.reservedCount++;
        int dstChildLevelIndex = this.copyTreeLevel(srcTree, EventDispatchTreeImpl.getChildIndex(srcTree, srcIndex));
        this.dispatchers[dstIndex] = srcTree.dispatchers[srcIndex];
        this.nextChildren[dstIndex] = dstChildLevelIndex;
        return dstIndex;
    }

    private void appendTreeLevel(StringBuilder sb, int levelIndex) {
        sb.append('(');
        int index = levelIndex;
        this.appendSubtree(sb, index);
        index = this.nextSiblings[index];
        while (index != -1) {
            sb.append(",");
            this.appendSubtree(sb, index);
            index = this.nextSiblings[index];
        }
        sb.append(')');
    }

    private void appendSubtree(StringBuilder sb, int index) {
        sb.append(this.dispatchers[index]);
        int childIndex = EventDispatchTreeImpl.getChildIndex(this, index);
        if (childIndex != -1) {
            sb.append("->");
            this.appendTreeLevel(sb, childIndex);
        }
    }

    private static int getChildIndex(EventDispatchTreeImpl tree, int index) {
        int childIndex = tree.nextChildren[index];
        if (childIndex == -1 && index != tree.tailLastIndex) {
            childIndex = tree.tailFirstIndex;
        }
        return childIndex;
    }
}

