/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.delegate.MenuDelegate;
import com.sun.glass.ui.delegate.MenuItemDelegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Menu {
    private final MenuDelegate delegate;
    private String title;
    private boolean enabled;
    private final List<Object> items = new ArrayList<Object>();
    private EventHandler eventHandler;

    public EventHandler getEventHandler() {
        Application.checkEventThread();
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        Application.checkEventThread();
        this.eventHandler = eventHandler;
    }

    protected Menu(String title) {
        this(title, true);
    }

    protected Menu(String title, boolean enabled) {
        Application.checkEventThread();
        this.title = title;
        this.enabled = enabled;
        this.delegate = PlatformFactory.getPlatformFactory().createMenuDelegate(this);
        if (!this.delegate.createMenu(title, enabled)) {
            throw new RuntimeException("Menu creation error.");
        }
    }

    public String getTitle() {
        Application.checkEventThread();
        return this.title;
    }

    public void setTitle(String title) {
        Application.checkEventThread();
        if (this.delegate.setTitle(title)) {
            this.title = title;
        }
    }

    public boolean isEnabled() {
        Application.checkEventThread();
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        Application.checkEventThread();
        if (this.delegate.setEnabled(enabled)) {
            this.enabled = enabled;
        }
    }

    public boolean setPixels(Pixels pixels) {
        Application.checkEventThread();
        return this.delegate.setPixels(pixels);
    }

    public List<Object> getItems() {
        Application.checkEventThread();
        return Collections.unmodifiableList(this.items);
    }

    public void add(Menu menu) {
        Application.checkEventThread();
        this.insert(menu, this.items.size());
    }

    public void add(MenuItem item) {
        Application.checkEventThread();
        this.insert(item, this.items.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Menu menu, int pos) throws IndexOutOfBoundsException {
        Application.checkEventThread();
        if (menu == null) {
            throw new IllegalArgumentException();
        }
        List<Object> list = this.items;
        synchronized (list) {
            if (pos < 0 || pos > this.items.size()) {
                throw new IndexOutOfBoundsException();
            }
            MenuDelegate menuDelegate = menu.getDelegate();
            if (this.delegate.insert(menuDelegate, pos)) {
                this.items.add(pos, menu);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(MenuItem item, int pos) throws IndexOutOfBoundsException {
        Application.checkEventThread();
        List<Object> list = this.items;
        synchronized (list) {
            MenuItemDelegate itemDelegate;
            if (pos < 0 || pos > this.items.size()) {
                throw new IndexOutOfBoundsException();
            }
            MenuItemDelegate menuItemDelegate = itemDelegate = item != null ? item.getDelegate() : null;
            if (this.delegate.insert(itemDelegate, pos)) {
                this.items.add(pos, item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int pos) throws IndexOutOfBoundsException {
        Application.checkEventThread();
        List<Object> list = this.items;
        synchronized (list) {
            Object item = this.items.get(pos);
            boolean success = false;
            success = item == MenuItem.Separator ? this.delegate.remove((MenuItemDelegate)null, pos) : (item instanceof MenuItem ? this.delegate.remove(((MenuItem)item).getDelegate(), pos) : this.delegate.remove(((Menu)item).getDelegate(), pos));
            if (success) {
                this.items.remove(pos);
            }
        }
    }

    MenuDelegate getDelegate() {
        return this.delegate;
    }

    protected void notifyMenuOpening() {
        if (this.eventHandler != null) {
            this.eventHandler.handleMenuOpening(this, System.nanoTime());
        }
    }

    protected void notifyMenuClosed() {
        if (this.eventHandler != null) {
            this.eventHandler.handleMenuClosed(this, System.nanoTime());
        }
    }

    public static class EventHandler {
        public void handleMenuOpening(Menu menu, long time) {
        }

        public void handleMenuClosed(Menu menu, long time) {
        }
    }
}

