/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.shape.algorithm;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.PointList;
import org.openimaj.math.geometry.shape.algorithm.ProcrustesAnalysis;
import org.openimaj.math.geometry.transforms.TransformUtilities;

public class GeneralisedProcrustesAnalysis {
    private static final int DEFAULT_MAX_ITERS = 10;
    private float threshold;
    private int maxIters;

    public GeneralisedProcrustesAnalysis(float threshold, int maxIters) {
        this.threshold = threshold;
        this.maxIters = maxIters;
    }

    public GeneralisedProcrustesAnalysis(float threshold) {
        this(threshold, 10);
    }

    public PointList align(List<PointList> shapes) {
        return GeneralisedProcrustesAnalysis.alignPoints(shapes, this.threshold, this.maxIters);
    }

    public static PointList alignPoints(List<PointList> inputShapes, float threshold, int maxIters) {
        PointList reference = inputShapes.get(0);
        ArrayList<PointList> workingShapes = new ArrayList<PointList>(inputShapes);
        workingShapes.remove(reference);
        ProcrustesAnalysis referencePa = new ProcrustesAnalysis(reference, true);
        double referenceScaling = referencePa.scaling;
        Point2d referenceCog = referencePa.referenceCog;
        if (workingShapes.size() == 0) {
            return reference;
        }
        PointList mean = GeneralisedProcrustesAnalysis.alignPointsAndAverage(workingShapes, reference, referenceScaling, referenceCog);
        while (ProcrustesAnalysis.computeProcrustesDistance(reference, mean) > threshold && maxIters-- >= 0) {
            reference = mean;
            mean = GeneralisedProcrustesAnalysis.alignPointsAndAverage(inputShapes, reference, referenceScaling, referenceCog);
        }
        return mean;
    }

    protected static PointList alignPointsAndAverage(List<PointList> shapes, PointList reference, double referenceScaling, Point2d referenceCog) {
        ProcrustesAnalysis pa = new ProcrustesAnalysis(reference);
        for (PointList shape : shapes) {
            pa.align(shape);
        }
        PointList mean = PointList.computeMean(shapes);
        Point2d cog = mean.calculateCentroid();
        Matrix trans = TransformUtilities.translateToPointMatrix(cog, referenceCog);
        mean.translate((float)trans.get(0, 2), (float)trans.get(1, 2));
        double scale = ProcrustesAnalysis.computeScale(mean, referenceCog.getX(), referenceCog.getY());
        float sf = (float)(scale / referenceScaling);
        mean.scale(referenceCog, sf);
        return mean;
    }
}

