/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.window;

import java.util.LinkedList;
import org.nlogo.api.ViewInterface;
import org.nlogo.awt.EventQueue;
import org.nlogo.core.Shape;
import org.nlogo.window.LocalViewInterface;

public strictfp class ViewManager {
    private final LinkedList<ViewInterface> views = new LinkedList();
    private final Runnable updateRunnable = new Runnable(){

        @Override
        public void run() {
            ViewManager.this.incrementalUpdateFromEventThread();
        }
    };

    public LocalViewInterface getPrimary() {
        return (LocalViewInterface)this.views.get(0);
    }

    public void setPrimary(LocalViewInterface view2) {
        this.views.remove(view2);
        this.views.addFirst(view2);
    }

    public void setSecondary(ViewInterface view2) {
        this.views.remove(view2);
        this.views.add(1, view2);
    }

    public void add(ViewInterface v) {
        this.views.addLast(v);
    }

    public void remove(ViewInterface v) {
        this.views.remove(v);
    }

    void paintImmediately(boolean force) {
        for (ViewInterface view2 : this.views) {
            view2.paintImmediately(force);
        }
    }

    void framesSkipped() {
        for (ViewInterface v : this.views) {
            v.framesSkipped();
        }
    }

    void incrementalUpdateFromEventThread() {
        for (ViewInterface v : this.views) {
            if (v.isDead() || !v.viewIsVisible()) continue;
            v.incrementalUpdateFromEventThread();
        }
    }

    void incrementalUpdateFromJobThread() {
        try {
            EventQueue.invokeAndWait(this.updateRunnable);
        }
        catch (InterruptedException ex) {
            this.getPrimary().repaint();
        }
    }

    void applyNewFontSize(int newFontSize) {
        for (ViewInterface v : this.views) {
            v.applyNewFontSize(newFontSize, 0);
        }
    }

    public void shapeChanged(Shape shape) {
        for (ViewInterface view2 : this.views) {
            view2.shapeChanged(shape);
        }
    }

    public boolean mouseDown() {
        for (ViewInterface view2 : this.views) {
            if (!view2.mouseDown()) continue;
            return true;
        }
        return false;
    }

    public boolean mouseInside() {
        for (ViewInterface view2 : this.views) {
            if (!view2.mouseInside()) continue;
            return true;
        }
        return false;
    }

    public double mouseXCor() {
        for (ViewInterface view2 : this.views) {
            if (!view2.mouseInside()) continue;
            return view2.mouseXCor();
        }
        return this.getPrimary().mouseXCor();
    }

    public double mouseYCor() {
        for (ViewInterface view2 : this.views) {
            if (!view2.mouseInside()) continue;
            return view2.mouseYCor();
        }
        return this.getPrimary().mouseYCor();
    }

    public void resetMouseCors() {
        for (ViewInterface view2 : this.views) {
            view2.resetMouseCors();
        }
    }
}

