/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.awt.Image;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Link;
import org.nlogo.api.World;
import org.nlogo.render.AbstractTopologyRenderer;
import org.nlogo.render.Drawable;
import org.nlogo.render.LinkDrawer;

public strictfp class TorusRenderer
extends AbstractTopologyRenderer {
    public TorusRenderer(World world) {
        super(world);
    }

    @Override
    public void fillBackground(GraphicsInterface g) {
    }

    @Override
    public void wrapDrawable(Drawable obj, GraphicsInterface g, double xcor, double ycor, double turtleSize, double cellSize) {
        double size = turtleSize * cellSize + obj.adjustSize(turtleSize, cellSize);
        double offset = size / 2.0;
        double x = this.graphicsX(xcor, cellSize) - offset;
        double y = this.graphicsY(ycor, cellSize) - offset;
        g.push();
        g.translate(x, y);
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        this.draw(obj, g, x, y, 0.0, 0.0, size);
        if (x + size > (double)this.width) {
            this.draw(obj, g, x, y, this.width, 0.0, size);
            wrapXRight = true;
        }
        if (x < 0.0) {
            this.draw(obj, g, x, y, -this.width, 0.0, size);
            wrapXLeft = true;
        }
        if (y + size > (double)this.height) {
            this.draw(obj, g, x, y, 0.0, this.height, size);
            if (wrapXRight) {
                this.draw(obj, g, x, y, this.width, this.height, size);
            }
            if (wrapXLeft) {
                this.draw(obj, g, x, y, -this.width, this.height, size);
            }
        }
        if (y < 0.0) {
            this.draw(obj, g, x, y, 0.0, -this.height, size);
            if (wrapXRight) {
                this.draw(obj, g, x, y, this.width, -this.height, size);
            }
            if (wrapXLeft) {
                this.draw(obj, g, x, y, -this.width, -this.height, size);
            }
        }
        g.pop();
    }

    @Override
    public void drawLabelHelper(GraphicsInterface g, double xcor, double ycor, String label, Object color, double patchSize, double size) {
        double x = this.graphicsX(xcor + 0.5 * size, patchSize);
        double y = this.graphicsY(ycor - 0.5 * size, patchSize);
        int labelWidth = g.getFontMetrics().stringWidth(label);
        int labelHeight = g.getFontMetrics().getHeight();
        g.setColor(org.nlogo.api.Color.getColor(color));
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        this.drawLabel(label, g, x, y, 0.0, 0.0, patchSize);
        if (x > (double)this.width) {
            this.drawLabel(label, g, x, y, this.width, 0.0, patchSize);
            wrapXRight = true;
        }
        if (x - (double)labelWidth < 0.0) {
            this.drawLabel(label, g, x, y, -this.width, 0.0, patchSize);
            wrapXLeft = true;
        }
        if (y > (double)this.height) {
            this.drawLabel(label, g, x, y, 0.0, this.height, patchSize);
            if (wrapXRight) {
                this.drawLabel(label, g, x, y, this.width, this.height, patchSize);
            }
            if (wrapXLeft) {
                this.drawLabel(label, g, x, y, -this.width, this.height, patchSize);
            }
        }
        if (y - (double)labelHeight < 0.0) {
            this.drawLabel(label, g, x, y, 0.0, -this.height, patchSize);
            if (wrapXRight) {
                this.drawLabel(label, g, x, y, this.width, -this.height, patchSize);
            }
            if (wrapXLeft) {
                this.drawLabel(label, g, x, y, -this.width, -this.height, patchSize);
            }
        }
    }

    @Override
    public void paintAllPatchesBlack(GraphicsInterface g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.width, this.height);
    }

    @Override
    public void paintViewImage(GraphicsInterface g, Image image) {
        super.paintViewImage(g, image);
        int x = this.worldAndViewPreMultipliedX;
        int y = this.worldAndViewPreMultipliedY;
        if (this.worldAndViewPreMultipliedX > 0) {
            x = this.worldAndViewPreMultipliedX - this.width;
        } else if (this.worldAndViewPreMultipliedX < 0) {
            x = this.worldAndViewPreMultipliedX + this.width;
        }
        if (this.worldAndViewPreMultipliedY > 0) {
            y = this.worldAndViewPreMultipliedY - this.height;
        } else if (this.worldAndViewPreMultipliedY < 0) {
            y = this.worldAndViewPreMultipliedY + this.height;
        }
        boolean wrapX = false;
        boolean wrapY = false;
        if (x != 0) {
            g.drawImage(image, x, this.worldAndViewPreMultipliedY, this.width, this.height);
            wrapX = true;
        }
        if (y != 0) {
            g.drawImage(image, this.worldAndViewPreMultipliedX, y, this.width, this.height);
            wrapY = true;
        }
        if (wrapX && wrapY) {
            g.drawImage(image, x, y, this.width, this.height);
        }
    }

    @Override
    public void drawLink(GraphicsInterface g, Link link, LinkDrawer.LinkDrawable drawable, double patchSize, Color color, double lineThickness) {
        double x1 = this.graphicsX(link.x1(), patchSize);
        double y1 = this.graphicsY(link.y1(), patchSize);
        double x2 = this.graphicsX(link.x2(), patchSize);
        double y2 = this.graphicsY(link.y2(), patchSize);
        int lineWidth = (int)StrictMath.max(1.0, lineThickness * patchSize);
        g.setStroke(lineWidth);
        g.setColor(color);
        drawable.draw(g, link, color, x1, y1, x2, y2, patchSize, lineThickness);
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        if (x2 + (double)lineWidth > (double)this.width) {
            drawable.draw(g, link, color, x1 - (double)this.width, y1, x2 - (double)this.width, y2, patchSize, lineThickness);
            wrapXRight = true;
        }
        if (x2 - (double)lineWidth < 0.0) {
            drawable.draw(g, link, color, x1 + (double)this.width, y1, x2 + (double)this.width, y2, patchSize, lineThickness);
            wrapXLeft = true;
        }
        if (y2 + (double)lineWidth > (double)this.height) {
            drawable.draw(g, link, color, x1, y1 - (double)this.height, x2, y2 - (double)this.height, patchSize, lineThickness);
            if (wrapXRight) {
                drawable.draw(g, link, color, x1 - (double)this.width, y1 - (double)this.height, x2 - (double)this.width, y2 - (double)this.height, patchSize, lineThickness);
            }
            if (wrapXLeft) {
                drawable.draw(g, link, color, x1 + (double)this.width, y1 - (double)this.height, x2 + (double)this.width, y2 - (double)this.height, patchSize, lineThickness);
            }
        }
        if (y2 - (double)lineWidth < 0.0) {
            drawable.draw(g, link, color, x1, y1 + (double)this.height, x2, y2 + (double)this.height, patchSize, lineThickness);
            if (wrapXRight) {
                drawable.draw(g, link, color, x1 - (double)this.width, y1 + (double)this.height, x2 - (double)this.width, y2 + (double)this.height, patchSize, lineThickness);
            }
            if (wrapXLeft) {
                drawable.draw(g, link, color, x1 + (double)this.width, y1 + (double)this.height, x2 + (double)this.width, y2 + (double)this.height, patchSize, lineThickness);
            }
        }
    }

    @Override
    public void drawLine(GraphicsInterface g, double startX, double startY, double endX, double endY, double penSize) {
        double x1 = this.graphicsXNoOffset(startX, this.world.patchSize());
        double y1 = this.graphicsYNoOffset(startY, this.world.patchSize());
        double x2 = this.graphicsXNoOffset(endX, this.world.patchSize());
        double y2 = this.graphicsYNoOffset(endY, this.world.patchSize());
        double size = penSize / 2.0;
        g.drawLine(x1, y1, x2, y2);
        if (penSize > 1.0) {
            boolean wrapXLeft = false;
            boolean wrapXRight = false;
            if (x2 + size > (double)this.width) {
                g.drawLine(x1 - (double)this.width, y1, x2 - (double)this.width, y2);
                wrapXRight = true;
            }
            if (x1 - size < 0.0) {
                g.drawLine(x1 + (double)this.width, y1, x2 + (double)this.width, y2);
                wrapXLeft = true;
            }
            if (y2 + size > (double)this.width) {
                g.drawLine(x1, y1 - (double)this.height, x2, y2 - (double)this.height);
                if (wrapXRight) {
                    g.drawLine(x1 - (double)this.width, y1 - (double)this.height, x2 - (double)this.width, y2 - (double)this.height);
                }
                if (wrapXLeft) {
                    g.drawLine(x1 + (double)this.width, y1 - (double)this.height, x2 + (double)this.width, y2 - (double)this.height);
                }
            } else if (y1 - size < 0.0) {
                g.drawLine(x1, y1 + (double)this.height, x2, y2 + (double)this.height);
                if (wrapXRight) {
                    g.drawLine(x1 - (double)this.width, y1 + (double)this.height, x2 - (double)this.width, y2 + (double)this.height);
                }
                if (wrapXLeft) {
                    g.drawLine(x1 + (double)this.width, y1 + (double)this.height, x2 + (double)this.width, y2 + (double)this.height);
                }
            }
        }
    }

    @Override
    public double graphicsX(double xcor, double patchSize, double viewOffsetX) {
        return patchSize * (xcor - (double)this.world.minPxcor() + 0.5 - viewOffsetX);
    }

    @Override
    public double graphicsY(double ycor, double patchSize, double viewOffsetY) {
        return patchSize * (-ycor + (double)this.world.maxPycor() + 0.5 + viewOffsetY);
    }
}

