/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Date;
import org.nlogo.api.Exceptions$;
import org.nlogo.hubnet.protocol.DiscoveryMessage;
import org.nlogo.hubnet.protocol.DiscoveryMessage$;
import org.nlogo.hubnet.server.HubNetUtils$;
import scala.UninitializedFieldError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0004\b\u0001/!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003\"\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u000bm\u0002A\u0011\u0001\u001f\t\u000f\r\u0003!\u0019!C\u0005\t\"11\n\u0001Q\u0001\n\u0015Cq\u0001\u0014\u0001A\u0002\u0013%Q\nC\u0004R\u0001\u0001\u0007I\u0011\u0002*\t\ra\u0003\u0001\u0015)\u0003O\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015y\u0006\u0001\"\u0011_\u0005I!\u0015n]2pm\u0016\u0014\u00180\u00118o_Vt7-\u001a:\u000b\u0005=\u0001\u0012AB:feZ,'O\u0003\u0002\u0012%\u00051\u0001.\u001e2oKRT!a\u0005\u000b\u0002\u000b9dwnZ8\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t1A\u000b\u001b:fC\u0012\f\u0001\"\u001e8jcV,\u0017\n\u001a\t\u0003E-r!aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u00192\u0012A\u0002\u001fs_>$hHC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQs%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y5\u0012aa\u0015;sS:<'B\u0001\u0016(\u0003%iw\u000eZ3m\u001d\u0006lW-\u0001\u0006q_J$h*^7cKJ\u0004\"!\r\u001a\u000e\u0003\u001dJ!aM\u0014\u0003\u0007%sG/A\u0004bI\u0012\u0014Xm]:\u0011\u0005YJT\"A\u001c\u000b\u0005ab\u0012a\u00018fi&\u0011!h\u000e\u0002\f\u0013:,G/\u00113ee\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0006{}\u0002\u0015I\u0011\t\u0003}\u0001i\u0011A\u0004\u0005\u0006A\u0015\u0001\r!\t\u0005\u0006]\u0015\u0001\r!\t\u0005\u0006_\u0015\u0001\r\u0001\r\u0005\u0006i\u0015\u0001\r!N\u0001\b[\u0016\u001c8/Y4f+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%\u0011\u0003!\u0001(o\u001c;pG>d\u0017B\u0001&H\u0005A!\u0015n]2pm\u0016\u0014\u00180T3tg\u0006<W-\u0001\u0005nKN\u001c\u0018mZ3!\u0003%\u0019\bn\\;mIJ+h.F\u0001O!\t\tt*\u0003\u0002QO\t9!i\\8mK\u0006t\u0017!D:i_VdGMU;o?\u0012*\u0017\u000f\u0006\u0002T-B\u0011\u0011\u0007V\u0005\u0003+\u001e\u0012A!\u00168ji\"9q+CA\u0001\u0002\u0004q\u0015a\u0001=%c\u0005Q1\u000f[8vY\u0012\u0014VO\u001c\u0011)\u0005)Q\u0006CA\u0019\\\u0013\tavE\u0001\u0005w_2\fG/\u001b7f\u0003!\u0019\b.\u001e;e_^tG#A*\u0002\u0007I,h\u000e")
public class DiscoveryAnnouncer
extends Thread {
    private final InetAddress address;
    private final DiscoveryMessage message;
    private volatile boolean shouldRun;
    private volatile byte bitmap$init$0;

    private DiscoveryMessage message() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/hubnet/server/DiscoveryAnnouncer.scala: 17");
        }
        return this.message;
    }

    private boolean shouldRun() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/hubnet/server/DiscoveryAnnouncer.scala: 18");
        }
        return this.shouldRun;
    }

    private void shouldRun_$eq(boolean x$1) {
        this.shouldRun = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public void shutdown() {
        this.shouldRun_$eq(false);
    }

    @Override
    public void run() {
        MulticastSocket multicastSocket;
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_GROUP());
        }
        catch (UnknownHostException uhe) {
            DiscoveryAnnouncer.dump$1(new StringBuilder(52).append("could not map the multicast group ").append(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_GROUP()).append(" to an InetAddress").toString(), uhe);
            return;
        }
        InetAddress group = inetAddress;
        try {
            multicastSocket = new MulticastSocket(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT());
        }
        catch (IOException ioe) {
            DiscoveryAnnouncer.dump$1(new StringBuilder(40).append("Error creating multicast socket to port ").append(HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT()).toString(), ioe);
            return;
        }
        MulticastSocket multicastSocket2 = multicastSocket;
        while (this.shouldRun()) {
            byte[] messageBytes = this.message().toByteArray();
            try {
                multicastSocket2.setTimeToLive(63);
                multicastSocket2.setInterface(this.address);
                multicastSocket2.send(new DatagramPacket(messageBytes, messageBytes.length, group, HubNetUtils$.MODULE$.SERVER_DISCOVERY_MULTICAST_PORT()));
            }
            catch (IOException ioe) {
                DiscoveryAnnouncer.dump$1("Could not transmit multicast announcement.", ioe);
            }
            try {
                Thread.sleep(HubNetUtils$.MODULE$.SERVER_DISCOVERY_ANNOUNCE_INTERVAL());
            }
            catch (InterruptedException ie) {
                DiscoveryAnnouncer.dump$1("Multicast announcement thread interrupted.\n\t", ie);
            }
        }
        try {
            multicastSocket2.close();
            return;
        }
        catch (RuntimeException e) {
            Exceptions$.MODULE$.ignore(e);
            return;
        }
    }

    private static final void dump$1(String err, Exception ex) {
        System.err.println(new StringBuilder(5).append("@ ").append(new Date()).append(" : ").toString());
        System.err.println(new StringBuilder(9).append("Error: ").append(err).append("\n\t").append(ex).toString());
    }

    public DiscoveryAnnouncer(String uniqueId, String modelName, int portNumber, InetAddress address) {
        this.address = address;
        this.message = DiscoveryMessage$.MODULE$.apply(uniqueId, modelName, portNumber);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.shouldRun = true;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }
}

