/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import org.nlogo.agent.PenLineMaker;
import org.nlogo.agent.Trail;
import org.nlogo.api.Numbers$;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcDD$sp;

public final class PenLineMaker$ {
    public static PenLineMaker$ MODULE$;
    private volatile boolean bitmap$init$0;

    static {
        new PenLineMaker$();
    }

    public Trail[] jumpLine(double x2, double y2, double heading, double jumpDist2, double minX, double maxX, double minY, double maxY) {
        if (jumpDist2 == 0.0) {
            return (Trail[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Trail.class));
        }
        Function3<Object, Object, Object, Seq> & Serializable & scala.Serializable makeTrailsBy = (Function3<Object, Object, Object, Seq> & Serializable & scala.Serializable)(x, y, jumpDist) -> PenLineMaker$.MODULE$.makeTrails(heading, minX, maxX, minY, maxY, BoxesRunTime.unboxToDouble(x), BoxesRunTime.unboxToDouble(y), BoxesRunTime.unboxToDouble(jumpDist));
        JFunction1$mcDD$sp & scala.Serializable lazyWrapX = (JFunction1$mcDD$sp & scala.Serializable)value -> MODULE$.lazyWrapValue(minX, maxX, value);
        JFunction1$mcDD$sp & scala.Serializable lazyWrapY = (JFunction1$mcDD$sp & scala.Serializable)value -> MODULE$.lazyWrapValue(minY, maxY, value);
        return (Trail[])this.helper(x2, y2, jumpDist2, new PenLineMaker.HelperContext((Function3<Object, Object, Object, Seq<Trail>>)makeTrailsBy, lazyWrapX, lazyWrapY), this.helper$default$5()).toArray(ClassTag$.MODULE$.apply(Trail.class));
    }

    public Trail[] translate(double x0, double y0, double x1, double y1) {
        double dist = StrictMath.sqrt(StrictMath.pow(x0 - x1, 2.0) + StrictMath.pow(y0 - y1, 2.0));
        if (dist == 0.0) {
            return (Trail[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.apply(Trail.class));
        }
        return (Trail[])((Object[])new Trail[]{new Trail(x0, y0, x1, y1, dist)});
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Trail> helper(double x, double y, double jumpDist, PenLineMaker.HelperContext context, Seq<Trail> acc) {
        while (true) {
            double nextJumpDist;
            void var11_8;
            void var10_7;
            void var9_6;
            if (context == null) {
                throw new MatchError((Object)null);
            }
            Function3<Object, Object, Object, Seq<Trail>> makeTrailsBy = context.makeTrailsBy();
            Function1<Object, Object> lazyWrapX = context.lazyWrapX();
            Function1<Object, Object> lazyWrapY = context.lazyWrapY();
            void makeTrailsBy2 = var9_6;
            void lazyWrapX2 = var10_7;
            void lazyWrapY2 = var11_8;
            Trail trail = (Trail)((Seq)makeTrailsBy2.apply(BoxesRunTime.boxToDouble(x), BoxesRunTime.boxToDouble(y), BoxesRunTime.boxToDouble(jumpDist))).minBy((Function1<Trail, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble(x$2.dist()), Ordering.Double$.MODULE$);
            Seq<Trail> newAcc = acc.$colon$plus(trail, Seq$.MODULE$.canBuildFrom());
            double d = nextJumpDist = jumpDist >= 0.0 ? jumpDist - trail.dist() : jumpDist + trail.dist();
            if (nextJumpDist == 0.0) {
                return newAcc;
            }
            double newX = lazyWrapX2.apply$mcDD$sp(trail.x2());
            double newY = lazyWrapY2.apply$mcDD$sp(trail.y2());
            acc = newAcc;
            jumpDist = nextJumpDist;
            y = newY;
            x = newX;
        }
    }

    private Seq<Trail> helper$default$5() {
        return Nil$.MODULE$;
    }

    private double lazyWrapValue(double min, double max, double value) {
        if (value <= min) {
            return max;
        }
        if (value >= max) {
            return min;
        }
        return value;
    }

    private double distanceFromLegs(double l1, double l2) {
        return StrictMath.sqrt(PenLineMaker$.$anonfun$distanceFromLegs$1(l1) + PenLineMaker$.$anonfun$distanceFromLegs$1(l2));
    }

    private Seq<Trail> makeTrails(double heading, double minX, double maxX, double minY, double maxY, double x2, double y, double jumpDist) {
        Option option;
        None$ yInterceptTrails;
        Option option2;
        JFunction1$mcDD$sp & scala.Serializable squash = (JFunction1$mcDD$sp & scala.Serializable)x -> {
            if (StrictMath.abs(x) < Numbers$.MODULE$.Infinitesimal()) {
                return 0.0;
            }
            return x;
        };
        double xcomp = ((JFunction1$mcDD$sp & scala.Serializable)(JFunction1$mcDD$sp & scala.Serializable)x$1 -> StrictMath.toRadians(x$1)).andThen((JFunction1$mcDD$sp & scala.Serializable)x$1 -> StrictMath.sin(x$1)).andThen(squash).apply$mcDD$sp(heading);
        double ycomp = ((JFunction1$mcDD$sp & scala.Serializable)(JFunction1$mcDD$sp & scala.Serializable)x$1 -> StrictMath.toRadians(x$1)).andThen((JFunction1$mcDD$sp & scala.Serializable)x$1 -> StrictMath.cos(x$1)).andThen(squash).apply$mcDD$sp(heading);
        double tan = ((JFunction1$mcDD$sp & scala.Serializable)(JFunction1$mcDD$sp & scala.Serializable)x$1 -> StrictMath.toRadians(x$1)).andThen((JFunction1$mcDD$sp & scala.Serializable)x$1 -> StrictMath.tan(x$1)).andThen(squash).apply$mcDD$sp(heading);
        double rawX = x2 + xcomp * jumpDist;
        double rawY = y + ycomp * jumpDist;
        Option<Trail> baseTrails = Option$.MODULE$.apply(new Trail(x2, y, rawX, rawY, jumpDist < 0.0 ? jumpDist * (double)-1 : jumpDist));
        if (rawX > maxX) {
            double dx = maxX - x2;
            double dy = dx / tan;
            double interceptY = y + dy;
            option2 = Option$.MODULE$.apply(new Trail(x2, y, maxX, interceptY, PenLineMaker$.MODULE$.distanceFromLegs(dx, dy)));
        } else if (rawX < minX) {
            double dx = x2 - minX;
            double dy = dx / tan;
            double interceptY = y - dy;
            option2 = Option$.MODULE$.apply(new Trail(x2, y, minX, interceptY, PenLineMaker$.MODULE$.distanceFromLegs(dx, dy)));
        } else {
            option2 = yInterceptTrails = None$.MODULE$;
        }
        if (rawY > maxY) {
            double dy = maxY - y;
            double dx = dy * tan;
            double interceptX = x2 + dx;
            option = Option$.MODULE$.apply(new Trail(x2, y, interceptX, maxY, PenLineMaker$.MODULE$.distanceFromLegs(dx, dy)));
        } else if (rawY < minY) {
            double dy = y - minY;
            double dx = dy * tan;
            double interceptX = x2 - dx;
            option = Option$.MODULE$.apply(new Trail(x2, y, interceptX, minY, PenLineMaker$.MODULE$.distanceFromLegs(dx, dy)));
        } else {
            option = None$.MODULE$;
        }
        None$ xInterceptTrails = option;
        return ((TraversableOnce)((TraversableLike)Option$.MODULE$.option2Iterable(baseTrails).$plus$plus(Option$.MODULE$.option2Iterable(xInterceptTrails), Iterable$.MODULE$.canBuildFrom())).$plus$plus(Option$.MODULE$.option2Iterable(yInterceptTrails), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ double $anonfun$distanceFromLegs$1(double x) {
        return StrictMath.pow(x, 2.0);
    }

    private PenLineMaker$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Option $anonfun$makeTrails$8$adapted(double x$3, double y$1, Object endX, Object endY, Object dx, Object dy) {
        return Option$.MODULE$.apply(new Trail(x$3, y$1, BoxesRunTime.unboxToDouble(endX), BoxesRunTime.unboxToDouble(endY), PenLineMaker$.MODULE$.distanceFromLegs(BoxesRunTime.unboxToDouble(dx), BoxesRunTime.unboxToDouble(dy))));
    }
}

