/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.ArrayList;
import java.util.Arrays;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentColors;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.IndexedAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.World;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.I18N;
import org.nlogo.core.LogoList;
import org.nlogo.core.Program;

public strictfp class Patch
extends Agent
implements org.nlogo.api.Patch,
AgentColors {
    public static final int VAR_PXCOR = 0;
    public static final int VAR_PYCOR = 1;
    public static final int VAR_PCOLOR = 2;
    public static final int VAR_PLABEL = 3;
    public static final int VAR_PLABELCOLOR = 4;
    public static final int LAST_PREDEFINED_VAR = 4;
    public int NUMBER_PREDEFINED_VARS = 5;
    private final ArrayList<Turtle> _turtlesHere = new ArrayList(0);
    public IndexedAgentSet patchNeighbors;
    public IndexedAgentSet patchNeighbors4;
    public final int pxcor;
    public final int pycor;
    public static final int BIT = 4;

    @Override
    public AgentKind kind() {
        return AgentKindJ.Patch();
    }

    public Iterable<Turtle> turtlesHere() {
        return this._turtlesHere;
    }

    public int turtleCount() {
        return this._turtlesHere.size();
    }

    public void clearTurtles() {
        this._turtlesHere.clear();
    }

    public void addTurtle(Turtle t) {
        this._turtlesHere.add(t);
    }

    public void removeTurtle(Turtle t) {
        this._turtlesHere.remove(t);
    }

    public AgentSet turtlesHereAgentSet() {
        return AgentSet.fromArray(AgentKindJ.Turtle(), this._turtlesHere.toArray(new Turtle[this._turtlesHere.size()]));
    }

    void topologyChanged() {
        this.patchNeighbors = null;
        this.patchNeighbors4 = null;
    }

    Patch(World world, int id, int pxcor, int pycor, int numVariables) {
        super(world);
        this.setId(id);
        this.pxcor = pxcor;
        this.pycor = pycor;
        Object[] variables = new Object[numVariables];
        this.setVariables(variables);
        block7: for (int i = 0; i < numVariables; ++i) {
            switch (i) {
                case 0: {
                    variables[i] = (double)pxcor;
                    continue block7;
                }
                case 1: {
                    variables[i] = (double)pycor;
                    continue block7;
                }
                case 2: {
                    variables[i] = (double)World.Zero();
                    continue block7;
                }
                case 3: {
                    variables[i] = "";
                    continue block7;
                }
                case 4: {
                    variables[i] = Color.BoxedWhite();
                    continue block7;
                }
                default: {
                    variables[i] = World.Zero();
                }
            }
        }
    }

    Patch(World world, int pxcor, int pycor) {
        super(world);
        this.pxcor = pxcor;
        this.pycor = pycor;
    }

    @Override
    public Agent realloc(Program oldProgram, Program newProgram) {
        int i;
        boolean forRecompile = oldProgram != null;
        Object[] oldvars = this._variables;
        Object[] newvars = new Object[this._world.getVariablesArraySize(this)];
        for (i = 0; newvars.length != i; ++i) {
            newvars[i] = i < this.NUMBER_PREDEFINED_VARS ? oldvars[i] : World.Zero();
        }
        if (forRecompile) {
            for (i = this.NUMBER_PREDEFINED_VARS; i < oldvars.length && i < oldProgram.patchesOwn().size(); ++i) {
                String name = (String)oldProgram.patchesOwn().apply(i);
                int newpos = this._world.patchesOwnIndexOf(name);
                if (newpos == -1) continue;
                newvars[newpos] = oldvars[i];
            }
        }
        this.setVariables(newvars);
        return null;
    }

    @Override
    public Object getTurtleVariable(int vn) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public Object getLinkVariable(int vn) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public Object getTurtleOrLinkVariable(String varName) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessTurtleOrLinkWithoutSpecifyingAgent"));
    }

    @Override
    public Object getLinkBreedVariable(String name) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public Object getBreedVariable(String name) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public Object getVariable(int vn) {
        return this.getPatchVariable(vn);
    }

    @Override
    public String variableName(int vn) {
        return this._world.patchesOwnNameAt(vn);
    }

    @Override
    public void setTurtleVariable(int vn, Object value) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantSetTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public void setTurtleVariable(int vn, double value) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantSetTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public void setBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantSetTurtleWithoutSpecifyingTurtle"));
    }

    @Override
    public void setLinkVariable(int vn, Object value) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public void setLinkVariable(int vn, double value) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public void setTurtleOrLinkVariable(String varName, Object value) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessTurtleOrLinkWithoutSpecifyingAgent"));
    }

    @Override
    public void setLinkBreedVariable(String name, Object value) throws AgentException {
        throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantAccessLinkVarWithoutSpecifyingLink"));
    }

    @Override
    public void setVariable(int vn, Object value) throws AgentException {
        this.setPatchVariable(vn, value);
    }

    void clearProgramVariables() {
        Arrays.fill(this._variables, this.NUMBER_PREDEFINED_VARS, this._variables.length, World.Zero());
    }

    @Override
    public void setPatchVariable(int vn, Object value) throws AgentException {
        if (vn > 4) {
            this._variables[vn] = value;
        } else {
            switch (vn) {
                case 2: {
                    if (value instanceof Double) {
                        this.pcolor((Double)value);
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.pcolor((LogoList)value, 2, false);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(false)[vn], Double.class, value);
                    break;
                }
                case 3: {
                    this.label(value);
                    break;
                }
                case 4: {
                    if (value instanceof Double) {
                        this.labelColor((double)((Double)value));
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.labelColor((LogoList)value, 4);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(false)[vn], Double.class, value);
                    break;
                }
                case 0: 
                case 1: {
                    throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantChangePatchCoordinates"));
                }
                default: {
                    throw new IllegalStateException(I18N.errorsJ().getN("org.nlogo.agent.Agent.cantSetUnknownVariable", vn));
                }
            }
        }
        this._world.notifyWatchers(this, vn, value);
    }

    @Override
    public void setPatchVariable(int vn, double value) throws AgentException {
        switch (vn) {
            case 0: {
                throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantChangePatchCoordinates"));
            }
            case 1: {
                throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Patch.cantChangePatchCoordinates"));
            }
        }
        throw new IllegalArgumentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.notADoubleVariable", vn));
    }

    @Override
    public Object getPatchVariable(int vn) {
        return this._variables[vn];
    }

    public double getPatchVariableDouble(int vn) {
        switch (vn) {
            case 0: {
                return this.pxcor;
            }
            case 1: {
                return this.pycor;
            }
        }
        throw new IllegalArgumentException(I18N.errorsJ().getN("org.nlogo.agent.Agent.notADoubleVariable", Integer.toString(vn)));
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        org.nlogo.api.Patch target = this._world.getPatchAt((double)this.pxcor + dx, (double)this.pycor + dy);
        if (target == null) {
            throw new AgentException(I18N.errorsJ().get("org.nlogo.agent.Turtle.patchBeyondLimits"));
        }
        return target;
    }

    public Patch fastGetPatchAt(int x, int y) {
        return this._world.fastGetPatchAt(x, y);
    }

    public IndexedAgentSet getNeighbors() {
        if (this.patchNeighbors == null) {
            this.patchNeighbors = this._world.topology().getNeighbors(this);
        }
        return this.patchNeighbors;
    }

    public IndexedAgentSet getNeighbors4() {
        if (this.patchNeighbors4 == null) {
            this.patchNeighbors4 = this._world.topology().getNeighbors4(this);
        }
        return this.patchNeighbors4;
    }

    public Turtle sprout(int c, int heading, AgentSet breed) {
        Turtle child = this._world.sprout(this, breed);
        double color = 5 + 10 * c;
        child.colorDoubleUnchecked(color);
        child.heading(heading);
        return child;
    }

    @Override
    public Object pcolor() {
        return this._variables[2];
    }

    public void pcolor(double pcolor) {
        Object currentColor;
        if (pcolor < 0.0 || pcolor >= (double)Color.MaxColor()) {
            pcolor = Color.modulateDouble(pcolor);
        }
        if (!((currentColor = this._variables[2]) instanceof Double) || (Double)currentColor != pcolor) {
            Double boxedColor = pcolor;
            this._variables[2] = boxedColor;
            this._world.patchChangedColorAt((int)this._id, pcolor);
        }
    }

    public void pcolor(Double boxedColor) {
        Object currentColor;
        double color = boxedColor;
        if (color < 0.0 || color >= (double)Color.MaxColor()) {
            color = Color.modulateDouble(color);
            boxedColor = color;
        }
        if (!((currentColor = this._variables[2]) instanceof Double) || (Double)currentColor != color) {
            this._variables[2] = boxedColor;
            this._world.patchChangedColorAt((int)this._id, color);
        }
    }

    public void pcolorDoubleUnchecked(Double boxedColor) {
        double color = boxedColor;
        Object currentColor = this._variables[2];
        if (!(currentColor instanceof Double) || (Double)currentColor != color) {
            this._variables[2] = boxedColor;
            this._world.patchChangedColorAt((int)this._id, color);
        }
    }

    public void pcolor(LogoList rgb) throws AgentException {
        this.pcolor(rgb, 2, true);
    }

    public void pcolor(LogoList rgb, int varIndex, boolean allowAlpha) throws AgentException {
        this.validRGBList(rgb, allowAlpha);
        if (!(this._variables[varIndex] instanceof LogoList) || !rgb.equals(this._variables[varIndex])) {
            this._variables[varIndex] = rgb;
            int red = ((Double)rgb.get(0)).intValue();
            int green = ((Double)rgb.get(1)).intValue();
            int blue = ((Double)rgb.get(2)).intValue();
            this._world.patchColors()[(int)this._id] = Color.getRGBInt(red, green, blue);
            this._world.markPatchColorsDirty();
            if (red % 10 != 0 || green % 10 != 0 || blue % 10 != 0) {
                this._world.patchesAllBlack(false);
            }
            if (rgb.size() > 3) {
                this._world.mayHavePartiallyTransparentObjects(true);
            }
        }
    }

    @Override
    public int pxcor() {
        return this.pxcor;
    }

    @Override
    public int pycor() {
        return this.pycor;
    }

    public Object label() {
        return this._variables[3];
    }

    @Override
    public boolean hasLabel() {
        return !(this.label() instanceof String) || ((String)this.label()).length() != 0;
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this._variables[3]);
    }

    public void label(Object label) {
        if (label instanceof String && ((String)label).length() == 0) {
            if (this.hasLabel()) {
                this._world.removePatchLabel();
            }
        } else if (!this.hasLabel()) {
            this._world.addPatchLabel();
        }
        this._variables[3] = label;
    }

    @Override
    public Object labelColor() {
        return this._variables[4];
    }

    public void labelColor(double labelColor) {
        this._variables[4] = Color.modulateDouble(labelColor);
    }

    public void labelColor(Double labelColor) {
        this._variables[4] = labelColor;
    }

    public void labelColor(LogoList rgb, int varIndex) throws AgentException {
        this.validRGBList(rgb, true);
        this._variables[varIndex] = rgb;
    }

    public String toString() {
        return "patch " + this.pxcor + " " + this.pycor;
    }

    @Override
    public String classDisplayName() {
        return "patch";
    }

    @Override
    public int agentBit() {
        return 4;
    }

    @Override
    public String shape() {
        return "";
    }

    @Override
    public double size() {
        return 1.0;
    }

    public Patch getPatchNorth() {
        return this._world.topology().getPN(this);
    }

    public Patch getPatchSouth() {
        return this._world.topology().getPS(this);
    }

    public Patch getPatchEast() {
        return this._world.topology().getPE(this);
    }

    public Patch getPatchWest() {
        return this._world.topology().getPW(this);
    }

    public Patch getPatchNorthWest() {
        return this._world.topology().getPNW(this);
    }

    public Patch getPatchSouthWest() {
        return this._world.topology().getPSW(this);
    }

    public Patch getPatchSouthEast() {
        return this._world.topology().getPSE(this);
    }

    public Patch getPatchNorthEast() {
        return this._world.topology().getPNE(this);
    }

    @Override
    public int alpha() {
        return Color.getColor(this.pcolor()).getAlpha();
    }
}

